package com.merlin204.tde.client.keymapping;

import com.merlin204.tde.client.keymapping.CombatKeyMapping;
import com.mojang.blaze3d.platform.InputConstants.Type;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber.Bus;

@EventBusSubscriber(
   value = {Dist.CLIENT},
   bus = Bus.MOD
)
public class TDEKeyMappings {

   public static final KeyMapping SOULFIRE_SKILL = new KeyMapping("key.tde.soul_fire", 67, "key.tde.common");
   public static final KeyMapping CHARGED_ATTACK = new KeyMapping("key.tde.charge_attack", Type.MOUSE, 4, "key.tde.common");
   public static final KeyMapping BASIC_ATTACK = new KeyMapping("key.tde.basic_attack", Type.MOUSE, 0, "key.tde.common");
   public static final KeyMapping GUARD = new KeyMapping("key.tde.guard", Type.MOUSE, 1, "key.tde.common");
   public static final KeyMapping LOCK_ON = new KeyMapping("key.tde.lockon", Type.MOUSE, 2, "key.tde.common");
   public static final KeyMapping LOCK_ON_CHANGE = new CombatKeyMapping("key.tde.lockon_change", KeyConflictContext.IN_GAME, KeyModifier.CONTROL, Type.MOUSE, 2, "key.tde.common");
   public static final KeyMapping INTERACTION = new KeyMapping("key.tde.interaction", 82, "key.tde.common");
   public static final KeyMapping SKILL = new KeyMapping("key.tde.skill", Type.MOUSE, 3, "key.tde.common");


   @SubscribeEvent
   public static void registerKeys(RegisterKeyMappingsEvent event) {
      event.register(SOULFIRE_SKILL);
      event.register(CHARGED_ATTACK);
      event.register(BASIC_ATTACK);
      event.register(GUARD);
      event.register(LOCK_ON);
      event.register(INTERACTION);
      event.register(LOCK_ON_CHANGE);
      event.register(SKILL);
   }

}
