package com.merlin204.tde.client.keymapping;

import com.mojang.blaze3d.platform.InputConstants.Key;
import com.mojang.blaze3d.platform.InputConstants.Type;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import yesman.epicfight.client.ClientEngine;

public class CombatKeyMapping extends KeyMapping {

   public CombatKeyMapping(String pName, int pKeyCode, String pCategory) {
      super(pName, pKeyCode, pCategory);
   }

   public CombatKeyMapping(String pName, Type pType, int pKeyCode, String pCategory) {
      super(pName, pType, pKeyCode, pCategory);
   }

   public CombatKeyMapping(String description, IKeyConflictContext keyConflictContext, Type inputType, int keyCode, String category) {
      super(description, keyConflictContext, inputType, keyCode, category);
   }

   public CombatKeyMapping(String description, IKeyConflictContext keyConflictContext, Key keyCode, String category) {
      super(description, keyConflictContext, keyCode, category);
   }

   public CombatKeyMapping(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, Type inputType, int keyCode, String category) {
      super(description, keyConflictContext, keyModifier, inputType, keyCode, category);
   }

   public CombatKeyMapping(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, Key keyCode, String category) {
      super(description, keyConflictContext, keyModifier, keyCode, category);
   }

   public boolean isActiveAndMatches(Key keyCode) {
      return super.isActiveAndMatches(keyCode) && ClientEngine.getInstance().isBattleMode();
   }
}
