package com.merlin204.tde.client.hud;

import com.merlin204.tde.capabilitiy.player.TDEPlayerCapabilities;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAbilities;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAttribute;
import com.merlin204.tde.client.hud.TDEHudID;
import com.merlin204.tde.client.keymapping.TDEKeyMappings;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.CycleSkill;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.util.TDEAbilityUtils;
import com.merlin204.tde.util.TDEUIUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.RenderGuiEvent.Post;
import net.minecraftforge.client.event.RenderGuiOverlayEvent.Pre;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

public class TDEHud {

   public static TDEHud instance;
   private static final int SOUL_CHANGE_DURATION = 80;
   private static final int KEY_HINTS_RIGHT_MARGIN = 10;
   private static final int KEY_HINTS_BOTTOM_MARGIN = 30;
   private static final int KEY_HINTS_LINE_HEIGHT = 12;
   private static final int SOUL_FIRE_POS_X = 10;
   private static final int BAR_Y_POS_OFFSET = 60;
   private static final int BAR_SHORT_WIDTH = 128;
   private static final int BAR_SHORT_HEIGHT = 5;
   private static final int BAR_LONG_WIDTH = 256;
   private static final int BAR_LONG_HEIGHT = 16;
   private static final int AIR_BAR_POS_Y_OFFSET = 45;
   private static final int AIR_BAR_CUT_BASE = 123;
   private static final int AIR_BAR_MAX = 300;
   private static final int SOUL_COUNT_X = 120;
   private static final int SOUL_COUNT_Y = 20;
   private static final int SKILL_Y_POS_OFFSET = 46;
   private static final int SKILL_SLOT_SPACING = 30;
   private static final int COOLDOWN_OVERLAY_R = 32;
   private static final int COOLDOWN_OVERLAY_G = 32;
   private static final int COOLDOWN_OVERLAY_B = 32;
   private static final int COOLDOWN_OVERLAY_A = 128;
   private static final int SOUL_FIRE_WIDTH = 64;
   private static final int SOUL_FIRE_HEIGHT = 64;
   private static final int SOUL_FIRE_TEX_WIDTH = 1280;
   private static final int SOUL_FIRE_TEX_HEIGHT = 256;
   private static final int LOCK_ON_SIZE = 15;
   private static final int SKILL_SIZE = 24;
   private static final int SKILL_ICON_SIZE = 20;
   private static final int SKILL_ICON_PADDING = 2;
   private static final int NUMBER_TEX_WIDTH = 80;
   private static final int NUMBER_TEX_HEIGHT = 19;
   private static final int LEARN_SKILL_DURATION = 500;
   private static final int LEARN_SKILL_FADE_IN = 60;
   private static final int LEARN_SKILL_FADE_OUT = 60;
   private static final int LEARN_SKILL_POS_Y_OFFSET = 50;
   private static final int LEARN_SKILL_SIZE = 50;
   private static final int LEARN_SKILL_ICON_SIZE = 48;
   private static final List KEY_HINTS = Arrays.asList(new Pair[]{new Pair("key.tde.interaction", TDEKeyMappings.INTERACTION), new Pair("key.tde.basic_attack", TDEKeyMappings.BASIC_ATTACK), new Pair("key.tde.charge_attack", TDEKeyMappings.CHARGED_ATTACK), new Pair("key.tde.guard", TDEKeyMappings.GUARD), new Pair("key.tde.dodge", EpicFightKeyMappings.DODGE), new Pair("key.tde.soul_fire", TDEKeyMappings.SOULFIRE_SKILL), new Pair("key.tde.lockon", TDEKeyMappings.LOCK_ON), new Pair("key.tde.lockon_change", TDEKeyMappings.LOCK_ON_CHANGE), new Pair("key.tde.skill", TDEKeyMappings.SKILL)});
   Minecraft minecraft = Minecraft.m_91087_();
   private float renderhealth;
   private float renderenergy;
   private float rendermana;
   private float lastSoulValue = -1.0F;
   private float soulChangeValue = 0.0F;
   private int soulChangeTimer = 0;
   private int learnSkillTimer = -1;
   private boolean isLearningSkill = false;
   private Skill learningSkill = null;


   public TDEHud() {
      instance = this;
   }

   @SubscribeEvent(
      priority = EventPriority.NORMAL
   )
   public void disableDefaultOverlay(Pre event) {
      NamedGuiOverlay overlay = event.getOverlay();
      if(overlay.id().equals(VanillaGuiOverlay.ITEM_NAME.id()) || overlay.id().equals(VanillaGuiOverlay.ARMOR_LEVEL.id()) || overlay.id().equals(VanillaGuiOverlay.AIR_LEVEL.id()) || overlay.id().equals(VanillaGuiOverlay.EXPERIENCE_BAR.id()) || overlay.id().equals(VanillaGuiOverlay.POTION_ICONS.id()) || overlay.id().equals(VanillaGuiOverlay.FOOD_LEVEL.id()) || overlay.id().equals(VanillaGuiOverlay.PLAYER_HEALTH.id()) || overlay.id().equals(VanillaGuiOverlay.MOUNT_HEALTH.id()) || overlay.id().equals(VanillaGuiOverlay.JUMP_BAR.id())) {
         event.setCanceled(true);
      }

   }

   public void showLearnSkill(Skill skill) {
      this.learnSkillTimer = 0;
      this.isLearningSkill = true;
      this.learningSkill = skill;
   }

   @SubscribeEvent(
      priority = EventPriority.NORMAL
   )
   public void renderOverlay(Post event) {
      LocalPlayer player = this.minecraft.f_91074_;
      Window scaled = this.minecraft.m_91268_();
      if(player != null) {
         if(this.minecraft.f_91074_ != null) {
            GlStateManager._clearColor(1.0F, 1.0F, 1.0F, 1.0F);
            TDELocalPlayerPatch playerPatch = (TDELocalPlayerPatch)EpicFightCapabilities.getEntityPatch(player, TDELocalPlayerPatch.class);
            if(playerPatch != null) {
               if(playerPatch.isEpicFightMode()) {
                  if(player.m_5842_()) {
                     this.getPlayerAirBar(player, scaled, event.getGuiGraphics());
                  } else {
                     this.learnSkill(player, scaled, event.getGuiGraphics());
                     this.renderKeyHints(scaled, event.getGuiGraphics());
                     this.renderSoulCount(player, scaled, event.getGuiGraphics());
                     this.getPlayerBar(player, scaled, event.getGuiGraphics());
                     this.getLockOn(player, scaled, event.getGuiGraphics());
                     this.getSkill(player, scaled, event.getGuiGraphics());
                  }
               } else if(player.m_5842_()) {
                  ;
               }
            }

            this.getSoulFire(player, scaled, event.getGuiGraphics());
         }

      }
   }

   private void getSoulFire(LocalPlayer player, Window scaled, GuiGraphics graphics) {
      int screenHeight = scaled.m_85446_();
      int posY = screenHeight - 74;
      Object move = player.f_19797_ % 20;
      player.getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES);
      posY.ifPresent((NonNullConsumer)move);
   }

   private void getLockOn(LocalPlayer player, Window scaled, GuiGraphics graphics) {
      int screenHeight = scaled.m_85446_();
      int screenWidth = scaled.m_85445_();
      LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
      if(localPlayerPatch instanceof TDELocalPlayerPatch) {
         TDELocalPlayerPatch tdeLocalPlayerPatch = (TDELocalPlayerPatch)localPlayerPatch;
         if(tdeLocalPlayerPatch.isLockon()) {
            ResourceLocation var10000;
            label15: {
               LivingEntity centerY = tdeLocalPlayerPatch.getTarget();
               if(centerY instanceof EnemyEntity) {
                  EnemyEntity centerX = (EnemyEntity)centerY;
                  if(centerX.isKnockdown()) {
                     var10000 = TDEHudID.LOCK_ON_2;
                     break label15;
                  }
               }

               var10000 = TDEHudID.LOCK_ON_1;
            }

            ResourceLocation lockOnTexture = var10000;
            int centerX1 = (screenWidth - 15) / 2;
            int centerY1 = (screenHeight - 15) / 2;
            graphics.m_280163_(lockOnTexture, centerX1, centerY1, 0.0F, 0.0F, 15, 15, 15, 15);
         }
      }

   }

   private void getPlayerBar(LocalPlayer player, Window scaled, GuiGraphics graphics) {
      if(this.renderhealth > player.m_21223_()) {
         this.renderhealth -= 0.05F;
         if(this.renderhealth < player.m_21223_()) {
            this.renderhealth = player.m_21223_();
         }
      } else if(this.renderhealth < player.m_21223_()) {
         this.renderhealth += 0.05F;
         if(this.renderhealth > player.m_21223_()) {
            this.renderhealth = player.m_21223_();
         }
      }

      int screenHeight = scaled.m_85446_();
      int yPos = screenHeight - 60;
      TDEUIUtils.drawDoubleTDEGrowBar(this.renderhealth, player.m_21223_(), player.m_21233_(), 100.0F, yPos, TDEHudID.BAR_LONG, TDEHudID.BAR_HEALTH, TDEHudID.BAR_HEALTH_B, graphics, 256, 10, 254, 10);
      float energy = TDEAbilityUtils.getAbility(AbilityType.ENERGY, player);
      float energyMax = TDEAbilityUtils.getAbilityMax(AbilityType.ENERGY, player);
      float mana = TDEAbilityUtils.getAbility(AbilityType.MANA, player);
      float manaMax = TDEAbilityUtils.getAbilityMax(AbilityType.MANA, player);
      if(this.renderenergy > energy) {
         --this.renderenergy;
         if(this.renderenergy < energy) {
            this.renderenergy = energy;
         }
      } else if(this.renderenergy < energy) {
         ++this.renderenergy;
         if(this.renderenergy > energy) {
            this.renderenergy = energy;
         }
      }

      TDEUIUtils.drawDoubleTDEGrowBar(this.renderenergy, energy, energyMax, 300.0F, yPos - 4, TDEHudID.BAR_SHORT, TDEHudID.BAR_ENERGY, TDEHudID.BAR_ENERGY_B, graphics, 128, 5, 126, 5);
      if(this.rendermana > mana) {
         this.rendermana -= 0.05F;
         if(this.rendermana < mana) {
            this.rendermana = mana;
         }
      } else if(this.rendermana < mana) {
         this.rendermana += 0.05F;
         if(this.rendermana > mana) {
            this.rendermana = mana;
         }
      }

      TDEUIUtils.drawDoubleTDEGrowBar(this.rendermana, mana, manaMax, 300.0F, yPos + 9, TDEHudID.BAR_SHORT, TDEHudID.BAR_MANA, TDEHudID.BAR_MANA_B, graphics, 128, 5, 126, 5);
   }

   private void learnSkill(LocalPlayer player, Window scaled, GuiGraphics graphics) {
      if(this.isLearningSkill && this.learnSkillTimer >= 0) {
         ++this.learnSkillTimer;
         if(this.learnSkillTimer > 500) {
            this.isLearningSkill = false;
         } else {
            float alpha;
            if(this.learnSkillTimer < 60) {
               alpha = (float)this.learnSkillTimer / 60.0F;
            } else if(this.learnSkillTimer > 440) {
               alpha = (float)(500 - this.learnSkillTimer) / 60.0F;
            } else {
               alpha = 1.0F;
            }

            int screenWidth = scaled.m_85445_();
            int screenHeight = scaled.m_85446_();
            int centerX = screenWidth / 2;
            int posY = (screenHeight - 50) / 2;
            LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
            Skill skill = this.learningSkill;
            if(skill instanceof SkillInfo) {
               SkillInfo skillInfo = (SkillInfo)skill;
               graphics.m_280168_().m_85836_();
               graphics.m_280168_().m_252880_(0.0F, 0.0F, 500.0F);
               graphics.m_280246_(1.0F, 1.0F, 1.0F, alpha);
               int skillX = centerX - 25;
               this.renderScaledTexture(graphics, TDEHudID.SKILL_DOWN, skillX, posY, 50, 50);
               ResourceLocation icon = new ResourceLocation(skillInfo.getIcon());
               this.renderScaledTexture(graphics, icon, skillX + 1, posY + 1, 48, 48);
               this.renderScaledTexture(graphics, TDEHudID.SKILL_UP, skillX, posY, 50, 50);
               int textColor = (int)(alpha * 255.0F) << 24 | 16777215;
               String skillName = Component.m_237115_(skill.getTranslationKey()).getString();
               int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(skillName);
               graphics.m_280488_(Minecraft.m_91087_().f_91062_, skillName, centerX - textWidth / 2, posY - 10, textColor);
               String skillDesc = skillInfo.getMoreText();
               textWidth = Minecraft.m_91087_().f_91062_.m_92895_(skillDesc);
               graphics.m_280488_(Minecraft.m_91087_().f_91062_, skillDesc, centerX - textWidth / 2, posY + 50, textColor);
               graphics.m_280246_(1.0F, 1.0F, 1.0F, 1.0F);
               graphics.m_280168_().m_85849_();
            }

         }
      }
   }

   private void getSkill(LocalPlayer player, Window scaled, GuiGraphics graphics) {
      int screenWidth = scaled.m_85445_();
      int screenHeight = scaled.m_85446_();
      int posY = screenHeight - 46;
      int centerX = (screenWidth - 24) / 2 - 60;
      LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
      Iterator var9 = List.of(TDESkillSlots.CYCLE_1, TDESkillSlots.CYCLE_2, TDESkillSlots.CYCLE_3, TDESkillSlots.CYCLE_4, TDESkillSlots.CYCLE_5).iterator();

      while(var9.hasNext()) {
         TDESkillSlots slot = (TDESkillSlots)var9.next();
         if(localPlayerPatch != null) {
            Skill skill = localPlayerPatch.getSkill(slot).getSkill();
            int coolDown = 0;
            int maxCoolDown = 0;
            if(skill instanceof CycleSkill) {
               CycleSkill skillInfo = (CycleSkill)skill;
               coolDown = skillInfo.getCoolDown(localPlayerPatch);
               maxCoolDown = skillInfo.getMaxCoolDown();
            }

            if(skill instanceof SkillInfo) {
               SkillInfo skillInfo1 = (SkillInfo)skill;
               ResourceLocation icon = new ResourceLocation(skillInfo1.getIcon());
               boolean isActive = (float)slot.getCycle() == TDEAbilityUtils.getAbility(AbilityType.CYCLE, player);
               this.renderScaledTexture(graphics, TDEHudID.SKILL_DOWN, centerX, posY, 24, 24);
               this.renderScaledTexture(graphics, icon, centerX + 2, posY + 2, 20, 20);
               if(coolDown > 0 && maxCoolDown > 0) {
                  float border = (float)coolDown / (float)maxCoolDown;
                  this.renderCooldownOverlay(graphics, centerX + 2, posY + 2, 20, 20, border);
                  String timeText = String.format("%.1f", new Object[]{Float.valueOf((float)coolDown / 20.0F)});
                  this.renderCenteredText(graphics, timeText, centerX + 12, posY + 12);
               }

               ResourceLocation border1 = isActive?TDEHudID.SKILL_UP_NOW:TDEHudID.SKILL_UP;
               this.renderScaledTexture(graphics, border1, centerX, posY, 24, 24);
               centerX += 30;
            }
         }
      }

   }

   private void renderCooldownOverlay(GuiGraphics param1, int param2, int param3, int param4, int param5, float param6) {
      // $FF: Couldn't be decompiled
   }

   private void renderCenteredText(GuiGraphics graphics, String text, int x, int y) {
      Font font = Minecraft.m_91087_().f_91062_;
      int textWidth = font.m_92895_(text);
      Objects.requireNonNull(font);
      byte textHeight = 9;
      int textX = x - textWidth / 2;
      int textY = y - textHeight / 2;
      graphics.m_280488_(font, text, textX, textY, 16777215);
   }

   private void renderScaledTexture(GuiGraphics param1, ResourceLocation param2, int param3, int param4, int param5, int param6) {
      // $FF: Couldn't be decompiled
   }

   private void getPlayerAirBar(LocalPlayer player, Window scaled, GuiGraphics graphics) {
      int screenWidth = scaled.m_85445_();
      int screenHeight = scaled.m_85446_();
      int posY = screenHeight - 45;
      float Multiplier = 1.0F - (float)player.m_20146_() / 300.0F;
      int cut = (int)(123.0F * Multiplier);
      graphics.m_280163_(TDEHudID.BAR_LONG, (screenWidth - 256) / 2, posY, 0.0F, 0.0F, 256, 16, 256, 16);
      graphics.m_280163_(TDEHudID.BAR_AIR, (screenWidth - 246) / 2 + cut, posY, (float)cut, (float)(player.f_19797_ % 20 * 16), 246 - cut * 2, 16, 246, 320);
   }

   private void renderKeyHints(Window scaled, GuiGraphics graphics) {
      Font font = this.minecraft.f_91062_;
      int maxWidth = 0;
      Iterator screenWidth = KEY_HINTS.iterator();

      int startY;
      while(screenWidth.hasNext()) {
         Pair screenHeight = (Pair)screenWidth.next();
         String startX = Component.m_237115_((String)screenHeight.getFirst()).getString();
         startY = font.m_92895_(startX) + font.m_92895_(this.getKeyName((KeyMapping)screenHeight.getSecond()));
         if(startY > maxWidth) {
            maxWidth = startY;
         }
      }

      int var14 = scaled.m_85445_();
      int var15 = scaled.m_85446_();
      int var16 = var14 - maxWidth - 10;
      startY = var15 - KEY_HINTS.size() * 12 - 30;

      for(int i = 0; i < KEY_HINTS.size(); ++i) {
         Pair hint = (Pair)KEY_HINTS.get(i);
         int yPos = startY + i * 12;
         String functionName = Component.m_237115_((String)hint.getFirst()).getString();
         graphics.m_280488_(font, functionName, var16, yPos, 11184810);
         int keyX = var16 + font.m_92895_(functionName);
         graphics.m_280488_(font, this.getKeyName((KeyMapping)hint.getSecond()), keyX, yPos, 16766720);
      }

   }

   private String getKeyName(KeyMapping keyMapping) {
      return keyMapping.m_90863_().getString();
   }

   private void renderSoulCount(LocalPlayer player, Window scaled, GuiGraphics graphics) {
      float currentSoul = TDEAbilityUtils.getAbility(AbilityType.SOUL, player);
      if(this.lastSoulValue < 0.0F) {
         this.lastSoulValue = currentSoul;
      }

      if(currentSoul != this.lastSoulValue) {
         this.soulChangeValue = currentSoul - this.lastSoulValue;
         this.soulChangeTimer = 80;
         this.lastSoulValue = currentSoul;
      }

      int screenWidth = scaled.m_85445_();
      int x = screenWidth - 120;
      byte y = 20;
      graphics.m_280163_(TDEHudID.SOUL, x, y, 0.0F, 0.0F, 16, 16, 16, 16);
      Font font = this.minecraft.f_91062_;
      String soulText = String.format("%.0f", new Object[]{Float.valueOf(currentSoul)});
      int textX = x + 16 + 1;
      Objects.requireNonNull(font);
      int textY = y + (16 - 9) / 2;
      graphics.m_280488_(font, soulText, textX, textY, 16777215);
      if(this.soulChangeTimer > 0) {
         float progress = (float)this.soulChangeTimer / 80.0F;
         int alpha = (int)(255.0F * progress);
         int offsetY = (int)(20.0F * (1.0F - progress));
         int color = this.soulChangeValue > 0.0F?-16711936:-65536;
         color = alpha << 24 | color & 16777215;
         String changeText = String.format("%s%.0f", new Object[]{this.soulChangeValue > 0.0F?"+":"", Float.valueOf(this.soulChangeValue)});
         int changeX = textX + font.m_92895_(soulText) + 4;
         int changeY = textY - offsetY;
         graphics.m_280488_(font, changeText, changeX, changeY, color);
         --this.soulChangeTimer;
      }

   }

   // $FF: synthetic method
   private static void lambda$getSoulFire$0(GuiGraphics graphics, int posY, int move, PlayerAbilities abilities) {
      PlayerAttribute soulfire = abilities.get(AbilityType.SOULFIRE);
      if(soulfire != null) {
         boolean Ymove = false;
         float fireMax = soulfire.getCurrentMax();
         float fireValue = soulfire.get();
         float n = fireValue / fireMax;
         byte Ymove1;
         if((double)n >= 0.66D) {
            Ymove1 = 0;
         } else if((double)n <= 0.33D) {
            Ymove1 = 2;
         } else {
            Ymove1 = 1;
         }

         graphics.m_280163_(TDEHudID.NUMBER, 74, posY + 48, (float)((int)(fireValue * 8.0F)), 0.0F, 8, 19, 80, 19);
         graphics.m_280163_(TDEHudID.SOUL_FIRE, 10, posY, (float)(move * 64), (float)(Ymove1 * 64), 64, 64, 1280, 256);
      }

   }

}
