package com.merlin204.tde.client.gui.npc;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture.TextType;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.client.ClientInputManager;
import com.merlin204.tde.client.gui.UiResource;
import com.merlin204.tde.client.gui.npc.dialogue.DialogueTree;
import com.merlin204.tde.client.gui.npc.dialogue.DialogueTree.DialogueNode;
import com.merlin204.tde.client.gui.npc.dialogue.DialogueTree.DialogueSystem;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;

public class NPCDialogueUI {

   public static DialogueNode currentNode;
   public static String currentText;
   public static WidgetGroup root;
   public static WidgetGroup chose;
   public static WidgetGroup text;


   public static WidgetGroup createUI() {
      LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
      Player player = (Player)localPlayerPatch.getOriginal();
      root = new WidgetGroup();
      chose = new WidgetGroup();
      text = new WidgetGroup();
      root.setSelfPosition(0, 45);
      root.setSize(0, 0);
      if(player.m_9236_().f_46443_ && ClientInputManager.nearbyNPC != null) {
         DialogueTree tree = DialogueSystem.getTreeForEntity(ClientInputManager.nearbyNPC);
         if(tree != null) {
            currentNode = tree.getRootNode();
            currentText = currentNode.getResponseText(player);
         }

         updateChose(player);
         updateText(player);
      }

      root.addWidget(text);
      root.addWidget(chose);
      return root;
   }

   private static void updateText(Player player) {
      text.clearAllWidgets();
      Widget back = (new ButtonWidget()).setActive(false);
      back.setBackground(new IGuiTexture[]{UiResource.TEXT});
      back.setSize(300, 60);
      back.setSelfPosition(-150, 80);
      ImageWidget nodeText = new ImageWidget();
      TextTexture textS = (new TextTexture()).setType(TextType.LEFT);
      if(currentText != null) {
         textS.updateText(Component.m_237115_(currentText).getString());
      }

      textS.setWidth(280);
      nodeText.setSize(280, 50);
      nodeText.setSelfPosition(-140, 70);
      nodeText.setBackground(new IGuiTexture[]{textS});
      text.addWidget(back);
      text.addWidget(nodeText);
   }

   private static void updateChose(Player player) {
      chose.clearAllWidgets();
      if(currentNode != null) {
         List children = currentNode.getAvailableChildren(player);
         int yOffset = 55;
         Iterator endButton = children.iterator();

         while(endButton.hasNext()) {
            DialogueNode child = (DialogueNode)endButton.next();
            if(child.isAvailable(player)) {
               String optionText = child.getOptionText(player);
               ButtonWidget button = new ButtonWidget();
               setTextNodeButton(button, optionText, 20, 130, yOffset);
               child.setOnPressCallback(player);
               yOffset -= 25;
            }
         }

         if(children.isEmpty()) {
            ButtonWidget endButton1 = new ButtonWidget();
            setTextNodeButton(endButton1, "endText", 20, 130, yOffset);
            endButton1.setOnPressCallback(player);
         }
      }

   }

   private static void setTextNodeButton(ButtonWidget button, String string, int height, int x, int y) {
      Font font = Minecraft.m_91087_().f_91062_;
      int textWidth = font.m_92895_(Component.m_237115_(string).getString());
      ImageWidget nodeText = new ImageWidget();
      TextTexture text = (new TextTexture()).setType(TextType.RIGHT);
      text.updateText(Component.m_237115_(string).getString());
      text.setWidth(textWidth + 18);
      button.setSize(18 + textWidth, height);
      button.setSelfPosition(x - textWidth, y);
      button.setBackground(new IGuiTexture[]{UiResource.NODE});
      nodeText.setSize(textWidth, height);
      nodeText.setSelfPosition(x + 9 - textWidth, y + 2);
      nodeText.setBackground(new IGuiTexture[]{text});
      chose.addWidget(button);
      chose.addWidget(nodeText);
   }

   // $FF: synthetic method
   private static void lambda$updateChose$1(Player player, ClickData clickData) {
      Minecraft mc = Minecraft.m_91087_();
      currentNode = null;
      currentText = null;
      updateChose(player);
      updateText(player);
      if(mc.f_91080_ != null) {
         mc.f_91080_.m_7379_();
      }

   }

   // $FF: synthetic method
   private static void lambda$updateChose$0(DialogueNode child, Player player, ClickData clickData) {
      if(child.getResponseText(player) != null) {
         currentText = child.getResponseText(player);
      }

      currentNode = child;
      child.onSelected(Minecraft.m_91087_().f_91074_);
      updateChose(player);
      updateText(player);
   }
}
