package com.merlin204.tde.client.gui.campfire.skill;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture.TextType;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.gui.UiResource;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;

public class SkillUI {

   private static SkillSlot choseSlot = TDESkillSlots.SECT;
   private static Skill choseSkill;
   private static WidgetGroup chose1 = new WidgetGroup();
   private static WidgetGroup chose2 = new WidgetGroup();
   private static DraggableScrollableWidgetGroup skillList = new DraggableScrollableWidgetGroup();
   private static WidgetGroup skillDescription = new WidgetGroup();
   private static WidgetGroup skillMoreInfo = new WidgetGroup();
   private static WidgetGroup abilityInfo = new WidgetGroup();
   private static WidgetGroup otherInfo = new WidgetGroup();
   private static ButtonWidget slot_1_1 = new ButtonWidget();
   private static ButtonWidget slot_1_2 = new ButtonWidget();
   private static ButtonWidget slot_1_3 = new ButtonWidget();
   private static ButtonWidget slot_1_4 = new ButtonWidget();
   private static ButtonWidget slot_2_1 = new ButtonWidget();
   private static ButtonWidget slot_2_2 = new ButtonWidget();
   private static ButtonWidget slot_2_3 = new ButtonWidget();
   private static ButtonWidget slot_2_4 = new ButtonWidget();
   private static ButtonWidget slot_2_5 = new ButtonWidget();


   public static void setSkillUI(WidgetGroup skill) {
      LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
      skill.setActive(false).setVisible(false);
      skill.setSize(400, 220);
      skill.setSelfPosition(-200, -110);
      skill.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_1});
      chose1.setSize(50, 200);
      chose1.setSelfPosition(10, 10);
      chose1.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_2});
      choseSkill = localPlayerPatch.getSkill(choseSlot).getSkill();
      updataChose1(localPlayerPatch);
      updataChose2(localPlayerPatch);
      chose2.setSize(50, 200);
      chose2.setSelfPosition(65, 10);
      chose2.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_2});
      WidgetGroup list = new WidgetGroup();
      list.setSize(115, 200);
      list.setSelfPosition(120, 10);
      list.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_2});
      updataList(localPlayerPatch);
      list.addWidget(skillList);
      WidgetGroup info = new WidgetGroup();
      info.setSize(150, 200);
      info.setSelfPosition(240, 10);
      info.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_2});
      updataSkillDescription(localPlayerPatch);
      info.addWidget(skillDescription);
      skill.addWidget(chose1);
      skill.addWidget(chose2);
      skill.addWidget(list);
      skill.addWidget(info);
   }

   private static void updataChose1(LocalPlayerPatch localPlayerPatch) {
      ArrayList children = new ArrayList(chose1.widgets);
      Iterator var2 = children.iterator();

      while(var2.hasNext()) {
         Widget child = (Widget)var2.next();
         chose1.removeWidget(child);
      }

      addSlot1(slot_1_1, 0, TDESkillSlots.SECT, localPlayerPatch);
      addSlot1(slot_1_2, 1, SkillSlots.DODGE, localPlayerPatch);
      addSlot1(slot_1_3, 2, TDESkillSlots.TDEGUARD, localPlayerPatch);
      addSlot1(slot_1_4, 3, TDESkillSlots.CHARGED_ATTACK, localPlayerPatch);
   }

   private static void updataChose2(LocalPlayerPatch localPlayerPatch) {
      ArrayList children = new ArrayList(chose2.widgets);
      Iterator var2 = children.iterator();

      while(var2.hasNext()) {
         Widget child = (Widget)var2.next();
         chose2.removeWidget(child);
      }

      addSlot2(slot_2_1, 0, TDESkillSlots.CYCLE_1, localPlayerPatch);
      addSlot2(slot_2_2, 1, TDESkillSlots.CYCLE_2, localPlayerPatch);
      addSlot2(slot_2_3, 2, TDESkillSlots.CYCLE_3, localPlayerPatch);
      addSlot2(slot_2_4, 3, TDESkillSlots.CYCLE_4, localPlayerPatch);
      addSlot2(slot_2_5, 4, TDESkillSlots.CYCLE_5, localPlayerPatch);
   }

   private static void addSlot2(ButtonWidget slot, int number, SkillSlot skillSlot, LocalPlayerPatch localPlayerPatch) {
      byte y = 8;
      byte yOffset = 38;
      slot.setSize(32, 32);
      slot.setSelfPosition(9, y + number * yOffset);
      Skill var7 = localPlayerPatch.getSkill(skillSlot).getSkill();
      if(var7 instanceof SkillInfo) {
         SkillInfo skillInfo = (SkillInfo)var7;
         slot.setBackground(new IGuiTexture[]{UiResource.SLOT_1_BACK, new ResourceTexture(skillInfo.getIcon()), UiResource.SLOT_1_UP});
         if(skillSlot == choseSlot) {
            slot.setBackground(new IGuiTexture[]{UiResource.SLOT_1_BACK, new ResourceTexture(skillInfo.getIcon()), UiResource.SLOT_1_CHOSE});
         }
      } else {
         slot.setBackground(new IGuiTexture[]{UiResource.SLOT_1_BACK, UiResource.SLOT_1_UP});
         if(skillSlot == choseSlot) {
            slot.setBackground(new IGuiTexture[]{UiResource.SLOT_1_BACK, UiResource.SLOT_1_CHOSE});
         }
      }

      localPlayerPatch.setOnPressCallback(skillSlot);
      chose2.addWidget(slot);
   }

   private static void addSlot1(ButtonWidget slot, int number, SkillSlot skillSlot, LocalPlayerPatch localPlayerPatch) {
      byte y = 17;
      byte yOffset = 45;
      slot.setSize(32, 32);
      slot.setSelfPosition(9, y + number * yOffset);
      Skill var7 = localPlayerPatch.getSkill(skillSlot).getSkill();
      if(var7 instanceof SkillInfo) {
         SkillInfo skillInfo = (SkillInfo)var7;
         slot.setBackground(new IGuiTexture[]{UiResource.SLOT_1_BACK, new ResourceTexture(skillInfo.getIcon()), UiResource.SLOT_1_UP});
         if(skillSlot == choseSlot) {
            slot.setBackground(new IGuiTexture[]{UiResource.SLOT_1_BACK, new ResourceTexture(skillInfo.getIcon()), UiResource.SLOT_1_CHOSE});
         }
      } else {
         slot.setBackground(new IGuiTexture[]{UiResource.SLOT_1_BACK, UiResource.SLOT_1_UP});
         if(skillSlot == choseSlot) {
            slot.setBackground(new IGuiTexture[]{UiResource.SLOT_1_BACK, UiResource.SLOT_1_CHOSE});
         }
      }

      localPlayerPatch.setOnPressCallback(skillSlot);
      chose1.addWidget(slot);
   }

   private static void updataSkillDescription(LocalPlayerPatch localPlayerPatch) {
      ArrayList children = new ArrayList(skillDescription.widgets);
      Iterator player = children.iterator();

      while(player.hasNext()) {
         Widget skillInfo = (Widget)player.next();
         skillDescription.removeWidget(skillInfo);
      }

      Player player1 = (Player)localPlayerPatch.getOriginal();
      skillDescription.setSize(150, 200);
      skillDescription.setSelfPosition(0, 0);
      Skill icon = choseSkill;
      if(icon instanceof SkillInfo) {
         SkillInfo skillInfo1 = (SkillInfo)icon;
         ImageWidget icon1 = new ImageWidget();
         icon1.setSize(34, 34);
         icon1.setSelfPosition(111, 5);
         icon1.setBackground(new IGuiTexture[]{UiResource.SLOT_1_BACK, new ResourceTexture(skillInfo1.getIcon()), UiResource.SLOT_1_UP});
         ImageWidget title = new ImageWidget();
         title.setSize(95, 22);
         title.setSelfPosition(10, 5);
         TextTexture titleText = new TextTexture();
         titleText.setWidth(70).setType(TextType.LEFT);
         titleText.updateText(choseSkill.getDisplayName().getString());
         title.setBackground(new IGuiTexture[]{titleText});
         ArrayList abilityChildren = new ArrayList(abilityInfo.widgets);
         Iterator otherChildren = abilityChildren.iterator();

         while(otherChildren.hasNext()) {
            Widget equip = (Widget)otherChildren.next();
            abilityInfo.removeWidget(equip);
         }

         abilityInfo.setSize(140, 74);
         abilityInfo.setSelfPosition(5, 45);
         abilityInfo.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_1});
         addAbilityNeed(abilityInfo, 0, 0, AbilityType.VITALITY, "ability.tde.Vitality");
         addAbilityNeed(abilityInfo, 0, 1, AbilityType.STRENGTH, "ability.tde.strength");
         addAbilityNeed(abilityInfo, 0, 2, AbilityType.DEXTERITY, "ability.tde.dexterity");
         addAbilityNeed(abilityInfo, 1, 0, AbilityType.INTELLIGENCE, "ability.tde.intelligence");
         addAbilityNeed(abilityInfo, 1, 1, AbilityType.STAMINA, "ability.tde.stamina");
         addAbilityNeed(abilityInfo, 1, 2, AbilityType.ARCANE, "ability.tde.arcane");
         ArrayList otherChildren1 = new ArrayList(otherInfo.widgets);
         Iterator equip1 = otherChildren1.iterator();

         while(equip1.hasNext()) {
            Widget equipText = (Widget)equip1.next();
            otherInfo.removeWidget(equipText);
         }

         addOtherNeed();
         ButtonWidget equip2 = new ButtonWidget();
         equip2.setSize(50, 20);
         equip2.setSelfPosition(20, 170);
         TextTexture equipText1 = (new TextTexture(Component.m_237115_("gui.tde.campfire.skill.equip").getString())).setType(TextType.NORMAL);
         Iterator more = List.of(SkillSlots.DODGE, TDESkillSlots.TDEGUARD, TDESkillSlots.SECT, TDESkillSlots.CHARGED_ATTACK, TDESkillSlots.CYCLE_5, TDESkillSlots.CYCLE_4, TDESkillSlots.CYCLE_3, TDESkillSlots.CYCLE_2, TDESkillSlots.CYCLE_1).iterator();

         while(more.hasNext()) {
            SkillSlot moreText = (SkillSlot)more.next();
            if(localPlayerPatch.getSkill(moreText).getSkill() == choseSkill) {
               equipText1.updateText(Component.m_237115_("gui.tde.campfire.skill.equip_chose").getString());
               equip2.setActive(false);
            }
         }

         equip2.setButtonTexture(new IGuiTexture[]{UiResource.BUTTON_1, equipText1});
         equip2.setClickedTexture(new IGuiTexture[]{UiResource.BUTTON_1_DOWN, equipText1});
         localPlayerPatch.setOnPressCallback(player1);
         skillMoreInfo = skillInfo1.getMoreInfo();
         skillInfo1.setMoreInfo(skillMoreInfo);
         skillMoreInfo.setActive(false).setVisible(false);
         abilityInfo.setActive(true).setVisible(true);
         otherInfo.setActive(true).setVisible(true);
         SwitchWidget more1 = new SwitchWidget();
         more1.setSize(50, 20);
         more1.setSelfPosition(80, 170);
         TextTexture moreText1 = (new TextTexture(Component.m_237115_("gui.tde.campfire.skill.more").getString())).setType(TextType.NORMAL);
         TextTexture moreText_ture = (new TextTexture(Component.m_237115_("gui.tde.campfire.skill.more_ture").getString())).setType(TextType.NORMAL);
         more1.setPressed(false);
         more1.setBaseTexture(new IGuiTexture[]{UiResource.BUTTON_1, moreText1});
         more1.setPressedTexture(new IGuiTexture[]{UiResource.BUTTON_1_DOWN, moreText_ture});
         equip2.setOnPressCallback(more1);
         skillDescription.addWidget(icon1);
         skillDescription.addWidget(title);
         skillDescription.addWidget(abilityInfo);
         skillDescription.addWidget(otherInfo);
         skillDescription.addWidget(equip2);
         skillDescription.addWidget(more1);
         skillDescription.addWidget(skillMoreInfo);
      }

   }

   private static void addOtherNeed() {
      Skill backMain = choseSkill;
      if(backMain instanceof SkillInfo) {
         SkillInfo skillInfo = (SkillInfo)backMain;
         Widget backMain1 = (new ButtonWidget()).setActive(false);
         backMain1.setSize(140, 15);
         backMain1.setSelfPosition(5, 120);
         backMain1.setBackground(new IGuiTexture[]{UiResource.BUTTON_1});
         ImageWidget textMain = new ImageWidget();
         textMain.setSize(60, 15);
         textMain.setSelfPosition(10, 120);
         TextTexture nameMain = new TextTexture();
         nameMain.setWidth(125).setType(TextType.LEFT_HIDE);
         Component.m_237115_("gui.tde.campfire.skill.main").getString().updateText(skillInfo.getMainAllowedWeaponTypes());
         textMain.setBackground(new IGuiTexture[]{nameMain});
         Widget backOff = (new ButtonWidget()).setActive(false);
         backOff.setSize(140, 15);
         backOff.setSelfPosition(5, 136);
         backOff.setBackground(new IGuiTexture[]{UiResource.BUTTON_1});
         ImageWidget textOff = new ImageWidget();
         textOff.setSize(60, 15);
         textOff.setSelfPosition(10, 136);
         TextTexture nameOff = new TextTexture();
         nameOff.setWidth(125).setType(TextType.LEFT_HIDE);
         Component.m_237115_("gui.tde.campfire.skill.off").getString().updateText(skillInfo.getOffAllowedWeaponTypes());
         textOff.setBackground(new IGuiTexture[]{nameOff});
         Widget backWeight = (new ButtonWidget()).setActive(false);
         backWeight.setSize(140, 15);
         backWeight.setSelfPosition(5, 152);
         backWeight.setBackground(new IGuiTexture[]{UiResource.BUTTON_1});
         ImageWidget textWeight = new ImageWidget();
         textWeight.setSize(60, 15);
         textWeight.setSelfPosition(10, 152);
         TextTexture nameWeight = new TextTexture();
         nameWeight.setWidth(125).setType(TextType.LEFT_HIDE);
         Component.m_237115_("gui.tde.campfire.skill.weight").getString().updateText(skillInfo.getMaxWeight());
         textWeight.setBackground(new IGuiTexture[]{nameWeight});
         otherInfo.addWidget(backMain1);
         otherInfo.addWidget(textMain);
         otherInfo.addWidget(backOff);
         otherInfo.addWidget(textOff);
         otherInfo.addWidget(backWeight);
         otherInfo.addWidget(textWeight);
      }

   }

   private static void updataList(LocalPlayerPatch param0) {
      // $FF: Couldn't be decompiled
   }

   private static void updataSkillInfo(int number, Skill skill) {
      ButtonWidget info = new ButtonWidget();
      LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
      byte yOffset = 31;
      info.setSize(105, 30);
      info.setSelfPosition(0, number * yOffset);
      info.setBackground(new IGuiTexture[]{UiResource.BUTTON_1});
      ImageWidget icon = new ImageWidget();
      if(skill instanceof SkillInfo) {
         SkillInfo skillInfo = (SkillInfo)skill;
         Iterator title = List.of(SkillSlots.DODGE, TDESkillSlots.TDEGUARD, TDESkillSlots.SECT, TDESkillSlots.CHARGED_ATTACK, TDESkillSlots.CYCLE_5, TDESkillSlots.CYCLE_4, TDESkillSlots.CYCLE_3, TDESkillSlots.CYCLE_2, TDESkillSlots.CYCLE_1).iterator();

         while(title.hasNext()) {
            SkillSlot titleText = (SkillSlot)title.next();
            if(localPlayerPatch.getSkill(titleText).getSkill() == skill) {
               info.setBackground(new IGuiTexture[]{UiResource.BUTTON_1_DOWN});
            }
         }

         icon.setSize(22, 22);
         icon.setSelfPosition(80, 4 + number * yOffset);
         icon.setBackground(new IGuiTexture[]{UiResource.SLOT_1_BACK, new ResourceTexture(skillInfo.getIcon()), UiResource.SLOT_1_UP});
         ImageWidget title1 = new ImageWidget();
         title1.setSize(95, 22);
         title1.setSelfPosition(-4, -2 + number * yOffset);
         TextTexture titleText1 = new TextTexture();
         titleText1.setWidth(70).setType(TextType.LEFT);
         titleText1.scale(0.8F);
         titleText1.updateText(skill.getDisplayName().getString());
         title1.setBackground(new IGuiTexture[]{titleText1});
         ImageWidget introduced = new ImageWidget();
         introduced.setSize(95, 22);
         introduced.setSelfPosition(-12, 8 + number * yOffset);
         TextTexture introducedText = new TextTexture();
         introducedText.setWidth(110).setType(TextType.LEFT_HIDE).setRollSpeed(0.0F);
         introducedText.scale(0.65F);
         introducedText.updateText(skillInfo.getIntroduce().getString());
         introduced.setBackground(new IGuiTexture[]{introducedText});
         info.setOnPressCallback(skill);
         skillList.addWidget(info);
         skillList.addWidget(icon);
         skillList.addWidget(title1);
         skillList.addWidget(introduced);
      }

   }

   private static void addAbilityNeed(WidgetGroup abilityInfo, int numberX, int numberY, AbilityType abilityType, String key) {
      byte yOffset = 22;
      Skill back = choseSkill;
      if(back instanceof SkillInfo) {
         SkillInfo skillInfo = (SkillInfo)back;
         Widget back1 = (new ButtonWidget()).setActive(false);
         back1.setSize(60, 20);
         back1.setSelfPosition(8 + 65 * numberX, 5 + numberY * yOffset);
         back1.setBackground(new IGuiTexture[]{UiResource.BUTTON_1});
         ImageWidget need = new ImageWidget();
         need.setSize(60, 20);
         need.setSelfPosition(3 + 65 * numberX, 6 + numberY * yOffset);
         TextTexture amount = new TextTexture();
         amount.setWidth(60).setType(TextType.RIGHT);
         amount.updateText(String.valueOf((int)skillInfo.getAbilityRequirement(abilityType)));
         need.setBackground(new IGuiTexture[]{amount});
         ImageWidget text = new ImageWidget();
         text.setSize(60, 20);
         text.setSelfPosition(12 + 65 * numberX, 6 + numberY * yOffset);
         TextTexture name = new TextTexture();
         name.setWidth(60).setType(TextType.LEFT);
         name.updateText(Component.m_237115_(key).getString());
         text.setBackground(new IGuiTexture[]{name});
         abilityInfo.addWidget(back1);
         abilityInfo.addWidget(text);
         abilityInfo.addWidget(need);
      }

   }

   // $FF: synthetic method
   private static void lambda$updataSkillInfo$9(Skill param0, ClickData param1) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static void lambda$updataSkillInfo$8() {
      updataSkillDescription(ClientEngine.getInstance().getPlayerPatch());
   }

   // $FF: synthetic method
   private static boolean lambda$updataList$7(Skill skill) {
      return skill.getCategory() == choseSlot.category();
   }

   // $FF: synthetic method
   private static void lambda$updataSkillDescription$6(ClickData clickData, Boolean state) {
      if(state.booleanValue()) {
         skillMoreInfo.setActive(true).setVisible(true);
         abilityInfo.setActive(false).setVisible(false);
         otherInfo.setActive(false).setVisible(false);
      } else {
         skillMoreInfo.setActive(false).setVisible(false);
         abilityInfo.setActive(true).setVisible(true);
         otherInfo.setActive(true).setVisible(true);
      }

   }

   // $FF: synthetic method
   private static void lambda$updataSkillDescription$5(LocalPlayerPatch localPlayerPatch, Player player, ClickData clickData) {
      if(localPlayerPatch instanceof TDELocalPlayerPatch) {
         TDELocalPlayerPatch tdeLocalPlayerPatch = (TDELocalPlayerPatch)localPlayerPatch;
         if(!clickData.isRemote) {
            CapabilitySkill skillCapability = tdeLocalPlayerPatch.getSkillCapability();
            skillCapability.skillContainers[choseSlot.universalOrdinal()].setSkill(choseSkill);
            EpicFightNetworkManager.sendToServer(new CPChangeSkill(choseSlot.universalOrdinal(), -1, choseSkill.toString(), !player.m_7500_()));
            Minecraft.m_91087_().m_6937_(localPlayerPatch);
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$updataSkillDescription$4(LocalPlayerPatch localPlayerPatch) {
      updataChose1(localPlayerPatch);
      updataChose2(localPlayerPatch);
      updataList(localPlayerPatch);
      updataSkillDescription(localPlayerPatch);
   }

   // $FF: synthetic method
   private static void lambda$addSlot1$3(LocalPlayerPatch localPlayerPatch, SkillSlot skillSlot, ClickData clickData) {
      if(localPlayerPatch instanceof TDELocalPlayerPatch && !clickData.isRemote) {
         choseSlot = skillSlot;
         Minecraft.m_91087_().m_6937_(localPlayerPatch);
      }

   }

   // $FF: synthetic method
   private static void lambda$addSlot1$2(LocalPlayerPatch localPlayerPatch) {
      updataList(localPlayerPatch);
      updataChose1(localPlayerPatch);
      updataChose2(localPlayerPatch);
   }

   // $FF: synthetic method
   private static void lambda$addSlot2$1(LocalPlayerPatch localPlayerPatch, SkillSlot skillSlot, ClickData clickData) {
      if(localPlayerPatch instanceof TDELocalPlayerPatch && !clickData.isRemote) {
         choseSlot = skillSlot;
         Minecraft.m_91087_().m_6937_(localPlayerPatch);
      }

   }

   // $FF: synthetic method
   private static void lambda$addSlot2$0(LocalPlayerPatch localPlayerPatch) {
      updataList(localPlayerPatch);
      updataChose1(localPlayerPatch);
      updataChose2(localPlayerPatch);
   }

}
