package com.merlin204.tde.client.gui.campfire.levelup;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture.TextType;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.gui.UiResource;
import com.merlin204.tde.client.gui.campfire.levelup.LevelCostCalculator;
import com.merlin204.tde.util.TDEAbilityUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;

public class LevelUpUI {

   public static void setLevelUp(WidgetGroup levelUp) {
      LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
      levelUp.setActive(false).setVisible(false);
      levelUp.setSize(300, 200);
      levelUp.setSelfPosition(-150, -100);
      levelUp.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_1});
      WidgetGroup up = new WidgetGroup();
      up.setSize(135, 150);
      up.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_2});
      up.setSelfPosition(10, 10);
      WidgetGroup soulFire = new WidgetGroup();
      soulFire.setBackground(new IGuiTexture[]{UiResource.BUTTON_1});
      soulFire.setSize(135, 20);
      soulFire.setSelfPosition(10, 170);
      LabelWidget text = new LabelWidget(5, 6, Component.m_237115_("gui.tde.campfire.level_up.soul").getString());
      Widget soulText = (new ButtonWidget()).setActive(false);
      TextTexture soulAmountText = (new TextTexture()).setType(TextType.RIGHT);
      soulAmountText.setWidth(120);
      soulAmountText.setSupplier(localPlayerPatch);
      soulText.setSize(120, 16);
      soulText.setSelfPosition(10, 4);
      soulText.setBackground(new IGuiTexture[]{soulAmountText});
      soulFire.addWidget(text);
      soulFire.addWidget(soulText);
      addUpInfo(AbilityType.VITALITY, up, 0, localPlayerPatch, "ability.tde.Vitality");
      addUpInfo(AbilityType.STRENGTH, up, 1, localPlayerPatch, "ability.tde.strength");
      addUpInfo(AbilityType.DEXTERITY, up, 2, localPlayerPatch, "ability.tde.dexterity");
      addUpInfo(AbilityType.INTELLIGENCE, up, 3, localPlayerPatch, "ability.tde.intelligence");
      addUpInfo(AbilityType.STAMINA, up, 4, localPlayerPatch, "ability.tde.stamina");
      addUpInfo(AbilityType.ARCANE, up, 5, localPlayerPatch, "ability.tde.arcane");
      WidgetGroup info = new WidgetGroup();
      info.setSize(135, 180);
      info.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_2});
      info.setSelfPosition(155, 10);
      addAbilityInfo(AbilityType.ENERGY_DAMAGE_BOOST, info, 0, localPlayerPatch, "ability.tde.energy_damage_boost", "ability.tde.energy_damage_boost.tip");
      addAbilityInfo(AbilityType.ENERGY_DAMAGE_RESISTANCE, info, 1, localPlayerPatch, "ability.tde.energy_damage_resistance", "ability.tde.energy_damage_resistance.tip");
      addAbilityInfo(AbilityType.ENERGY_COST_EFFICIENCY, info, 2, localPlayerPatch, "ability.tde.energy_cost_efficiency", "ability.tde.energy_cost_efficiency.tip");
      addAbilityInfo(AbilityType.ENERGY_RECOVERY_SPEED, info, 3, localPlayerPatch, "ability.tde.energy_recovery_speed", "ability.tde.energy_recovery_speed.tip");
      addAbilityInfo(AbilityType.MANA_RECOVERY_SPEED, info, 4, localPlayerPatch, "ability.tde.mana_recovery_speed", "ability.tde.mana_recovery_speed.tip");
      addHealthMaxInfo(info, 5, localPlayerPatch, "ability.tde.health_max", "ability.tde.health_max.tip");
      addAbilityInfo(AbilityType.ENERGY, info, 6, localPlayerPatch, "ability.tde.energy_max", "ability.tde.energy_max.tip");
      addAbilityInfo(AbilityType.MANA, info, 7, localPlayerPatch, "ability.tde.mana_max", "ability.tde.mana_max.tip");
      levelUp.addWidget(soulFire);
      levelUp.addWidget(up);
      levelUp.addWidget(info);
   }

   private static void addUpInfo(AbilityType abilityType, WidgetGroup up, int number, LocalPlayerPatch localPlayerPatch, String key) {
      Player player = (Player)localPlayerPatch.getOriginal();
      byte y = 5;
      byte yOffset = 24;
      Widget abilityInfo = (new ButtonWidget()).setActive(false);
      abilityInfo.setSize(125, 20);
      abilityInfo.setSelfPosition(5, y + yOffset * number);
      abilityInfo.setBackground(new IGuiTexture[]{UiResource.BUTTON_1});
      LabelWidget text = new LabelWidget(10, 6 + y + yOffset * number, Component.m_237115_(key).getString());
      Widget amountInfo = (new ButtonWidget()).setActive(false);
      TextTexture amountText = (new TextTexture()).setType(TextType.RIGHT);
      amountInfo.setSize(94, 14);
      amountInfo.setSelfPosition(5, y + yOffset * number + 4);
      amountInfo.setBackground(new IGuiTexture[]{amountText});
      abilityType.setSupplier(player);
      ButtonWidget add = new ButtonWidget();
      add.setSize(12, 12);
      add.setSelfPosition(100, 4 + y + yOffset * number);
      add.setButtonTexture(new IGuiTexture[]{UiResource.BUTTON_ADD});
      add.setClickedTexture(new IGuiTexture[]{UiResource.BUTTON_ADD_DOWN});
      ButtonWidget sub = new ButtonWidget();
      sub.setSize(12, 12);
      sub.setSelfPosition(114, 4 + y + yOffset * number);
      sub.setButtonTexture(new IGuiTexture[]{UiResource.BUTTON_SUB});
      sub.setClickedTexture(new IGuiTexture[]{UiResource.BUTTON_SUB_DOWN});
      player.setOnPressCallback(abilityType);
      abilityType.setOnPressCallback(player);
      up.addWidget(abilityInfo);
      up.addWidget(text);
      up.addWidget(amountInfo);
      up.addWidget(add);
      up.addWidget(sub);
   }

   private static void addAbilityInfo(AbilityType abilityType, WidgetGroup info, int number, LocalPlayerPatch localPlayerPatch, String key, String tip) {
      Player player = (Player)localPlayerPatch.getOriginal();
      Widget abilityInfo = (new ButtonWidget()).setActive(false).appendHoverTooltips(new String[]{Component.m_237115_(tip).getString()});
      abilityInfo.setSize(125, 20);
      abilityInfo.setSelfPosition(5, 7 + 21 * number);
      abilityInfo.setBackground(new IGuiTexture[]{UiResource.BUTTON_1});
      LabelWidget text = new LabelWidget(10, 13 + 21 * number, Component.m_237115_(key).getString());
      Widget amountInfo = (new ButtonWidget()).setActive(false);
      TextTexture amountText = (new TextTexture()).setType(TextType.RIGHT);
      amountInfo.setSize(120, 14);
      amountInfo.setSelfPosition(5, 7 + 21 * number + 4);
      amountInfo.setBackground(new IGuiTexture[]{amountText});
      abilityType.setSupplier(player);
      info.addWidget(abilityInfo);
      info.addWidget(text);
      info.addWidget(amountInfo);
   }

   private static void addHealthMaxInfo(WidgetGroup info, int number, LocalPlayerPatch localPlayerPatch, String key, String tip) {
      Player player = (Player)localPlayerPatch.getOriginal();
      Widget abilityInfo = (new ButtonWidget()).setActive(false).appendHoverTooltips(new String[]{Component.m_237115_(tip).getString()});
      abilityInfo.setSize(125, 20);
      abilityInfo.setSelfPosition(5, 7 + 21 * number);
      abilityInfo.setBackground(new IGuiTexture[]{UiResource.BUTTON_1});
      LabelWidget text = new LabelWidget(10, 13 + 21 * number, Component.m_237115_(key).getString());
      Widget amountInfo = (new ButtonWidget()).setActive(false);
      TextTexture amountText = (new TextTexture()).setType(TextType.RIGHT);
      amountInfo.setSize(120, 14);
      amountInfo.setSelfPosition(5, 7 + 21 * number + 4);
      amountInfo.setBackground(new IGuiTexture[]{amountText});
      amountText.setSupplier(player);
      info.addWidget(abilityInfo);
      info.addWidget(text);
      info.addWidget(amountInfo);
   }

   // $FF: synthetic method
   private static String lambda$addHealthMaxInfo$5(Player player) {
      float amount = player.m_21233_();
      return String.format("%.1f", new Object[]{Float.valueOf(amount)});
   }

   // $FF: synthetic method
   private static String lambda$addAbilityInfo$4(AbilityType abilityType, Player player) {
      float amount = TDEAbilityUtils.getAbilityMax(abilityType, player);
      return abilityType != AbilityType.ENERGY && abilityType != AbilityType.MANA?String.format("%.3f", new Object[]{Float.valueOf(amount)}):String.format("%.1f", new Object[]{Float.valueOf(amount)});
   }

   // $FF: synthetic method
   private static void lambda$addUpInfo$3(AbilityType abilityType, Player player, ClickData clickData) {
      if(TDEAbilityUtils.getAbility(abilityType, player) > 0.0F) {
         int currentLevel = TDEAbilityUtils.getLevel(player) - 1;
         float cost = LevelCostCalculator.getCostForNextLevel(currentLevel);
         if(!clickData.isRemote) {
            TDEAbilityUtils.addAbility(AbilityType.SOUL, player, cost);
            TDEAbilityUtils.subAbility(abilityType, player, 1.0F);
         }

      }
   }

   // $FF: synthetic method
   private static void lambda$addUpInfo$2(Player player, AbilityType abilityType, ClickData clickData) {
      int currentLevel = TDEAbilityUtils.getLevel(player);
      float cost = LevelCostCalculator.getCostForNextLevel(currentLevel);
      float soul = TDEAbilityUtils.getAbility(AbilityType.SOUL, player);
      if(soul >= cost && !clickData.isRemote) {
         TDEAbilityUtils.subAbility(AbilityType.SOUL, player, cost);
         TDEAbilityUtils.addAbility(abilityType, player, 1.0F);
      }

   }

   // $FF: synthetic method
   private static String lambda$addUpInfo$1(AbilityType abilityType, Player player) {
      int amount = (int)TDEAbilityUtils.getAbility(abilityType, player);
      return String.valueOf(amount);
   }

   // $FF: synthetic method
   private static String lambda$setLevelUp$0(LocalPlayerPatch localPlayerPatch) {
      float amount = TDEAbilityUtils.getAbility(AbilityType.SOUL, (Player)localPlayerPatch.getOriginal());
      return String.format("%.3f", new Object[]{Float.valueOf(amount)});
   }
}
