package com.merlin204.tde.client.gui.campfire.levelup;


public class LevelCostCalculator {

   private static final float BASE_COST = 100.0F;
   private static final float MAX_SOULS = 9999999.0F;
   private static final int MAX_LEVEL = 200;
   private static final float GROWTH_FACTOR = 0.038F;
   private static final float TOTAL_COST_TARGET = 4500000.0F;


   public static float getCostForNextLevel(int currentLevel) {
      if(currentLevel >= 200) {
         return Float.MAX_VALUE;
      } else {
         float cost = 100.0F * (float)Math.exp((double)(0.038F * (float)currentLevel));
         if(currentLevel > 180) {
            float overLevel = (float)(currentLevel - 180);
            cost *= 1.0F + 0.02F * overLevel * overLevel;
         }

         return Math.min(cost, 9999999.0F);
      }
   }
}
