package com.merlin204.tde.client.gui.campfire;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture.TextType;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.gui.UiResource;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.item.TDEArmorItems;
import com.merlin204.tde.item.TDEWeaponitems;
import com.merlin204.tde.network.NetworkHandler;
import com.merlin204.tde.network.client.CPGiveItemPacket;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;

public class FirstFireUI {

   private static Skill chosenSkill;
   private static WidgetGroup root;
   private static DraggableScrollableWidgetGroup skillList;
   private static WidgetGroup skillInfo;
   private static WidgetGroup abilityInfo;
   private static final Map INITIAL_ITEMS = Map.of("tde:se1_1", List.of(new ItemStack((ItemLike)TDEWeaponitems.W1_2.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_2.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_3.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_4.get())), "tde:se1_2", List.of(new ItemStack((ItemLike)TDEWeaponitems.W1_1.get()), new ItemStack((ItemLike)TDEWeaponitems.W1_1.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_2.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_3.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_4.get())), "tde:se1_3", List.of(new ItemStack((ItemLike)TDEWeaponitems.W1_5.get()), new ItemStack((ItemLike)TDEWeaponitems.W1_6.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_2.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_3.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_4.get())));


   public static WidgetGroup createUI() {
      root = new WidgetGroup();
      root.setSize(0, 0);
      root.setSelfPosition(0, 0);
      WidgetGroup back = new WidgetGroup();
      back.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_1});
      back.setSize(330, 210);
      back.setSelfPosition(-165, -105);
      skillList = new DraggableScrollableWidgetGroup();
      skillList.setSize(110, 200);
      skillList.setBackground(UiResource.BACKGROUND_2);
      skillList.setSelfPosition(-160, -100);
      skillInfo = new WidgetGroup();
      skillInfo.setSize(200, 200);
      skillInfo.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_2});
      skillInfo.setSelfPosition(-40, -100);
      abilityInfo = new WidgetGroup();
      abilityInfo.setSize(180, 74);
      abilityInfo.setSelfPosition(10, 95);
      abilityInfo.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_1});
      root.addWidget(back);
      root.addWidget(skillList);
      root.addWidget(skillInfo);
      populateSkillList();
      updateSkillInfo();
      return root;
   }

   private static void populateSkillList() {
      DraggableScrollableWidgetGroup var0 = skillList;
      synchronized(skillList) {
         Iterator iterator = skillList.widgets.iterator();

         while(iterator.hasNext()) {
            iterator.next();
            iterator.remove();
         }

         ArrayList initialSkills = new ArrayList();
         Iterator number = INITIAL_ITEMS.keySet().iterator();

         while(number.hasNext()) {
            String skillId = (String)number.next();
            initialSkills.add(SkillManager.getSkill(skillId));
         }

         int var8 = 0;

         for(Iterator var9 = initialSkills.iterator(); var9.hasNext(); ++var8) {
            Skill skill = (Skill)var9.next();
            addSkillOption(var8, skill);
         }

         if(!initialSkills.isEmpty() && chosenSkill == null) {
            chosenSkill = (Skill)initialSkills.iterator().next();
            updateSkillInfo();
         }

      }
   }

   private static void addSkillOption(int index, Skill skill) {
      byte yOffset = 32;
      int yPos = index * yOffset;
      ButtonWidget button = new ButtonWidget();
      button.setSize(100, 30);
      button.setSelfPosition(5, yPos + 5);
      if(skill == chosenSkill) {
         button.setBackground(new IGuiTexture[]{UiResource.BUTTON_1_DOWN});
      } else {
         button.setBackground(new IGuiTexture[]{UiResource.BUTTON_1});
      }

      button.setOnPressCallback(skill);
      ImageWidget icon = new ImageWidget();
      icon.setSize(24, 24);
      icon.setSelfPosition(8, yPos + 8);
      if(skill instanceof SkillInfo) {
         SkillInfo name = (SkillInfo)skill;
         icon.setBackground(new IGuiTexture[]{UiResource.SLOT_1_BACK, new ResourceTexture(name.getIcon()), UiResource.SLOT_1_UP});
      }

      ImageWidget name1 = new ImageWidget();
      name1.setSize(70, 20);
      name1.setSelfPosition(35, yPos + 10);
      TextTexture nameText = new TextTexture();
      nameText.setWidth(65).setType(TextType.LEFT).updateText(skill.getDisplayName().getString());
      name1.setBackground(new IGuiTexture[]{nameText});
      skillList.addWidget(button);
      skillList.addWidget(icon);
      skillList.addWidget(name1);
   }

   private static void updateSkillInfo() {
      // $FF: Couldn't be decompiled
   }

   private static void updateSkillListHighlights() {
      DraggableScrollableWidgetGroup var0 = skillList;
      synchronized(skillList) {
         ArrayList childrenSnapshot = new ArrayList(skillList.widgets);

         for(int i = 0; i < childrenSnapshot.size(); i += 3) {
            Widget widget = (Widget)childrenSnapshot.get(i);
            if(widget instanceof ButtonWidget) {
               ButtonWidget button = (ButtonWidget)widget;
               Skill skill = getSkillAtIndex(i / 3);
               if(skill == chosenSkill) {
                  button.setBackground(new IGuiTexture[]{UiResource.BUTTON_1_DOWN});
               } else {
                  button.setBackground(new IGuiTexture[]{UiResource.BUTTON_1});
               }
            }
         }

      }
   }

   private static Skill getSkillAtIndex(int index) {
      ArrayList skills = new ArrayList();
      Iterator var2 = INITIAL_ITEMS.keySet().iterator();

      while(var2.hasNext()) {
         String skillId = (String)var2.next();
         skills.add(SkillManager.getSkill(skillId));
      }

      return index >= 0 && index < skills.size()?((Skill[])skills.toArray(new Skill[0]))[index]:null;
   }

   private static void addAbilityNeed(WidgetGroup group, int col, int row, AbilityType type, String key) {
      byte xOffset = 80;
      byte yOffset = 22;
      int xPos = 8 + col * xOffset;
      int yPos = 8 + row * yOffset;
      Skill name = chosenSkill;
      if(name instanceof SkillInfo) {
         SkillInfo skillInfo = (SkillInfo)name;
         ImageWidget name1 = new ImageWidget();
         name1.setSize(50, 16);
         name1.setSelfPosition(xPos, yPos);
         TextTexture nameText = new TextTexture();
         nameText.setWidth(50).setType(TextType.LEFT).updateText(Component.m_237115_(key).getString());
         name1.setBackground(new IGuiTexture[]{nameText});
         ImageWidget value = new ImageWidget();
         value.setSize(20, 16);
         value.setSelfPosition(xPos + 45, yPos);
         TextTexture valueText = new TextTexture();
         valueText.setWidth(20).setType(TextType.RIGHT).updateText(String.valueOf((int)skillInfo.getAbilityRequirement(type)));
         value.setBackground(new IGuiTexture[]{valueText});
         group.addWidget(name1);
         group.addWidget(value);
      }
   }

   // $FF: synthetic method
   private static void lambda$updateSkillInfo$3(ClickData clickData) {
      if(!clickData.isRemote) {
         LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
         CapabilitySkill skills = localPlayerPatch.getSkillCapability();
         String skillId = chosenSkill.toString();
         skills.skillContainers[TDESkillSlots.SECT.universalOrdinal()].setSkill(chosenSkill);
         skills.addLearnedSkill(chosenSkill);
         EpicFightNetworkManager.sendToServer(new CPChangeSkill(TDESkillSlots.SECT.universalOrdinal(), -1, chosenSkill.toString(), !((LocalPlayer)localPlayerPatch.getOriginal()).m_7500_()));
         Iterator mc = ((List)INITIAL_ITEMS.get(skillId)).iterator();

         while(mc.hasNext()) {
            ItemStack type = (ItemStack)mc.next();
            NetworkHandler.sendToServer(new CPGiveItemPacket(type));
         }

         mc = List.of(AbilityType.STRENGTH, AbilityType.VITALITY, AbilityType.DEXTERITY, AbilityType.INTELLIGENCE, AbilityType.STAMINA, AbilityType.ARCANE).iterator();

         while(mc.hasNext()) {
            AbilityType type1 = (AbilityType)mc.next();
            Skill requirement = chosenSkill;
            if(requirement instanceof SkillInfo) {
               SkillInfo skillInfo = (SkillInfo)requirement;
               float requirement1 = skillInfo.getAbilityRequirement(type1);
               TDEAbilityUtils.setAbility(type1, (Player)localPlayerPatch.getOriginal(), requirement1 + 4.0F);
            }
         }

         Minecraft mc1 = Minecraft.m_91087_();
         if(mc1.f_91080_ != null) {
            mc1.f_91067_.m_91602_();
            mc1.m_91152_((Screen)null);
            mc1.f_91067_.m_91601_();
            mc1.execute(mc1);
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$updateSkillInfo$2(Minecraft mc) {
      if(mc.f_91080_ != null) {
         mc.m_91152_((Screen)null);
      }

      if(mc.f_91067_.m_91600_()) {
         mc.f_91067_.m_91602_();
      }

   }

   // $FF: synthetic method
   private static void lambda$addSkillOption$1(Skill param0, ClickData param1) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static void lambda$addSkillOption$0() {
      updateSkillInfo();
      updateSkillListHighlights();
   }

}
