package com.merlin204.tde.client.gui.campfire;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture.TextType;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.client.gui.UiResource;
import com.merlin204.tde.client.gui.campfire.FirstFireUI;
import com.merlin204.tde.client.gui.campfire.levelup.LevelUpUI;
import com.merlin204.tde.client.gui.campfire.skill.SkillUI;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;

public class CampfireUI {

   public static WidgetGroup createUI() {
      LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
      if(localPlayerPatch.getSkill(TDESkillSlots.SECT).getSkill() == null) {
         return FirstFireUI.createUI();
      } else {
         WidgetGroup root = new WidgetGroup();
         root.setSelfPosition(0, 0);
         root.setSize(0, 0);
         WidgetGroup mainScreen = new WidgetGroup();
         WidgetGroup levelUp = new WidgetGroup();
         WidgetGroup skill = new WidgetGroup();
         SkillUI.setSkillUI(skill);
         LevelUpUI.setLevelUp(levelUp);
         ButtonWidget back = new ButtonWidget();
         setMainScreen(mainScreen, back, levelUp, skill);
         root.addWidget(levelUp);
         root.addWidget(skill);
         root.addWidget(mainScreen);
         root.addWidget(back);
         return root;
      }
   }

   private static void setMainScreen(WidgetGroup mainScreen, ButtonWidget back, WidgetGroup levelUp, WidgetGroup skill) {
      LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
      Player player = (Player)localPlayerPatch.getOriginal();
      mainScreen.setSize(0, 0);
      mainScreen.setSelfPosition(0, 0);
      ButtonWidget fireback = new ButtonWidget();
      fireback.setActive(false);
      fireback.setSize(60, 60);
      fireback.setSelfPosition(-30, -30);
      ImageWidget aniFire = new ImageWidget();
      aniFire.setSelfPosition(-30, -30);
      aniFire.setSize(60, 60);
      aniFire.setImage(player);
      fireback.setButtonTexture(new IGuiTexture[]{UiResource.BACKGROUND_1});
      ButtonWidget button_1 = new ButtonWidget();
      button_1.appendHoverTooltips(new String[]{Component.m_237115_("gui.tde.campfire.button_1.tip").getString()});
      ButtonWidget button_2 = new ButtonWidget();
      ButtonWidget button_3 = new ButtonWidget();
      ButtonWidget button_4 = new ButtonWidget();
      ButtonWidget button_5 = new ButtonWidget();
      ButtonWidget button_6 = new ButtonWidget();
      setButtonHIDE(button_1, 50, 20, -100, -60, Component.m_237115_("gui.tde.campfire.button_1"));
      setButtonHIDE(button_2, 50, 20, -100, -10, Component.m_237115_("gui.tde.campfire.button_2"));
      setButtonHIDE(button_3, 50, 20, -100, 40, Component.m_237115_("gui.tde.campfire.button_3"));
      setButtonHIDE(button_4, 50, 20, 50, -60, Component.m_237115_("gui.tde.campfire.button_4"));
      setButtonHIDE(button_5, 50, 20, 50, -10, Component.m_237115_("gui.tde.campfire.button_5"));
      setButtonHIDE(button_6, 50, 20, 50, 40, Component.m_237115_("gui.tde.campfire.button_6"));
      setButtonHIDE(back, 50, 20, -25, 110, Component.m_237115_("gui.tde.campfire.back"));
      mainScreen.setOnPressCallback(levelUp);
      mainScreen.setOnPressCallback(skill);
      skill.setOnPressCallback(levelUp);
      mainScreen.addWidget(button_1);
      mainScreen.addWidget(button_2);
      mainScreen.addWidget(button_3);
      mainScreen.addWidget(button_4);
      mainScreen.addWidget(button_5);
      mainScreen.addWidget(button_6);
      mainScreen.addWidget(fireback);
      mainScreen.addWidget(aniFire);
   }

   private static void setButtonHIDE(ButtonWidget buttonWidget, int width, int height, int x, int y, Component component) {
      TextTexture textAbove = (new TextTexture(component.getString())).setType(TextType.HIDE).setDropShadow(false);
      buttonWidget.setSize(width, height);
      buttonWidget.setSelfPosition(x, y);
      buttonWidget.setButtonTexture(new IGuiTexture[]{UiResource.BUTTON_1, textAbove});
      buttonWidget.setClickedTexture(new IGuiTexture[]{UiResource.BUTTON_1_DOWN, textAbove});
   }

   // $FF: synthetic method
   private static void lambda$setMainScreen$4(WidgetGroup mainScreen, WidgetGroup skill, WidgetGroup levelUp, ClickData clickData) {
      if(mainScreen.isActive()) {
         Minecraft mc = Minecraft.m_91087_();
         if(mc.f_91080_ != null) {
            mc.f_91067_.m_91602_();
            mc.m_91152_((Screen)null);
            mc.f_91067_.m_91601_();
            mc.execute(mc);
         }
      } else {
         mainScreen.setActive(true).setVisible(true);
         skill.setActive(false).setVisible(false);
         levelUp.setActive(false).setVisible(false);
      }

   }

   // $FF: synthetic method
   private static void lambda$setMainScreen$3(Minecraft mc) {
      if(mc.f_91080_ != null) {
         mc.m_91152_((Screen)null);
      }

      if(mc.f_91067_.m_91600_()) {
         mc.f_91067_.m_91602_();
      }

   }

   // $FF: synthetic method
   private static void lambda$setMainScreen$2(WidgetGroup mainScreen, WidgetGroup skill, ClickData clickData) {
      mainScreen.setActive(false).setVisible(false);
      skill.setActive(true).setVisible(true);
   }

   // $FF: synthetic method
   private static void lambda$setMainScreen$1(WidgetGroup mainScreen, WidgetGroup levelUp, ClickData clickData) {
      mainScreen.setActive(false).setVisible(false);
      levelUp.setActive(true).setVisible(true);
   }

   // $FF: synthetic method
   private static IGuiTexture lambda$setMainScreen$0(Player player) {
      Object i = player.f_19797_ % 20;
      return new ResourceTexture((String)i);
   }
}
