package com.merlin204.tde.client;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.block.CreativeBarrelBlock;
import com.merlin204.tde.block.fogblock.FogBlock;
import com.merlin204.tde.block.respawncampfireblock.RespawnCampfireBlock;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.keymapping.TDEKeyMappings;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.npc.NPCEntity;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.entity.vfx.soulfire.BossSoulFireEntity;
import com.merlin204.tde.epicfight.gameassets.animations.bipe.TDELivingAnimations;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.mixin.ControlEngineAccessor;
import com.merlin204.tde.network.NetworkHandler;
import com.merlin204.tde.network.client.CallNPCPacket;
import com.merlin204.tde.network.client.IntoFogPacket;
import com.merlin204.tde.photon.PosEffect;
import com.merlin204.tde.util.TDEAbilityUtils;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent.Stage;
import net.minecraftforge.event.TickEvent.ClientTickEvent;
import net.minecraftforge.event.TickEvent.Phase;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;

@EventBusSubscriber(
   modid = "tde",
   value = {Dist.CLIENT}
)
public class ClientInputManager {

   private static final Minecraft minecraft = Minecraft.m_91087_();
   private static final Options options = minecraft.f_91066_;
   public static BlockPos nearbyCampfirePos = null;
   public static BlockPos nearbyCanDestroyPos = null;
   public static BlockPos nearbyFogPos = null;
   public static NPCEntity nearbyNPC = null;
   public static EnemyEntity knockDownEntity = null;
   public static BossSoulFireEntity nearbyBossFire = null;


   @SubscribeEvent
   public static void onKeyInput(ClientTickEvent event) {
      Minecraft mc = Minecraft.m_91087_();
      LocalPlayer player = mc.f_91074_;
      if(event.phase == Phase.END) {
         LocalPlayerPatch patch = ClientEngine.getInstance().getPlayerPatch();
         if(!(patch instanceof TDELocalPlayerPatch)) {
            return;
         }

         TDELocalPlayerPatch tdePatch = (TDELocalPlayerPatch)patch;

         while(TDEKeyMappings.SOULFIRE_SKILL.m_90859_()) {
            sendSkillPacket(TDESkillSlots.SOULFIRE, TDEKeyMappings.SOULFIRE_SKILL);
         }

         while(TDEKeyMappings.BASIC_ATTACK.m_90859_()) {
            sendSkillPacket(TDESkillSlots.SECT, TDEKeyMappings.BASIC_ATTACK);
         }

         while(TDEKeyMappings.SKILL.m_90859_()) {
            switch((int)TDEAbilityUtils.getAbility(AbilityType.CYCLE, player)) {
            case 1:
               sendSkillPacket(TDESkillSlots.CYCLE_1, TDEKeyMappings.SKILL);
            case 2:
               sendSkillPacket(TDESkillSlots.CYCLE_2, TDEKeyMappings.SKILL);
            case 3:
               sendSkillPacket(TDESkillSlots.CYCLE_3, TDEKeyMappings.SKILL);
            case 4:
               sendSkillPacket(TDESkillSlots.CYCLE_4, TDEKeyMappings.SKILL);
            case 5:
               sendSkillPacket(TDESkillSlots.CYCLE_5, TDEKeyMappings.SKILL);
            }
         }

         while(TDEKeyMappings.LOCK_ON.m_90859_()) {
            if(tdePatch.isLockon()) {
               tdePatch.setLockOn(false);
            } else {
               tdePatch.searchTarget(false);
            }
         }

         while(TDEKeyMappings.LOCK_ON_CHANGE.m_90859_()) {
            if(tdePatch.isLockon()) {
               tdePatch.searchTarget(true);
            } else {
               tdePatch.searchTarget(false);
            }
         }

         if(TDEKeyMappings.INTERACTION.m_90859_()) {
            if(knockDownEntity != null) {
               sendSkillPacket(TDESkillSlots.EXECUTE, TDEKeyMappings.INTERACTION);
            }

            if(nearbyNPC != null) {
               NetworkHandler.sendToServer(new CallNPCPacket(nearbyNPC));
            } else if(nearbyCampfirePos != null) {
               patch.playAnimationSynchronized(TDELivingAnimations.TDE_CALLFIRE, 0.0F);
            } else if(nearbyBossFire != null) {
               patch.playAnimationSynchronized(TDELivingAnimations.TDE_REAVE, 0.0F);
            } else if(nearbyCanDestroyPos != null) {
               patch.playAnimationSynchronized(TDELivingAnimations.TDE_DESTROY, 0.0F);
            } else if(nearbyFogPos != null) {
               patch.playAnimationSynchronized(TDELivingAnimations.TDE_INTO_FOG, 0.0F);
               NetworkHandler.sendToServer(new IntoFogPacket(nearbyFogPos));
            }
         }
      }

   }

   @SubscribeEvent
   public static void onRenderLevel(RenderLevelStageEvent event) {
      if(event.getStage() == Stage.AFTER_SKY) {
         LocalPlayerPatch patch = ClientEngine.getInstance().getPlayerPatch();
         if(patch instanceof TDELocalPlayerPatch) {
            TDELocalPlayerPatch tdePatch = (TDELocalPlayerPatch)patch;
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if(player != null) {
               if(player.f_19797_ % 10 == 0) {
                  addTip(player);
                  nearbyCampfirePos = findNearbyCampfire(player);
                  nearbyNPC = findNearbyNPC(player);
                  nearbyBossFire = findNearbyBossFire(player);
                  nearbyFogPos = findNearbyFog(player);
                  nearbyCanDestroyPos = findNearbyBarrel(player);
               }

               label45: {
                  if(tdePatch.getTarget() != null) {
                     LivingEntity keyName1 = tdePatch.getTarget();
                     if(keyName1 instanceof EnemyEntity) {
                        EnemyEntity keyName = (EnemyEntity)keyName1;
                        if(keyName.isKnockdown()) {
                           knockDownEntity = keyName;
                           String keyName3 = TDEKeyMappings.INTERACTION.m_90863_().getString();
                           player.m_5661_(Component.m_237110_("msg.tde.execute", new Object[]{Component.m_237113_(keyName3).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.YELLOW), true);
                           break label45;
                        }
                     }
                  }

                  knockDownEntity = null;
               }

               String keyName2;
               if(nearbyNPC != null) {
                  keyName2 = TDEKeyMappings.INTERACTION.m_90863_().getString();
                  player.m_5661_(Component.m_237110_("msg.tde.talk", new Object[]{Component.m_237113_(keyName2).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.YELLOW), true);
               }

               if(nearbyBossFire != null) {
                  keyName2 = TDEKeyMappings.INTERACTION.m_90863_().getString();
                  player.m_5661_(Component.m_237110_("msg.tde.reave", new Object[]{Component.m_237113_(keyName2).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.YELLOW), true);
               }

               if(nearbyCanDestroyPos != null) {
                  keyName2 = TDEKeyMappings.INTERACTION.m_90863_().getString();
                  player.m_5661_(Component.m_237110_("msg.tde.destroy", new Object[]{Component.m_237113_(keyName2).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.YELLOW), true);
               }

               if(nearbyCampfirePos != null) {
                  keyName2 = TDEKeyMappings.INTERACTION.m_90863_().getString();
                  player.m_5661_(Component.m_237110_("msg.tde.summon", new Object[]{Component.m_237113_(keyName2).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.YELLOW), true);
               }

               if(nearbyFogPos != null) {
                  keyName2 = TDEKeyMappings.INTERACTION.m_90863_().getString();
                  player.m_5661_(Component.m_237110_("msg.tde.fog_door", new Object[]{Component.m_237113_(keyName2).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.YELLOW), true);
               }

            }
         }
      }
   }

   private static void addTip(LocalPlayer player) {
      Level level = player.m_9236_();
      BlockPos playerPos = player.m_20183_();
      byte radius = 15;

      for(int x = -radius; x <= radius; ++x) {
         for(int y = -radius; y <= radius; ++y) {
            for(int z = -radius; z <= radius; ++z) {
               BlockPos pos = playerPos.m_7918_(x, y, z);
               Block tip = player.m_9236_().m_8055_(pos).m_60734_();
               if(tip instanceof CreativeBarrelBlock) {
                  CreativeBarrelBlock creativeBarrelBlock = (CreativeBarrelBlock)tip;
               } else if(!level.m_8055_(pos).m_60713_(Blocks.f_50330_)) {
                  continue;
               }

               FX var11 = FXHelper.getFX(new ResourceLocation("photon:block/tip"));
               PosEffect tipEffect = new PosEffect(var11, player.m_9236_(), player, pos.m_252807_().m_82520_(0.0D, -0.5D, 0.0D), 15, false, true);
               tipEffect.start();
            }
         }
      }

   }

   private static BlockPos findNearbyBarrel(LocalPlayer player) {
      Level level = player.m_9236_();
      BlockPos playerPos = player.m_20183_();
      byte radius = 3;
      double angleThreshold = Math.cos(Math.toRadians(90.0D));
      Vec3 playerExactPos = player.m_20182_();
      Vec3 lookVec = player.m_20154_();

      for(int x = -radius; x <= radius; ++x) {
         for(int y = -radius; y <= radius; ++y) {
            for(int z = -radius; z <= radius; ++z) {
               BlockPos pos = playerPos.m_7918_(x, y, z);
               Vec3 blockCenter = new Vec3((double)pos.m_123341_() + 0.5D, (double)pos.m_123342_() + 0.5D, (double)pos.m_123343_() + 0.5D);
               Vec3 toBlock = blockCenter.m_82546_(playerExactPos);
               double distanceSq = toBlock.m_82556_();
               if(distanceSq >= 1.0E-4D) {
                  Vec3 direction = toBlock.m_82541_();
                  double dot = lookVec.m_82526_(direction);
                  if(dot >= angleThreshold && level.m_8055_(pos).m_60734_() instanceof CreativeBarrelBlock || level.m_8055_(pos).m_60713_(Blocks.f_50330_)) {
                     return pos;
                  }
               }
            }
         }
      }

      return null;
   }

   private static BlockPos findNearbyCampfire(LocalPlayer player) {
      Level level = player.m_9236_();
      BlockPos playerPos = player.m_20183_();
      byte radius = 3;
      double angleThreshold = Math.cos(Math.toRadians(90.0D));
      Vec3 playerExactPos = player.m_20182_();
      Vec3 lookVec = player.m_20154_();

      for(int x = -radius; x <= radius; ++x) {
         for(int y = -radius; y <= radius; ++y) {
            for(int z = -radius; z <= radius; ++z) {
               BlockPos pos = playerPos.m_7918_(x, y, z);
               Vec3 blockCenter = new Vec3((double)pos.m_123341_() + 0.5D, (double)pos.m_123342_() + 0.5D, (double)pos.m_123343_() + 0.5D);
               Vec3 toBlock = blockCenter.m_82546_(playerExactPos);
               double distanceSq = toBlock.m_82556_();
               if(distanceSq >= 1.0E-4D) {
                  Vec3 direction = toBlock.m_82541_();
                  double dot = lookVec.m_82526_(direction);
                  if(dot >= angleThreshold && level.m_8055_(pos).m_60734_() instanceof RespawnCampfireBlock) {
                     return pos;
                  }
               }
            }
         }
      }

      return null;
   }

   private static BlockPos findNearbyFog(LocalPlayer player) {
      Level level = player.m_9236_();
      BlockPos playerPos = player.m_20183_();
      byte radius = 2;
      double angleThreshold = Math.cos(Math.toRadians(45.0D));
      Vec3 playerExactPos = player.m_20182_();
      Vec3 lookVec = player.m_20154_();

      for(int x = -radius; x <= radius; ++x) {
         for(int y = -radius; y <= radius; ++y) {
            for(int z = -radius; z <= radius; ++z) {
               BlockPos pos = playerPos.m_7918_(x, y, z);
               BlockState state = level.m_8055_(pos);
               if(state.m_60734_() instanceof FogBlock) {
                  Vec3 blockCenter = new Vec3((double)pos.m_123341_() + 0.5D, (double)pos.m_123342_() + 0.5D, (double)pos.m_123343_() + 0.5D);
                  Vec3 toBlock = blockCenter.m_82546_(playerExactPos);
                  double distanceSq = toBlock.m_82556_();
                  if(distanceSq >= 1.0E-4D) {
                     Vec3 direction = toBlock.m_82541_();
                     double dot = lookVec.m_82526_(direction);
                     if(dot >= angleThreshold) {
                        Direction blockFacing = (Direction)state.m_61143_(FogBlock.FACING);
                        Direction playerFacing = player.m_6350_();
                        if(playerFacing == blockFacing.m_122424_()) {
                           return pos;
                        }
                     }
                  }
               }
            }
         }
      }

      return null;
   }

   private static BossSoulFireEntity findNearbyBossFire(LocalPlayer player) {
      Level level = player.m_9236_();
      Vec3 playerPos = player.m_20182_();
      byte radius = 5;
      AABB searchArea = new AABB(playerPos.f_82479_ - (double)radius, playerPos.f_82480_ - (double)radius, playerPos.f_82481_ - (double)radius, playerPos.f_82479_ + (double)radius, playerPos.f_82480_ + (double)radius, playerPos.f_82481_ + (double)radius);
      List entities = level.m_45933_(player, searchArea);
      Iterator var6 = entities.iterator();

      Entity entity;
      do {
         if(!var6.hasNext()) {
            return null;
         }

         entity = (Entity)var6.next();
      } while(!(entity instanceof BossSoulFireEntity));

      BossSoulFireEntity bossSoulFireEntity = (BossSoulFireEntity)entity;
      return bossSoulFireEntity;
   }

   private static NPCEntity findNearbyNPC(LocalPlayer player) {
      Level level = player.m_9236_();
      Vec3 playerPos = player.m_20182_();
      byte radius = 2;
      double angleThreshold = Math.cos(Math.toRadians(45.0D));
      Vec3 lookVec = player.m_20154_();
      AABB searchArea = new AABB(playerPos.f_82479_ - (double)radius, playerPos.f_82480_ - 1.0D, playerPos.f_82481_ - (double)radius, playerPos.f_82479_ + (double)radius, playerPos.f_82480_ + 1.0D, playerPos.f_82481_ + (double)radius);
      List entities = level.m_45933_(player, searchArea);
      Iterator var9 = entities.iterator();

      while(var9.hasNext()) {
         Entity entity = (Entity)var9.next();
         if(entity instanceof NPCEntity) {
            Vec3 toEntity = entity.m_20182_().m_82546_(playerPos);
            double distanceSq = toEntity.m_82556_();
            if(distanceSq >= 1.0E-4D) {
               Vec3 direction = toEntity.m_82541_();
               double dot = lookVec.m_82526_(direction);
               if(dot >= angleThreshold) {
                  return (NPCEntity)entity;
               }
            }
         }
      }

      return null;
   }

   private static boolean isKeyDown(KeyMapping key) {
      return InputConstants.m_84830_(minecraft.m_91268_().m_85439_(), key.getKey().m_84873_());
   }

   private static boolean wasKeyReleased(KeyMapping key) {
      return key.m_90859_() && !isKeyDown(key);
   }

   private static void reserveSkill(SkillSlot slot, KeyMapping key, ControllEngine controllEngine) {
      if(controllEngine != null) {
         ControlEngineAccessor accessor = (ControlEngineAccessor)controllEngine;
         accessor.setReserveCounter(8);
         accessor.setReservedOrChargingSkillSlot(slot);
         accessor.setReservedKey(key);
      }

   }

   public static void sendSkillPacket(SkillSlot slot, KeyMapping key) {
      LocalPlayerPatch playerPatch = ClientEngine.getInstance().getPlayerPatch();
      if(playerPatch != null) {
         SkillContainer skillContainer = playerPatch.getSkill(slot);
         if(skillContainer != null && skillContainer.sendExecuteRequest(playerPatch, ClientEngine.getInstance().controllEngine).shouldReserverKey()) {
            reserveSkill(slot, key, ClientEngine.getInstance().controllEngine);
         }
      }

   }

}
