package com.merlin204.tde.client;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent.ComputeCameraAngles;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.loading.FMLEnvironment;
import yesman.epicfight.api.utils.math.Vec3f;

@EventBusSubscriber(
   modid = "tde",
   value = {Dist.CLIENT}
)
public class CameraShake {

   private static final float DECAY_RATE = 0.95F;
   private static int shakeDuration = 0;
   private static float currentIntensity = 0.0F;
   private static float baseIntensity = 0.0F;
   private static float frequency = 3.0F;
   @Nullable
   private static Vec3 center;
   private static float radius;
   private static float minIntensity;


   public static void shake(int duration, float intensity, float frequency, Vec3 center, float radius) {
      if(FMLEnvironment.dist == Dist.CLIENT && intensity > baseIntensity) {
         shakeDuration = duration;
         baseIntensity = intensity;
         currentIntensity = intensity;
         frequency = frequency;
         center = center;
         radius = radius;
      }

   }

   @SubscribeEvent
   public static void onCameraUpdate(ComputeCameraAngles event) {
      if(shouldApplyShake()) {
         applyShakeEffect(event, (float)event.getPartialTick());
         updateShakeState();
      }

   }

   private static boolean shouldApplyShake() {
      LocalPlayer player = Minecraft.m_91087_().f_91074_;
      return player != null && shakeDuration > 0 && !Minecraft.m_91087_().m_91104_() && center != null;
   }

   private static void applyShakeEffect(ComputeCameraAngles event, float partialTicks) {
      LocalPlayer player = Minecraft.m_91087_().f_91074_;
      Vec3 playerPos = player.m_20182_();
      double distanceToCenter = playerPos.m_82554_(center);
      float distanceFactor = (float)Math.max(0.0D, 1.0D - distanceToCenter / (double)radius);
      float attenuatedIntensity = currentIntensity * distanceFactor;
      float time = ((float)player.f_19797_ + partialTicks) * frequency;
      float progress = 1.0F - (float)shakeDuration / ((float)shakeDuration + partialTicks);
      float dynamicIntensity = attenuatedIntensity * (1.0F - progress * progress);
      Vec3f shakeOffset = calculateShakeOffset(time, dynamicIntensity);
      event.setPitch(event.getPitch() + shakeOffset.x);
      event.setYaw(event.getYaw() + shakeOffset.y);
      event.setRoll(event.getRoll() + shakeOffset.z);
   }

   private static Vec3f calculateShakeOffset(float time, float intensity) {
      return new Vec3f(intensity * (float)(Math.sin((double)time * 1.1D) * 0.6000000238418579D), intensity * (float)(Math.cos((double)time * 0.9D) * 0.699999988079071D), intensity * (float)Math.sin((double)time * 1.3D + 2.0D) * 0.4F);
   }

   private static void updateShakeState() {
      if(!Minecraft.m_91087_().m_91104_()) {
         --shakeDuration;
         currentIntensity *= 0.95F;
         currentIntensity = Math.max(currentIntensity, 0.01F);
         if(shakeDuration <= 0) {
            reset();
         }
      }

   }

   public static void reset() {
      shakeDuration = 0;
      currentIntensity = 0.0F;
      baseIntensity = 0.0F;
   }

}
