package com.merlin204.tde.capabilitiy.player.campfiredata;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;

public class PlayerCampfireData {

   private final Set unlockedCampfires = new HashSet();


   public void unlockCampfire(String campfireId) {
      this.unlockedCampfires.add(campfireId);
   }

   public boolean hasUnlocked(String campfireId) {
      return this.unlockedCampfires.contains(campfireId);
   }

   public Set getUnlockedCampfires() {
      return Collections.unmodifiableSet(this.unlockedCampfires);
   }

   public CompoundTag serializeNBT() {
      CompoundTag nbt = new CompoundTag();
      ListTag list = new ListTag();
      this.unlockedCampfires.forEach(list);
      nbt.m_128365_("UnlockedCampfires", list);
      return nbt;
   }

   public void deserializeNBT(CompoundTag nbt) {
      this.unlockedCampfires.clear();
      if(nbt.m_128425_("UnlockedCampfires", 9)) {
         ListTag list = nbt.m_128437_("UnlockedCampfires", 8);

         for(int i = 0; i < list.size(); ++i) {
            this.unlockedCampfires.add(list.m_128778_(i));
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$serializeNBT$0(ListTag list, String id) {
      list.add(StringTag.m_129297_(id));
   }
}
