package com.merlin204.tde.capabilitiy.player.campfiredata;

import com.merlin204.tde.block.respawncampfireblock.RespawnCampfireBlock;
import com.merlin204.tde.capabilitiy.player.TDEPlayerCapabilities;
import com.merlin204.tde.capabilitiy.player.campfiredata.PlayerCampfireData;
import com.merlin204.tde.events.ForgeModEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CampfireManager {

   private static final Map CAMPFIRE_POSITIONS = new ConcurrentHashMap();


   public static void registerCampfire(String id, BlockPos pos) {
      CAMPFIRE_POSITIONS.put(id, pos);
   }

   public static BlockPos getCampfirePosition(String id) {
      return (BlockPos)CAMPFIRE_POSITIONS.get(id);
   }

   public static void unlockCampfireForPlayer(Player player, String campfireId) {
      player.getCapability(TDEPlayerCapabilities.PLAYER_CAMPFIRE_DATA);
      campfireId.ifPresent(player);
   }

   public static List getUnlockedCampfiresForPlayer(Player player) {
      ArrayList result = new ArrayList();
      player.getCapability(TDEPlayerCapabilities.PLAYER_CAMPFIRE_DATA).ifPresent(result);
      return result;
   }

   // $FF: synthetic method
   private static void lambda$getUnlockedCampfiresForPlayer$3(List result, PlayerCampfireData data) {
      data.getUnlockedCampfires().forEach(result);
   }

   // $FF: synthetic method
   private static void lambda$getUnlockedCampfiresForPlayer$2(List result, String id) {
      BlockPos pos = getCampfirePosition(id);
      if(pos != null) {
         result.add(pos);
      }

   }

   // $FF: synthetic method
   private static void lambda$unlockCampfireForPlayer$1(String campfireId, Player player, PlayerCampfireData data) {
      data.unlockCampfire(campfireId);
      BlockPos campfirePos = getCampfirePosition(campfireId);
      if(campfirePos != null) {
         Level serverPlayer = player.m_9236_();
         BlockState state = serverPlayer.m_8055_(campfirePos);
         if(state.m_60734_() instanceof RespawnCampfireBlock) {
            serverPlayer.m_7731_(campfirePos, (BlockState)state.m_61124_(RespawnCampfireBlock.LIT, Boolean.valueOf(true)), 3);
         }
      }

      if(player instanceof ServerPlayer) {
         ServerPlayer serverPlayer1 = (ServerPlayer)player;
         serverPlayer1.getCapability(TDEPlayerCapabilities.PLAYER_CAMPFIRE_DATA).ifPresent(serverPlayer1);
      }

   }

   // $FF: synthetic method
   private static void lambda$unlockCampfireForPlayer$0(ServerPlayer serverPlayer, PlayerCampfireData d) {
      ForgeModEvents.syncCampfireData(serverPlayer, d);
   }

}
