package com.merlin204.tde.capabilitiy.player.ability.config;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAbilities;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class AbilityConfig {

   private static final Map STATIC_MAX_OVERRIDES = new HashMap();
   private static final Map DYNAMIC_RULES = new HashMap();


   public static void registerDynamicRule(AbilityType targetType, Function rule) {
      DYNAMIC_RULES.put(targetType, rule);
   }

   public static float getEffectiveMax(AbilityType type, PlayerAbilities attributes) {
      return DYNAMIC_RULES.containsKey(type)?((Float)((Function)DYNAMIC_RULES.get(type)).apply(attributes)).floatValue():((Float)STATIC_MAX_OVERRIDES.getOrDefault(type, Float.valueOf(type.max))).floatValue();
   }

}
