package com.merlin204.tde.capabilitiy.player.ability;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAttribute;
import com.merlin204.tde.network.NetworkHandler;
import com.merlin204.tde.network.client.ClientAbilitySyncPacket;
import com.merlin204.tde.network.server.AbilitySyncPacket;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerAbilities {

   public final Map attributes = new EnumMap(AbilityType.class);


   public PlayerAbilities() {
      AbilityType[] var1 = AbilityType.values();
      int var2 = var1.length;

      for(int var3 = 0; var3 < var2; ++var3) {
         AbilityType type = var1[var3];
         this.attributes.put(type, new PlayerAttribute(type, this));
      }

   }

   public PlayerAttribute get(AbilityType type) {
      return (PlayerAttribute)this.attributes.get(type);
   }

   public void saveToNBT(CompoundTag nbt) {
      CompoundTag attributesTag = new CompoundTag();
      this.attributes.forEach(attributesTag);
      nbt.m_128365_("Abilities", attributesTag);
   }

   public void loadFromNBT(CompoundTag nbt) {
      CompoundTag attributesTag = nbt.m_128469_("Abilities");
      this.attributes.forEach(attributesTag);
   }

   public PlayerAbilities getParent() {
      return this;
   }

   public void syncToClient(Player player) {
      if(!player.m_9236_().f_46443_) {
         CompoundTag data = new CompoundTag();
         this.saveToNBT(data);
         NetworkHandler.sendToClient(new AbilitySyncPacket(data), (ServerPlayer)player);
      }

   }

   public void syncToServer(Player player) {
      if(player.m_9236_().f_46443_) {
         CompoundTag data = new CompoundTag();
         this.saveToNBT(data);
         NetworkHandler.sendToServer(new ClientAbilitySyncPacket(data));
      }

   }

   // $FF: synthetic method
   private static void lambda$loadFromNBT$1(CompoundTag attributesTag, AbilityType type, PlayerAttribute attr) {
      if(attributesTag.m_128441_(type.id)) {
         float value = attributesTag.m_128457_(type.id);
         attr.set(value);
      }

   }

   // $FF: synthetic method
   private static void lambda$saveToNBT$0(CompoundTag attributesTag, AbilityType type, PlayerAttribute attr) {
      attributesTag.m_128350_(type.id, attr.get());
   }
}
