package com.merlin204.tde.capabilitiy.player.ability;

import com.merlin204.tde.capabilitiy.player.TDEPlayerCapabilities;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAbilities;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class AbilityProvider implements ICapabilityProvider, INBTSerializable {

   private final LazyOptional instance = LazyOptional.of(this);
   private PlayerAbilities abilities = null;


   private PlayerAbilities createAbilities() {
      if(this.abilities == null) {
         this.abilities = new PlayerAbilities();
      }

      return this.abilities;
   }

   @NotNull
   public LazyOptional getCapability(@NotNull Capability cap, @Nullable Direction side) {
      return TDEPlayerCapabilities.PLAYER_ABILITIES.orEmpty(cap, this.instance.cast());
   }

   public CompoundTag serializeNBT() {
      CompoundTag nbt = new CompoundTag();
      this.createAbilities().saveToNBT(nbt);
      return nbt;
   }

   public void deserializeNBT(CompoundTag nbt) {
      this.createAbilities().loadFromNBT(nbt);
   }
}
