package com.merlin204.tde.block.respawncampfireblock;

import com.lowdragmc.lowdraglib.gui.factory.BlockEntityUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.block.respawncampfireblock.FireBlockRegister;
import com.merlin204.tde.block.respawncampfireblock.PlayerSnapshot;
import com.merlin204.tde.block.respawncampfireblock.RespawnCampfireBlock;
import com.merlin204.tde.capabilitiy.player.campfiredata.CampfireManager;
import com.merlin204.tde.client.gui.campfire.CampfireUI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.Map.Entry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RespawnCampfireBlockEntity extends BlockEntity implements IUIHolder {

   private String campfireId = "";
   private final Map playerSnapshots = new HashMap();


   public void setCampfireId(String id) {
      this.campfireId = id;
      CampfireManager.registerCampfire(id, this.m_58899_());
      this.m_6596_();
   }

   public String getCampfireId() {
      return this.campfireId;
   }

   public RespawnCampfireBlockEntity(BlockPos pos, BlockState state) {
      super((BlockEntityType)FireBlockRegister.TEST_CAMPFIRE_BE.get(), pos, state);
   }

   public RespawnCampfireBlockEntity(BlockEntityType blockEntityType, BlockPos pos, BlockState state) {
      super(blockEntityType, pos, state);
   }

   public void savePlayerState(Player player) {
      PlayerSnapshot snapshot = new PlayerSnapshot();
      snapshot.captureFrom(player);
      this.playerSnapshots.put(player.m_20148_(), snapshot);
      this.m_6596_();
   }

   public boolean restorePlayerState(Player player) {
      UUID playerId = player.m_20148_();
      if(this.playerSnapshots.containsKey(playerId)) {
         ((PlayerSnapshot)this.playerSnapshots.get(playerId)).applyTo(player);
         this.playerSnapshots.remove(playerId);
         this.m_6596_();
         return true;
      } else {
         return false;
      }
   }

   protected void m_183515_(CompoundTag tag) {
      super.m_183515_(tag);
      CompoundTag snapshotsTag = new CompoundTag();
      if(!this.campfireId.isEmpty()) {
         tag.m_128359_("CampfireId", this.campfireId);
      }

      Iterator var3 = this.playerSnapshots.entrySet().iterator();

      while(var3.hasNext()) {
         Entry entry = (Entry)var3.next();
         snapshotsTag.m_128365_(((UUID)entry.getKey()).toString(), ((PlayerSnapshot)entry.getValue()).save());
      }

      tag.m_128365_("PlayerSnapshots", snapshotsTag);
   }

   public void m_142466_(CompoundTag tag) {
      super.m_142466_(tag);
      this.playerSnapshots.clear();
      if(tag.m_128441_("CampfireId")) {
         this.campfireId = tag.m_128461_("CampfireId");
         CampfireManager.registerCampfire(this.campfireId, this.m_58899_());
      }

      if(tag.m_128441_("PlayerSnapshots")) {
         CompoundTag snapshotsTag = tag.m_128469_("PlayerSnapshots");
         Iterator var3 = snapshotsTag.m_128431_().iterator();

         while(var3.hasNext()) {
            String key = (String)var3.next();

            try {
               UUID playerId = UUID.fromString(key);
               PlayerSnapshot snapshot = new PlayerSnapshot();
               snapshot.load(snapshotsTag.m_128469_(key));
               this.playerSnapshots.put(playerId, snapshot);
            } catch (IllegalArgumentException var7) {
               ;
            }
         }
      }

   }

   public void onPlayerInteract(Player player) {
      Block var3 = this.m_58900_().m_60734_();
      if(var3 instanceof RespawnCampfireBlock) {
         RespawnCampfireBlock serverPlayer = (RespawnCampfireBlock)var3;
         serverPlayer.callEvent(player, this.m_58899_());
      }

      if(this.f_58857_ != null && !this.f_58857_.f_46443_) {
         if(player instanceof ServerPlayer) {
            ServerPlayer serverPlayer1 = (ServerPlayer)player;
            BlockEntityUIFactory.INSTANCE.openUI(this, serverPlayer1);
            serverPlayer1.m_9158_(this.f_58857_.m_46472_(), this.f_58858_.m_7494_(), 0.0F, true, false);
         }

         this.m_6596_();
      }
   }

   public CompoundTag m_5995_() {
      CompoundTag tag = new CompoundTag();
      this.m_183515_(tag);
      return tag;
   }

   public WidgetGroup createUI() {
      return CampfireUI.createUI();
   }

   public ModularUI createUI(Player player) {
      return new ModularUI(this.createUI(), this, player);
   }

   public boolean isInvalid() {
      return false;
   }

   public boolean isRemote() {
      return false;
   }

   public void markAsDirty() {
   }
}
