package com.merlin204.tde.block.respawncampfireblock;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.block.respawncampfireblock.RespawnCampfireBlockEntity;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.photon.PosEffect;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.BlockBehaviour.Properties;
import net.minecraft.world.level.block.state.StateDefinition.Builder;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RespawnCampfireBlock extends CampfireBlock implements EntityBlock {

   public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
   public static final BooleanProperty SIGNAL_FIRE = BlockStateProperties.f_61450_;
   public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
   public static final BooleanProperty SOUL_CAMPFIRE = BooleanProperty.m_61465_("soul_campfire");


   public RespawnCampfireBlock(Properties properties) {
      super(false, 0, properties);
      this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(f_51230_, Direction.NORTH)).m_61124_(LIT, Boolean.valueOf(true))).m_61124_(SIGNAL_FIRE, Boolean.valueOf(false))).m_61124_(SOUL_CAMPFIRE, Boolean.valueOf(false))).m_61124_(WATERLOGGED, Boolean.valueOf(false)));
   }

   protected void m_7926_(Builder builder) {
      builder.m_61104_(new Property[]{f_51230_, LIT, SIGNAL_FIRE, SOUL_CAMPFIRE, WATERLOGGED});
   }

   public BlockState m_5573_(BlockPlaceContext context) {
      return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(f_51230_, context.m_8125_().m_122424_())).m_61124_(WATERLOGGED, Boolean.valueOf(false))).m_61124_(LIT, Boolean.valueOf(true))).m_61124_(SOUL_CAMPFIRE, Boolean.valueOf(false))).m_61124_(SIGNAL_FIRE, Boolean.valueOf(false));
   }

   public BlockEntity m_142194_(BlockPos pos, BlockState state) {
      return new RespawnCampfireBlockEntity(pos, state);
   }

   public void callEvent(Player player, BlockPos blockPos) {
      TDEAbilityUtils.setAbility(AbilityType.SOULFIRE, player, 4.0F);
      if(player instanceof ServerPlayer) {
         ServerPlayer serverPlayer = (ServerPlayer)player;
         player.m_5634_(1.0E8F);
      }

   }

   public BlockEntityTicker m_142354_(Level level, BlockState state, BlockEntityType type) {
      return level.f_46443_?this.createClientTicker():this.createServerTicker();
   }

   private BlockEntityTicker createServerTicker() {
      // $FF: Couldn't be decompiled
   }

   private BlockEntityTicker createClientTicker() {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static void lambda$createClientTicker$1(Level level, BlockPos pos, BlockState blockState, BlockEntity blockEntity) {
      if(blockEntity instanceof RespawnCampfireBlockEntity) {
         RespawnCampfireBlockEntity campfire = (RespawnCampfireBlockEntity)blockEntity;
         if(Minecraft.m_91087_().f_91074_.m_20238_(pos.m_252807_()) < 10.0D) {
            Vec3 center = campfire.m_58899_().m_252807_();
            if(Minecraft.m_91087_().f_91074_.f_19797_ < 2) {
               return;
            }

            FX fx = FXHelper.getFX(new ResourceLocation("photon:player/call_fire"));
            PosEffect effect = new PosEffect(fx, level, Minecraft.m_91087_().f_91074_, new Vec3(center.f_82479_, center.f_82480_ - 1.0D, center.f_82481_), 5, false, false);
            effect.start();
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$createServerTicker$0(Level lvl, BlockPos pos, BlockState blockState, BlockEntity blockEntity) {
      if(blockEntity instanceof RespawnCampfireBlockEntity) {
         RespawnCampfireBlockEntity campfire = (RespawnCampfireBlockEntity)blockEntity;
         float radius = 3.0F;
         List players = lvl.m_45976_(Player.class, (new AABB(pos)).m_82400_((double)radius));
         if(!players.isEmpty()) {
            if(!((Boolean)blockState.m_61143_(SOUL_CAMPFIRE)).booleanValue()) {
               lvl.m_7731_(pos, (BlockState)blockState.m_61124_(SOUL_CAMPFIRE, Boolean.valueOf(true)), 3);
            }
         } else if(((Boolean)blockState.m_61143_(SOUL_CAMPFIRE)).booleanValue()) {
            lvl.m_7731_(pos, (BlockState)blockState.m_61124_(SOUL_CAMPFIRE, Boolean.valueOf(false)), 3);
         }
      }

   }

}
