package com.merlin204.tde.block.respawncampfireblock;

import com.merlin204.tde.block.respawncampfireblock.RespawnCampfireBlock;
import com.merlin204.tde.block.respawncampfireblock.RespawnCampfireBlockEntity;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.animations.bipe.TDELivingAnimations;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent.PlayerRespawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

@EventBusSubscriber(
   modid = "tde"
)
public class PlayerRespawnHandler {

   private static final Set pendingRestorePlayers = new HashSet();


   @SubscribeEvent
   public static void onPlayerDeath(LivingDeathEvent event) {
      LivingEntity serverPlayer = event.getEntity();
      if(serverPlayer instanceof Player) {
         Player player = (Player)serverPlayer;
         if(player instanceof ServerPlayer) {
            ServerPlayer serverPlayer1 = (ServerPlayer)player;
            BlockPos respawnPos = serverPlayer1.m_8961_();
            if(respawnPos != null && player.m_9236_().m_8055_(respawnPos.m_7495_()).m_60734_() instanceof RespawnCampfireBlock) {
               ;
            }
         }
      }

   }

   private static void clearPlayerInventory(Player player) {
      int i;
      for(i = 0; i < 36; ++i) {
         player.m_150109_().m_6836_(i, ItemStack.f_41583_);
      }

      for(i = 0; i < 4; ++i) {
         player.m_150109_().f_35975_.set(i, ItemStack.f_41583_);
      }

      player.m_150109_().f_35976_.set(0, ItemStack.f_41583_);
      player.f_36078_ = 0;
      player.f_36080_ = 0.0F;
      player.f_36079_ = 0;
   }

   public static boolean needsRestore(UUID playerId) {
      return pendingRestorePlayers.contains(playerId);
   }

   public static void clearRestoreFlag(UUID playerId) {
      pendingRestorePlayers.remove(playerId);
   }

   @SubscribeEvent
   public static void onPlayerRespawn(PlayerRespawnEvent event) {
      Player player = event.getEntity();
      if(player instanceof ServerPlayer) {
         ServerPlayer serverPlayer = (ServerPlayer)player;
         BlockPos respawnPos = serverPlayer.m_8961_();
         if(respawnPos != null) {
            Block blockEntity = player.m_9236_().m_8055_(respawnPos.m_7495_()).m_60734_();
            if(blockEntity instanceof RespawnCampfireBlock) {
               RespawnCampfireBlock respawnCampfireBlock = (RespawnCampfireBlock)blockEntity;
               respawnCampfireBlock.callEvent(player, respawnPos);
               BlockEntity blockEntity1 = player.m_9236_().m_7702_(respawnPos.m_7495_());
               ((TDEServerPlayerPatch)EpicFightCapabilities.getEntityPatch(player, TDEServerPlayerPatch.class)).playAnimationSynchronized(TDELivingAnimations.TDE_RESPAWN, 0.0F);
               if(blockEntity1 instanceof RespawnCampfireBlockEntity) {
                  RespawnCampfireBlockEntity var6 = (RespawnCampfireBlockEntity)blockEntity1;
               }
            }
         }
      }

   }

}
