package com.merlin204.tde.block.fogblock;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.block.FogBlockRegister;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.photon.PosEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Direction.Plane;
import net.minecraft.core.Holder.Reference;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrierBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.BlockBehaviour.Properties;
import net.minecraft.world.level.block.state.StateDefinition.Builder;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FogBlock extends BarrierBlock implements EntityBlock {

   public static final DirectionProperty FACING = DirectionProperty.m_61546_("facing", Plane.HORIZONTAL);
   private int coolDown = 0;


   public FogBlock(Properties properties) {
      super(properties);
      this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, Direction.NORTH));
   }

   protected void m_7926_(Builder builder) {
      builder.m_61104_(new Property[]{FACING});
   }

   public BlockState m_5573_(BlockPlaceContext context) {
      return (BlockState)this.m_49966_().m_61124_(FACING, context.m_8125_().m_122424_());
   }

   @Nullable
   public BlockEntityTicker m_142354_(Level pLevel, BlockState pState, BlockEntityType pBlockEntityType) {
      if(pLevel.f_46443_) {
         FX fx = FXHelper.getFX(new ResourceLocation("photon:block/fog"));
         return fx;
      } else {
         return null;
      }
   }

   public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
      if(this.coolDown > 0) {
         --this.coolDown;
      }

      if(level.f_46443_) {
         Minecraft mc = Minecraft.m_91087_();
         LocalPlayer player = mc.f_91074_;
         Vec3 center = pos.m_252807_();
         Direction facing = (Direction)state.m_61143_(FACING);
         double x = (double)pos.m_123341_() + 0.5D + (double)facing.m_122429_() * 0.6D;
         double y = (double)pos.m_123342_() + 0.5D + (double)facing.m_122430_() * 0.6D;
         double z = (double)pos.m_123343_() + 0.5D + (double)facing.m_122431_() * 0.6D;
         level.m_7106_(ParticleTypes.f_123744_, x, y, z, 0.0D, 0.0D, 0.0D);
      }
   }

   public void spawnEntity(ServerLevel level, BlockPos pos, Player player) {
      if(this.coolDown <= 1) {
         BlockEntity blockEntity = level.m_7702_(pos);
         if(blockEntity instanceof FogBlock.FogBlockEntity) {
            FogBlock.FogBlockEntity barrierEntity = (FogBlock.FogBlockEntity)blockEntity;
            EntityType entityType = barrierEntity.getEntityType();
            Vec3 offset = barrierEntity.getSpawnOffset();
            BlockState state = level.m_8055_(pos);
            Direction facing = (Direction)state.m_61143_(FACING);
            double spawnX = offset.f_82479_;
            double spawnY = offset.f_82480_;
            double spawnZ = offset.f_82481_;
            Entity entity = entityType.m_20615_(level);
            if(entity != null) {
               entity.m_6034_(spawnX, spawnY, spawnZ);
               level.m_7967_(entity);
               if(entity instanceof EnemyEntity) {
                  EnemyEntity enemyEntity = (EnemyEntity)entity;
                  enemyEntity.m_6710_(player);
                  enemyEntity.getEnemyPatch().rotateTo(player, 360.0F, false);
               }
            }
         }

         this.coolDown = 30;
      }
   }

   public void clearSurroundingBarriers(ServerLevel level, BlockPos pos, int radius) {
      BlockState selfState = level.m_8055_(pos);
      if(selfState.m_60713_(this)) {
         for(int x = -radius; x <= radius; ++x) {
            for(int y = -radius; y <= radius; ++y) {
               for(int z = -radius; z <= radius; ++z) {
                  BlockPos targetPos = pos.m_7918_(x, y, z);
                  BlockState targetState = level.m_8055_(targetPos);
                  if(targetState.m_60734_() instanceof BarrierBlock) {
                     level.m_46961_(targetPos, false);
                  }
               }
            }
         }

         level.m_46961_(pos, false);
      }
   }

   @Nullable
   public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
      return new FogBlock.FogBlockEntity(blockPos, blockState);
   }

   public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
      return true;
   }

   public RenderShape m_7514_(BlockState pState) {
      return RenderShape.INVISIBLE;
   }

   public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
      return 1.0F;
   }

   // $FF: synthetic method
   private static void lambda$getTicker$0(BlockState pState, FX fx, Level lvl, BlockPos pos, BlockState blockState, BlockEntity blockEntity) {
      if(blockEntity instanceof FogBlock.FogBlockEntity) {
         FogBlock.FogBlockEntity directedBarrierBlockEntity = (FogBlock.FogBlockEntity)blockEntity;
         Direction facing = (Direction)pState.m_61143_(FACING);
         Minecraft mc = Minecraft.m_91087_();
         LocalPlayer player = mc.f_91074_;
         if(player != null) {
            Vec3 center = directedBarrierBlockEntity.m_58899_().m_252807_();
            PosEffect effect = new PosEffect(fx, player.m_9236_(), player, new Vec3(center.f_82479_, center.f_82480_, center.f_82481_), 5, false, false);
            effect.setRotation(0.0D, (double)facing.m_122435_(), 0.0D);
            effect.start();
         }
      }

   }


   public static class FogBlockEntity extends BlockEntity {

      private EntityType entityType;
      private Vec3 spawnOffset;


      public FogBlockEntity(BlockPos pos, BlockState state) {
         super((BlockEntityType)FogBlockRegister.FOG_GATE_BLOCK_ENTITY.get(), pos, state);
         this.entityType = EntityType.f_20515_;
         this.spawnOffset = new Vec3(0.0D, 0.5D, 1.0D);
      }

      public EntityType getEntityType() {
         return this.entityType;
      }

      public void setEntityType(EntityType entityType) {
         this.entityType = entityType;
         this.m_6596_();
      }

      public Vec3 getSpawnOffset() {
         return this.spawnOffset;
      }

      public void setSpawnOffset(Vec3 spawnOffset) {
         this.spawnOffset = spawnOffset;
         this.m_6596_();
      }

      protected void m_183515_(CompoundTag tag) {
         super.m_183515_(tag);
         tag.m_128359_("EntityType", EntityType.m_20613_(this.entityType).toString());
         tag.m_128347_("OffsetX", this.spawnOffset.f_82479_);
         tag.m_128347_("OffsetY", this.spawnOffset.f_82480_);
         tag.m_128347_("OffsetZ", this.spawnOffset.f_82481_);
      }

      public void m_142466_(CompoundTag param1) {
         // $FF: Couldn't be decompiled
      }

      // $FF: synthetic method
      private void lambda$load$1(EntityType t) {
         this.entityType = t;
      }

      // $FF: synthetic method
      private static EntityType lambda$load$0(Reference d) {
         return (EntityType)d.get();
      }
   }
}
