package com.merlin204.tde.block.fogblock;

import com.merlin204.tde.block.fogblock.FogBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder.Reference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Item.Properties;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class BarrierConfiguratorItem extends Item {

   private static final Lazy DEFAULT_ENTITY;
   private static final Vec3 DEFAULT_OFFSET;
   private static final int CONFIG_RADIUS = 3;


   public BarrierConfiguratorItem(Properties properties) {
      super(properties);
   }

   public InteractionResultHolder m_7203_(Level level, Player player, InteractionHand hand) {
      ItemStack stack = player.m_21120_(hand);
      if(level.m_5776_()) {
         return InteractionResultHolder.m_19098_(stack);
      } else {
         BlockPos playerPos = player.m_20183_();
         AABB area = new AABB(playerPos.m_7918_(-3, -3, -3), playerPos.m_7918_(3, 3, 3));
         EntityType entityType = getStoredEntityType(stack);
         Vec3 offset = getStoredOffset(stack);
         int configuredBlocks = 0;

         for(int x = (int)area.f_82288_; (double)x <= area.f_82291_; ++x) {
            for(int y = (int)area.f_82289_; (double)y <= area.f_82292_; ++y) {
               for(int z = (int)area.f_82290_; (double)z <= area.f_82293_; ++z) {
                  BlockPos pos = new BlockPos(x, y, z);
                  Block block = level.m_8055_(pos).m_60734_();
                  if(block instanceof FogBlock) {
                     BlockEntity blockEntity = level.m_7702_(pos);
                     if(blockEntity instanceof FogBlock.FogBlockEntity) {
                        FogBlock.FogBlockEntity barrierEntity = (FogBlock.FogBlockEntity)blockEntity;
                        barrierEntity.setEntityType(entityType);
                        barrierEntity.setSpawnOffset(offset);
                        ++configuredBlocks;
                     }
                  }
               }
            }
         }

         if(configuredBlocks > 0) {
            configuredBlocks.m_5661_(Component.m_237113_(EntityType.m_20613_(entityType).toString()), true);
            return InteractionResultHolder.m_19090_(stack);
         } else {
            player.m_5661_(Component.m_237113_("附近没有找到屏障方块！"), true);
            return InteractionResultHolder.m_19100_(stack);
         }
      }
   }

   public void m_7373_(ItemStack stack, @Nullable Level level, List tooltip, TooltipFlag flag) {
      super.m_7373_(stack, level, tooltip, flag);
      EntityType entityType = getStoredEntityType(stack);
      Vec3 offset = getStoredOffset(stack);
      tooltip.add(Component.m_237113_(EntityType.m_20613_(entityType).toString()));
      tooltip.add(Component.m_237113_(String.format("(%.1f, %.1f, %.1f)", new Object[]{Double.valueOf(offset.f_82479_), Double.valueOf(offset.f_82480_), Double.valueOf(offset.f_82481_)})));
      tooltip.add(Component.m_237113_("右键点击屏障方块以应用配置"));
   }

   public static EntityType getStoredEntityType(ItemStack param0) {
      // $FF: Couldn't be decompiled
   }

   public static Vec3 getStoredOffset(ItemStack stack) {
      CompoundTag tag = stack.m_41784_();
      return tag.m_128441_("OffsetX") && tag.m_128441_("OffsetY") && tag.m_128441_("OffsetZ")?new Vec3(tag.m_128459_("OffsetX"), tag.m_128459_("OffsetY"), tag.m_128459_("OffsetZ")):DEFAULT_OFFSET;
   }

   // $FF: synthetic method
   private static EntityType lambda$getStoredEntityType$1(Reference d) {
      return (EntityType)d.get();
   }

   // $FF: synthetic method
   private static EntityType lambda$static$0() {
      return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("tde:b1"));
   }

   static {
      // $FF: Couldn't be decompiled
   }
}
