/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.util;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.CameraShake;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.photon.JointEffect;
import com.merlin204.tde.photon.PosEffect;
import com.merlin204.tde.util.TDEAbilityUtils;
import com.merlin204.tde.util.TDEAnimationUtils;
import com.merlin204.tde.world.TDEDamageSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;

public class TDEEventUtils {
    public static AnimationEvent.InPeriodEvent rotateToTarget(int startFrame, int endFrame, float step) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            if (entityPatch.getTarget() != null) {
                entityPatch.rotateTo((Entity)entityPatch.getTarget(), step, true);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InPeriodEvent chaseToTarget(int startFrame, int endFrame, float speed, float distance) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            if (entityPatch.getTarget() != null) {
                Vec3 playerPosition = ((LivingEntity)entityPatch.getOriginal()).m_20182_();
                Vec3 targetPosition = entityPatch.getTarget().m_20182_();
                if (((LivingEntity)entityPatch.getOriginal()).m_20182_().m_82554_(entityPatch.getTarget().m_20182_()) > (double)distance) {
                    Vec3 dir = entityPatch.getTarget().m_20182_().m_82546_(((LivingEntity)entityPatch.getOriginal()).m_20182_()).m_82541_().m_82490_((double)speed);
                    ((LivingEntity)entityPatch.getOriginal()).m_6478_(MoverType.SELF, new Vec3(dir.f_82479_, 0.0, dir.f_82481_));
                }
                entityPatch.rotateTo((Entity)entityPatch.getTarget(), 5.0f, true);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InPeriodEvent hurtNearTarget(int startFrame, int endFrame, float damage, int impactLevel, int intervalTick, float distance) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            if (entityPatch.getTarget() != null) {
                Vec3 playerPosition = ((LivingEntity)entityPatch.getOriginal()).m_20182_();
                Vec3 targetPosition = entityPatch.getTarget().m_20182_();
                if (((LivingEntity)entityPatch.getOriginal()).m_20182_().m_82554_(entityPatch.getTarget().m_20182_()) < (double)distance) {
                    if (((LivingEntity)entityPatch.getOriginal()).f_19797_ % intervalTick != 0) {
                        return;
                    }
                    TDEDamageSource tdeDamageSource = new TDEDamageSource((DamageSource)entityPatch.getDamageSource(null, InteractionHand.MAIN_HAND));
                    tdeDamageSource.setImpactLevel(impactLevel);
                    entityPatch.getTarget().m_6469_((DamageSource)tdeDamageSource, damage);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InPeriodEvent fxTrail(int startFrame, int endFrame, Joint joint, Vec3 startOffset, Vec3 endOffset, float timeInterpolation, int fxCount, String path, float random) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            FX fx = FXHelper.getFX((ResourceLocation)new ResourceLocation(path));
            AnimationPlayer player = entityPatch.getAnimator().getPlayerFor(null);
            float prevElapsedTime = player.getPrevElapsedTime();
            float elapsedTime = player.getElapsedTime();
            float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
            Vec3 trailStartOffset = startOffset;
            Vec3 trailEndOffset = endOffset;
            Vec3f trailDirection = new Vec3f((float)(trailEndOffset.f_82479_ - trailStartOffset.f_82479_), (float)(trailEndOffset.f_82480_ - trailStartOffset.f_82480_), (float)(trailEndOffset.f_82481_ - trailStartOffset.f_82481_));
            for (float f = prevElapsedTime; f <= elapsedTime; f += step) {
                for (int i = 0; i <= fxCount; ++i) {
                    float ratio = (float)i / (float)fxCount;
                    Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
                    double randX = (Math.random() - 0.5) * (double)random;
                    double randY = (Math.random() - 0.5) * (double)random;
                    double randZ = (Math.random() - 0.5) * (double)random;
                    Vec3 worldPos = TDEAnimationUtils.getJointWorldRawPos(entityPatch, joint, f + step, pointOffset);
                    if (!((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) continue;
                    PosEffect effect = new PosEffect(fx, ((LivingEntity)entityPatch.getOriginal()).m_9236_(), entityPatch.getOriginal(), new Vec3(worldPos.f_82479_ + randX, worldPos.f_82480_ + randY, worldPos.f_82481_ + randZ), 5, false, true);
                    effect.start();
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InPeriodEvent particleTrail(int startFrame, int endFrame, Joint joint, Vec3 startOffset, Vec3 endOffset, float timeInterpolation, int particleCount, ParticleOptions particleOptions, float random) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            AnimationPlayer player = entityPatch.getAnimator().getPlayerFor(null);
            float prevElapsedTime = player.getPrevElapsedTime();
            float elapsedTime = player.getElapsedTime();
            float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
            Vec3 trailStartOffset = startOffset;
            Vec3 trailEndOffset = endOffset;
            Vec3f trailDirection = new Vec3f((float)(trailEndOffset.f_82479_ - trailStartOffset.f_82479_), (float)(trailEndOffset.f_82480_ - trailStartOffset.f_82480_), (float)(trailEndOffset.f_82481_ - trailStartOffset.f_82481_));
            for (float f = prevElapsedTime; f <= elapsedTime; f += step) {
                for (int i = 0; i <= particleCount; ++i) {
                    float ratio = (float)i / (float)particleCount;
                    Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
                    double randX = (Math.random() - 0.5) * (double)random;
                    double randY = (Math.random() - 0.5) * (double)random;
                    double randZ = (Math.random() - 0.5) * (double)random;
                    Vec3 worldPos = TDEAnimationUtils.getJointWorldRawPos(entityPatch, joint, f + step, pointOffset);
                    if (!((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) continue;
                    ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_(particleOptions, worldPos.f_82479_ + randX, worldPos.f_82480_ + randY, worldPos.f_82481_ + randZ, 0.0, 0.0, 0.0);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InPeriodEvent particleTrail(int startFrame, int endFrame, InteractionHand hand, Vec3 startOffset, Vec3 endOffset, float timeInterpolation, int particleCount, ParticleOptions particleOptions, float random) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        Joint joint = null;
        switch (hand) {
            case MAIN_HAND: {
                joint = ((HumanoidArmature)Armatures.BIPED.get()).toolR;
                break;
            }
            case OFF_HAND: {
                joint = ((HumanoidArmature)Armatures.BIPED.get()).toolL;
            }
        }
        Joint finalJoint = joint;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            AnimationPlayer player = entityPatch.getAnimator().getPlayerFor(null);
            float prevElapsedTime = player.getPrevElapsedTime();
            float elapsedTime = player.getElapsedTime();
            float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
            Vec3 trailStartOffset = startOffset;
            Vec3 trailEndOffset = endOffset;
            Vec3f trailDirection = new Vec3f((float)(trailEndOffset.f_82479_ - trailStartOffset.f_82479_), (float)(trailEndOffset.f_82480_ - trailStartOffset.f_82480_), (float)(trailEndOffset.f_82481_ - trailStartOffset.f_82481_));
            for (float f = prevElapsedTime; f <= elapsedTime; f += step) {
                for (int i = 0; i <= particleCount; ++i) {
                    float ratio = (float)i / (float)particleCount;
                    Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
                    double randX = (Math.random() - 0.5) * (double)random;
                    double randY = (Math.random() - 0.5) * (double)random;
                    double randZ = (Math.random() - 0.5) * (double)random;
                    Vec3 worldPos = TDEAnimationUtils.getJointWorldRawPos(entityPatch, finalJoint, f + step, pointOffset);
                    if (!((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) continue;
                    ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_(particleOptions, worldPos.f_82479_ + randX, worldPos.f_82480_ + randY, worldPos.f_82481_ + randZ, 0.0, 0.0, 0.0);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InPeriodEvent particleTrail(int startFrame, int endFrame, InteractionHand hand, float timeInterpolation, int particleCount, ParticleOptions particleOptions, float random) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        Joint joint = null;
        switch (hand) {
            case MAIN_HAND: {
                joint = ((HumanoidArmature)Armatures.BIPED.get()).toolR;
                break;
            }
            case OFF_HAND: {
                joint = ((HumanoidArmature)Armatures.BIPED.get()).toolL;
            }
        }
        Joint finalJoint = joint;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            AnimationPlayer player = entityPatch.getAnimator().getPlayerFor(null);
            float prevElapsedTime = player.getPrevElapsedTime();
            float elapsedTime = player.getElapsedTime();
            float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
            ItemStack stack = ((LivingEntity)entityPatch.getOriginal()).m_21120_(hand);
            RenderItemBase renderItemBase = ClientEngine.getInstance().renderEngine.getItemRenderer(stack);
            if (renderItemBase == null) {
                return;
            }
            Vec3 trailStartOffset = renderItemBase.trailInfo().start();
            Vec3 trailEndOffset = renderItemBase.trailInfo().end();
            Vec3f trailDirection = new Vec3f((float)(trailEndOffset.f_82479_ - trailStartOffset.f_82479_), (float)(trailEndOffset.f_82480_ - trailStartOffset.f_82480_), (float)(trailEndOffset.f_82481_ - trailStartOffset.f_82481_));
            for (float f = prevElapsedTime; f <= elapsedTime; f += step) {
                for (int i = 0; i <= particleCount; ++i) {
                    float ratio = (float)i / (float)particleCount;
                    Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
                    double randX = (Math.random() - 0.5) * (double)random;
                    double randY = (Math.random() - 0.5) * (double)random;
                    double randZ = (Math.random() - 0.5) * (double)random;
                    Vec3 worldPos = TDEAnimationUtils.getJointWorldRawPos(entityPatch, finalJoint, f + step, pointOffset);
                    if (!((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) continue;
                    ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_(particleOptions, worldPos.f_82479_ + randX, worldPos.f_82480_ + randY, worldPos.f_82481_ + randZ, 0.0, 0.0, 0.0);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InPeriodEvent playerGroundSplitAtk(int startFrame, int endFrame, InteractionHand hand, float radius) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        Joint joint = null;
        switch (hand) {
            case MAIN_HAND: {
                joint = ((HumanoidArmature)Armatures.BIPED.get()).toolR;
                break;
            }
            case OFF_HAND: {
                joint = ((HumanoidArmature)Armatures.BIPED.get()).toolL;
            }
        }
        Joint finalJoint = joint;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            AnimationPlayer player = entityPatch.getAnimator().getPlayerFor(null);
            float prevElapsedTime = player.getPrevElapsedTime();
            float elapsedTime = player.getElapsedTime();
            float step = (elapsedTime - prevElapsedTime) / 30.0f;
            ItemStack stack = ((LivingEntity)entityPatch.getOriginal()).m_21120_(hand);
            RenderItemBase renderItemBase = ClientEngine.getInstance().renderEngine.getItemRenderer(stack);
            if (renderItemBase.trailInfo() == null) {
                return;
            }
            Vec3 trailStartOffset = renderItemBase.trailInfo().start();
            Vec3 trailEndOffset = renderItemBase.trailInfo().end();
            Vec3f trailDirection = new Vec3f((float)(trailEndOffset.f_82479_ - trailStartOffset.f_82479_), (float)(trailEndOffset.f_82480_ - trailStartOffset.f_82480_), (float)(trailEndOffset.f_82481_ - trailStartOffset.f_82481_));
            for (float f = prevElapsedTime; f <= elapsedTime; f += step) {
                int particleCount = 10;
                for (int i = 0; i <= particleCount; ++i) {
                    float ratio = (float)i / (float)particleCount;
                    Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
                    Vec3 worldPos = TDEAnimationUtils.getJointWorldRawPos(entityPatch, finalJoint, f + step, pointOffset);
                    if (((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) continue;
                    LevelUtil.circleSlamFracture((LivingEntity)((LivingEntity)entityPatch.getOriginal()), (Level)((LivingEntity)entityPatch.getOriginal()).m_9236_(), (Vec3)worldPos, (double)radius, (boolean)false);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InPeriodEvent allBackTime(int startFrame, int endFrame) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            if (entityPatch instanceof TDELocalPlayerPatch) {
                TDELocalPlayerPatch localPlayerPatch = (TDELocalPlayerPatch)entityPatch;
                localPlayerPatch.mainBackTick = 5;
                localPlayerPatch.offBackTick = 5;
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InPeriodEvent mainBackTime(int startFrame, int endFrame) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            if (entityPatch instanceof TDELocalPlayerPatch) {
                TDELocalPlayerPatch localPlayerPatch = (TDELocalPlayerPatch)entityPatch;
                localPlayerPatch.mainBackTick = 5;
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InPeriodEvent offBackTime(int startFrame, int endFrame) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            if (entityPatch instanceof TDELocalPlayerPatch) {
                TDELocalPlayerPatch localPlayerPatch = (TDELocalPlayerPatch)entityPatch;
                localPlayerPatch.offBackTick = 5;
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent simpleSound(int startFrame, SoundEvent soundEvent, float volume, float pitch) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> ((LivingEntity)entityPatch.getOriginal()).m_5496_(soundEvent, volume, pitch), (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InTimeEvent simpleCameraShake(int startFrame, int duration, float intensity, float frequency, float radius) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> CameraShake.shake(duration, intensity, frequency, ((LivingEntity)entityPatch.getOriginal()).m_20182_(), radius), (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent<?> costManaEvent(int startFrame, float cost) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            if (entityPatch instanceof TDEServerPlayerPatch) {
                TDEServerPlayerPatch tdeServerPlayerPatch = (TDEServerPlayerPatch)entityPatch;
                TDEAbilityUtils.subAbility(AbilityType.MANA, (Player)tdeServerPlayerPatch.getOriginal(), cost);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent<?> costEnergyEvent(int startFrame, float cost) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            EnemyEntity enemyEntity;
            Entity patt19356$temp = entityPatch.getOriginal();
            if (patt19356$temp instanceof EnemyEntity && cost > (enemyEntity = (EnemyEntity)patt19356$temp).getMaxEnergy() * 0.25f && (double)enemyEntity.getEnergy() < (double)enemyEntity.getMaxEnergy() * 0.25) {
                enemyEntity.costEnergy(cost);
            }
            if (entityPatch instanceof TDEServerPlayerPatch) {
                TDEServerPlayerPatch tdeServerPlayerPatch = (TDEServerPlayerPatch)entityPatch;
                tdeServerPlayerPatch.costEnergy(cost);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent<?> creatPosFxEvent(int startFrame, String Fx, int maxaAge, boolean updatePos) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity entity = entityPatch.getOriginal();
            FX fx = FXHelper.getFX((ResourceLocation)new ResourceLocation(Fx));
            fx.createRuntime(true);
            JointEffect effect = new JointEffect(fx, entity.m_9236_(), entity, null, new Vec3f(0.0f, 0.0f, 0.0f), maxaAge, updatePos, true);
            effect.setRotation(0.0, -entity.m_146908_(), 0.0);
            effect.start();
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InPeriodEvent creatTiemFxEvent(int startFrame, int endFrame, String Fx, Joint joint, Vec3f offset, int maxaAge, boolean updatePos) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            Entity entity = entityPatch.getOriginal();
            FX fx = FXHelper.getFX((ResourceLocation)new ResourceLocation(Fx));
            fx.createRuntime(true);
            new JointEffect(fx, entity.m_9236_(), entity, joint, offset, maxaAge, updatePos, true).start();
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent<?> creatSimpleFxEvent(int startFrame, String Fx, Joint joint, int maxaAge, boolean updatePos) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity entity = entityPatch.getOriginal();
            FX fx = FXHelper.getFX((ResourceLocation)new ResourceLocation(Fx));
            fx.createRuntime(true);
            new JointEffect(fx, entity.m_9236_(), entity, joint, maxaAge, updatePos).start();
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent<?> creatSimpleFxEvent(int startFrame, String Fx, Joint joint, Vec3f offset, int maxaAge, boolean updatePos) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity entity = entityPatch.getOriginal();
            FX fx = FXHelper.getFX((ResourceLocation)new ResourceLocation(Fx));
            fx.createRuntime(true);
            new JointEffect(fx, entity.m_9236_(), entity, joint, offset, maxaAge, updatePos, true).start();
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent<?> creatSimpleSyncRotFxEvent(int startFrame, String Fx, Joint joint, int maxaAge, boolean updatePos) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity entity = entityPatch.getOriginal();
            FX fx = FXHelper.getFX((ResourceLocation)new ResourceLocation(Fx));
            fx.createRuntime(true);
            JointEffect effect = new JointEffect(fx, entity.m_9236_(), entity, joint, new Vec3f(0.0f, 0.0f, 0.0f), maxaAge, updatePos, true, new NumberFunction3((Number)0, (Number)Float.valueOf(-entity.m_146908_()), (Number)0));
            effect.setRotation(0.0, -entity.m_146908_(), 0.0);
            effect.start();
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent simpleGroundSplit(int startFrame, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, int impactLevel) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> TDEAnimationUtils.groundSplit(entityPatch, viewOffset, xOffset, yOffset, zOffset, radius, impactLevel), (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InTimeEvent simpleFXGroundSplit(int startFrame, String Fx, int maxAge, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, int impactLevel) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> TDEAnimationUtils.groundFXSplit(entityPatch, Fx, maxAge, viewOffset, xOffset, yOffset, zOffset, radius, impactLevel), (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InTimeEvent simpleGroundSplit(int startFrame, double viewOffset, double xOffset, double yOffset, double zOffset, float radius) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> TDEAnimationUtils.groundSplit(entityPatch, viewOffset, xOffset, yOffset, zOffset, radius, 3), (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InTimeEvent simpleFXGroundSplit(int startFrame, String Fx, int maxAge, double viewOffset, double xOffset, double yOffset, double zOffset, float radius) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> TDEAnimationUtils.groundFXSplit(entityPatch, Fx, maxAge, viewOffset, xOffset, yOffset, zOffset, radius, 3), (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }
}

