/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.util;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.epicfight.animations.TDEAttackAnimation;
import com.merlin204.tde.network.NetworkHandler;
import com.merlin204.tde.network.server.ShakeCameraPacket;
import com.merlin204.tde.photon.PosEffect;
import com.merlin204.tde.world.AtkDirection;
import com.merlin204.tde.world.TDEDamageSource;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.damagesource.StunType;

public class TDEAnimationUtils {
    public static Vec3 getJointWorldPos(LivingEntityPatch<?> entityPatch, Joint joint) {
        return TDEAnimationUtils.getJointWorldPos(entityPatch, joint, Vec3f.ZERO);
    }

    public static Vec3 getJointWorldRawPos(LivingEntityPatch<?> entityPatch, Joint joint, float time) {
        return TDEAnimationUtils.getJointWorldRawPos(entityPatch, joint, time, Vec3f.ZERO);
    }

    public static Vec3 getJointWorldPos(LivingEntityPatch<?> entityPatch, Joint joint, Vec3f offset) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        OpenMatrix4f transformMatrix = entityPatch.getArmature().getBindedTransformFor(entityPatch.getAnimator().getPose(0.1f), joint);
        transformMatrix.translate(offset);
        OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(entity.f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.mul((OpenMatrix4f)rotation, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
        Vec3 pos = new Vec3((double)(transformMatrix.m30 + (float)entity.m_20185_()), (double)(transformMatrix.m31 + (float)entity.m_20186_()), (double)(transformMatrix.m32 + (float)entity.m_20189_()));
        return pos;
    }

    public static Vec3 getJointWorldPos(LivingEntityPatch<?> entityPatch, Joint joint, Vec3f offset, float partialTicks) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        OpenMatrix4f transformMatrix = entityPatch.getArmature().getBindedTransformFor(entityPatch.getAnimator().getPose(partialTicks), joint);
        transformMatrix.translate(offset);
        OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(entity.f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.mul((OpenMatrix4f)rotation, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
        Vec3 pos = new Vec3((double)(transformMatrix.m30 + (float)entity.m_20185_()), (double)(transformMatrix.m31 + (float)entity.m_20186_()), (double)(transformMatrix.m32 + (float)entity.m_20189_()));
        return pos;
    }

    public static Vec3 getJointWorldRawPos(LivingEntityPatch<?> entityPatch, Joint joint, float time, Vec3f offset) {
        Animator animator = entityPatch.getAnimator();
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Pose pose = ((DynamicAnimation)animator.getPlayerFor(null).getAnimation().get()).getRawPose(time);
        OpenMatrix4f transformMatrix = entityPatch.getArmature().getBindedTransformFor(pose, joint);
        transformMatrix.translate(offset);
        OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(entity.f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.mul((OpenMatrix4f)rotation, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
        Vec3 pos = new Vec3((double)(transformMatrix.m30 + (float)entity.m_20185_()), (double)(transformMatrix.m31 + (float)entity.m_20186_()), (double)(transformMatrix.m32 + (float)entity.m_20189_()));
        return pos;
    }

    public static void shakeCameraForNearbyPlayers(Level level, Vec3 center, double radius, int duration, float intensity, float frequency) {
        List players = level.m_45976_(Player.class, new AABB(center, center).m_82400_(radius));
        for (Player player : players) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.sendToClient(new ShakeCameraPacket(duration, intensity, frequency, center, (float)radius), serverPlayer);
        }
    }

    public static void joinRotationInPose(Pose pose, LivingEntityPatch entityPatch, String joint, float x, float y, float z) {
        OpenMatrix4f toOriginalRotation = new OpenMatrix4f(entityPatch.getArmature().getBindedTransformFor(pose, entityPatch.getArmature().searchJointByName(joint))).removeScale().removeTranslation().invert();
        Vec3f xAxis = OpenMatrix4f.transform3v((OpenMatrix4f)toOriginalRotation, (Vec3f)Vec3f.X_AXIS, (Vec3f)null);
        Vec3f yAxis = OpenMatrix4f.transform3v((OpenMatrix4f)toOriginalRotation, (Vec3f)Vec3f.Y_AXIS, (Vec3f)null);
        Vec3f zAxis = OpenMatrix4f.transform3v((OpenMatrix4f)toOriginalRotation, (Vec3f)Vec3f.Z_AXIS, (Vec3f)null);
        OpenMatrix4f headRotation = OpenMatrix4f.createRotatorDeg((float)y, (Vec3f)yAxis).rotateDeg(x, xAxis).rotateDeg(z, zAxis);
        pose.orElseEmpty(joint).frontResult(JointTransform.fromMatrix((OpenMatrix4f)headRotation), OpenMatrix4f::mul);
    }

    public static TDEAttackAnimation.TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, Joint joint, Collider collider) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new TDEAttackAnimation.TDEPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, 0, AtkDirection.MIDDLE, joint, collider);
    }

    public static TDEAttackAnimation.TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, int phaseImpactLevelMulti, AtkDirection atkDirection, Joint joint, Collider collider) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new TDEAttackAnimation.TDEPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, phaseImpactLevelMulti, atkDirection, joint, collider);
    }

    public static TDEAttackAnimation.TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, AtkDirection atkDirection, Joint joint, Collider collider) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new TDEAttackAnimation.TDEPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, 0, atkDirection, joint, collider);
    }

    public static TDEAttackAnimation.TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, int phaseImpactLevelMulti, Joint joint, Collider collider) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new TDEAttackAnimation.TDEPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, phaseImpactLevelMulti, AtkDirection.MIDDLE, joint, collider);
    }

    public static TDEAttackAnimation.TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, AttackAnimation.JointColliderPair ... colliders) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new TDEAttackAnimation.TDEPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, 0, AtkDirection.MIDDLE, colliders);
    }

    public static TDEAttackAnimation.TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, int phaseImpactLevelMulti, AtkDirection atkDirection, AttackAnimation.JointColliderPair ... colliders) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new TDEAttackAnimation.TDEPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, phaseImpactLevelMulti, atkDirection, colliders);
    }

    public static TDEAttackAnimation.TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, int phaseImpactLevelMulti, AttackAnimation.JointColliderPair ... colliders) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new TDEAttackAnimation.TDEPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, phaseImpactLevelMulti, AtkDirection.MIDDLE, colliders);
    }

    public static TDEAttackAnimation.TDEPhase createSimplePhase(int startFrame, int endFrame, int waitFrame, InteractionHand interactionHand, AtkDirection atkDirection, AttackAnimation.JointColliderPair ... colliders) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        float wait = (float)waitFrame / 60.0f;
        return new TDEAttackAnimation.TDEPhase(0.0f, start, start, end, wait, Float.MAX_VALUE, interactionHand, 0, atkDirection, colliders);
    }

    public static void groundSplit(LivingEntityPatch<?> entityPatch, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, int impactLevel) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        float damage = TDEAnimationUtils.getTotalAttackDamage(entityPatch);
        Vec3 pos = entity.m_20182_();
        float yaw = entityPatch.getYRot();
        double radians = Math.toRadians(yaw);
        double cosYaw = Math.cos(radians);
        double sinYaw = Math.sin(radians);
        double worldX = xOffset * cosYaw + zOffset * sinYaw;
        double worldZ = -xOffset * sinYaw + zOffset * cosYaw;
        Vec3 viewDir = new Vec3(-sinYaw, 0.0, cosYaw).m_82490_(viewOffset);
        Vec3 totalOffset = viewDir.m_82520_(worldX, yOffset, worldZ);
        Vec3 target = pos.m_82520_(totalOffset.f_82479_, -1.0 + totalOffset.f_82480_, totalOffset.f_82481_);
        Vec3 damagetarget = pos.m_82520_(totalOffset.f_82479_, totalOffset.f_82480_, totalOffset.f_82481_);
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (target != null) {
                LevelUtil.circleSlamFracture((LivingEntity)entity, (Level)level2, (Vec3)target, (double)radius, (boolean)false);
                TDEAnimationUtils.dealAreaDamage(level2, damagetarget, entity, damage, radius, impactLevel);
            }
        }
    }

    public static void groundFXSplit(LivingEntityPatch<?> entityPatch, String Fx, int maxAge, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, int impactLevel) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        float damage = TDEAnimationUtils.getTotalAttackDamage(entityPatch);
        Vec3 pos = entity.m_20182_();
        float yaw = entityPatch.getYRot();
        double radians = Math.toRadians(yaw);
        double cosYaw = Math.cos(radians);
        double sinYaw = Math.sin(radians);
        double worldX = xOffset * cosYaw + zOffset * sinYaw;
        double worldZ = -xOffset * sinYaw + zOffset * cosYaw;
        Vec3 viewDir = new Vec3(-sinYaw, 0.0, cosYaw).m_82490_(viewOffset);
        Vec3 totalOffset = viewDir.m_82520_(worldX, yOffset, worldZ);
        Vec3 target = pos.m_82520_(totalOffset.f_82479_, -1.0 + totalOffset.f_82480_, totalOffset.f_82481_);
        Vec3 damagetarget = pos.m_82520_(totalOffset.f_82479_, totalOffset.f_82480_, totalOffset.f_82481_);
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (target != null) {
                FX fx = FXHelper.getFX((ResourceLocation)new ResourceLocation(Fx));
                new PosEffect(fx, entity.m_9236_(), (Entity)entity, damagetarget, maxAge, true).start();
                LevelUtil.circleSlamFracture((LivingEntity)entity, (Level)level2, (Vec3)target, (double)radius, (boolean)false);
                TDEAnimationUtils.dealAreaDamage(level2, damagetarget, entity, damage, radius, impactLevel);
            }
        }
    }

    private static void dealAreaDamage(ServerLevel level, Vec3 center, LivingEntity source, float damage, float radius, int impactLevel) {
        if (radius <= 0.0f) {
            return;
        }
        AABB area = new AABB(center.m_7096_() - (double)radius, center.m_7098_() - (double)radius, center.m_7094_() - (double)radius, center.m_7096_() + (double)radius, center.m_7098_() + (double)radius, center.m_7094_() + (double)radius);
        List entities = level.m_6443_(LivingEntity.class, area, entity -> entity.m_6084_() && entity.m_20238_(center) <= (double)(radius * radius) && entity != source);
        for (LivingEntity entity2 : new ArrayList(entities)) {
            if (entity2.f_19802_ < 0 || source == null) continue;
            LivingEntityPatch entityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)source, LivingEntityPatch.class);
            if (entityPatch != null) {
                entity2.f_19802_ = 0;
                EpicFightDamageSources damageSources = EpicFightDamageSources.of((Level)entity2.m_9236_());
                TDEDamageSource tdeDamageSource = new TDEDamageSource((DamageSource)entityPatch.getDamageSource((AnimationManager.AnimationAccessor)Animations.EMPTY_ANIMATION, InteractionHand.MAIN_HAND));
                tdeDamageSource.setImpactLevel(impactLevel);
                entity2.m_6469_((DamageSource)tdeDamageSource.setInitialPosition(center).setStunType(StunType.NONE).setAnimation((AnimationManager.AnimationAccessor)Animations.EMPTY_ANIMATION).setImpact(damage / 5.0f), damage);
            }
            entity2.f_19802_ = 0;
        }
    }

    public static void dealRectangularDamage(ServerLevel level, LivingEntity source, float damage, float width, float length, float verticalRadius) {
        if (width <= 0.0f || length <= 0.0f || verticalRadius <= 0.0f) {
            return;
        }
        float maxRange = (float)Math.sqrt(width * width + length * length) / 2.0f;
        AABB area = new AABB(source.m_20185_() - (double)maxRange, source.m_20186_() - (double)verticalRadius, source.m_20189_() - (double)maxRange, source.m_20185_() + (double)maxRange, source.m_20186_() + (double)verticalRadius, source.m_20189_() + (double)maxRange);
        float yaw = source.m_146908_();
        float cos = (float)Math.cos(Math.toRadians(yaw));
        float sin = (float)Math.sin(Math.toRadians(yaw));
        List entities = level.m_6443_(LivingEntity.class, area, entity -> entity.m_6084_() && entity != source);
        for (LivingEntity entity2 : entities) {
            boolean inVerticalRange;
            double dx = entity2.m_20185_() - source.m_20185_();
            double dz = entity2.m_20189_() - source.m_20189_();
            double localX = dx * (double)cos + dz * (double)sin;
            double localForward = -dx * (double)sin + dz * (double)cos;
            boolean inXRange = localX >= (double)(-width / 2.0f) && localX <= (double)(width / 2.0f);
            boolean inForwardRange = localForward >= 0.0 && localForward <= (double)length;
            boolean bl = inVerticalRange = entity2.m_20186_() >= source.m_20186_() - (double)verticalRadius && entity2.m_20186_() <= source.m_20186_() + (double)verticalRadius;
            if (!inXRange || !inForwardRange || !inVerticalRange || entity2.f_19802_ < 0) continue;
            LivingEntityPatch entityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)source, LivingEntityPatch.class);
            if (entityPatch != null) {
                entity2.f_19802_ = 0;
                EpicFightDamageSources damageSources = EpicFightDamageSources.of((Level)entity2.m_9236_());
                entity2.m_6469_((DamageSource)damageSources.shockwave(source).setAnimation((AnimationManager.AnimationAccessor)Animations.EMPTY_ANIMATION).setInitialPosition(source.m_20182_()).addRuntimeTag(EpicFightDamageType.FINISHER).addRuntimeTag(DamageTypes.f_268565_), damage);
            }
            entity2.f_19802_ = 0;
        }
    }

    public static float getTotalAttackDamage(LivingEntityPatch<?> entityPatch) {
        LivingEntity owner = (LivingEntity)entityPatch.getOriginal();
        double baseDamage = owner.m_21133_(Attributes.f_22281_);
        return (float)baseDamage;
    }
}

