/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.photon;

import com.lowdragmc.photon.client.fx.EntityEffect;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.IEffect;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction3;
import com.lowdragmc.photon.client.gameobject.emitter.particle.ParticleConfig;
import com.lowdragmc.photon.client.gameobject.emitter.particle.ParticleEmitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class PosEffect
extends EntityEffect {
    public static Map<Entity, List<PosEffect>> CACHE = new HashMap<Entity, List<PosEffect>>();
    public final Entity entity;
    private final boolean updatePos;
    private final Vec3 pos;
    private final NumberFunction3 startRotation;
    private int age;
    private int maxAge = -1;

    public PosEffect(FX fx, Level level, Entity entity, Vec3 pos, int maxAge, boolean canupdatePos, boolean allowMulti, NumberFunction3 startRotation) {
        super(fx, level, entity, EntityEffect.AutoRotate.NONE);
        this.entity = entity;
        this.maxAge = maxAge;
        this.allowMulti = allowMulti;
        this.updatePos = canupdatePos;
        this.pos = pos;
        this.startRotation = startRotation;
    }

    public PosEffect(FX fx, Level level, Entity entity, Vec3 pos, int maxAge, boolean canupdatePos, boolean allowMulti) {
        super(fx, level, entity, EntityEffect.AutoRotate.NONE);
        this.entity = entity;
        this.maxAge = maxAge;
        this.allowMulti = allowMulti;
        this.updatePos = canupdatePos;
        this.pos = pos;
        this.startRotation = null;
    }

    public PosEffect(FX fx, Level level, Entity entity, Vec3 pos, int maxAge, boolean canupdatePos) {
        this(fx, level, entity, pos, maxAge, canupdatePos, true);
    }

    public void updateFXObjectTick(IFXObject fxObject) {
        super.updateFXObjectTick(fxObject);
        if (fxObject instanceof ParticleEmitter) {
            ParticleEmitter particleEmitter = (ParticleEmitter)fxObject;
            if (this.startRotation != null) {
                ParticleConfig particleConfig = particleEmitter.config;
                particleConfig.setStartRotation(this.startRotation);
            }
        }
        ++this.age;
        if (this.maxAge > 0 && this.age >= this.maxAge) {
            this.runtime.destroy(this.forcedDeath);
            this.removeFromCache();
        }
        if (this.runtime != null && fxObject == this.runtime.root && !this.entity.m_6084_()) {
            this.runtime.destroy(this.forcedDeath);
            this.removeFromCache();
        }
    }

    public void setMaxAge(int ticks) {
        this.maxAge = ticks;
    }

    public void destroy() {
        if (this.runtime != null) {
            this.runtime.destroy(this.forcedDeath);
            this.removeFromCache();
        }
    }

    private void removeFromCache() {
        List<PosEffect> effects = CACHE.get(this.entity);
        if (effects != null) {
            effects.remove((Object)this);
            if (effects.isEmpty()) {
                CACHE.remove(this.entity);
            }
        }
    }

    public void updateFXObjectFrame(IFXObject fxObject, float partialTicks) {
    }

    public void start() {
        if (this.entity.m_6084_()) {
            List effects = CACHE.computeIfAbsent(this.entity, p -> new ArrayList());
            if (!this.allowMulti) {
                Iterator iter = effects.iterator();
                while (iter.hasNext()) {
                    PosEffect effect = (PosEffect)((Object)iter.next());
                    boolean removed = false;
                    if (effect.getRuntime() != null && !effect.getRuntime().isAlive()) {
                        iter.remove();
                        removed = true;
                    }
                    if (!effect.fx.equals(this.fx) && !Objects.equals(effect.fx.getFxLocation(), this.fx.getFxLocation()) || removed) continue;
                    return;
                }
            }
            this.runtime = this.fx.createRuntime();
            IFXObject root = this.runtime.getRoot();
            root.updatePos(new Vector3f((float)this.pos.f_82479_, (float)this.pos.f_82480_, (float)this.pos.f_82481_));
            root.updateRotation(this.rotation);
            root.updateScale(this.scale);
            this.runtime.emmit((IEffect)this);
            effects.add(this);
        }
    }
}

