/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.network;

import com.merlin204.tde.network.NetworkContext;
import com.merlin204.tde.network.SyncBossBarPacket;
import com.merlin204.tde.network.client.CPGiveItemPacket;
import com.merlin204.tde.network.client.CallNPCPacket;
import com.merlin204.tde.network.client.ClientAbilitySyncPacket;
import com.merlin204.tde.network.client.IntoFogPacket;
import com.merlin204.tde.network.client.SaveAtCampfirePacket;
import com.merlin204.tde.network.server.AbilitySyncPacket;
import com.merlin204.tde.network.server.ShakeCameraPacket;
import com.merlin204.tde.network.server.SyncCampfireDataPacket;
import com.merlin204.tde.network.server.TDESPacketUIOpen;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("tde", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int nextPacketId = 0;

    public static void registerPackets() {
        NetworkHandler.registerPacket(AbilitySyncPacket.class, AbilitySyncPacket::encode, AbilitySyncPacket::new, AbilitySyncPacket::handle);
        NetworkHandler.registerPacket(ClientAbilitySyncPacket.class, ClientAbilitySyncPacket::encode, ClientAbilitySyncPacket::new, ClientAbilitySyncPacket::handle);
        NetworkHandler.registerPacket(ShakeCameraPacket.class, ShakeCameraPacket::encode, ShakeCameraPacket::decode, ShakeCameraPacket::handle);
        NetworkHandler.registerPacket(SyncBossBarPacket.class, SyncBossBarPacket::encode, SyncBossBarPacket::decode, SyncBossBarPacket::handle);
        NetworkHandler.registerPacket(SaveAtCampfirePacket.class, SaveAtCampfirePacket::encode, SaveAtCampfirePacket::new, SaveAtCampfirePacket::handle);
        NetworkHandler.registerPacket(IntoFogPacket.class, IntoFogPacket::encode, IntoFogPacket::new, IntoFogPacket::handle);
        NetworkHandler.registerPacket(CPGiveItemPacket.class, CPGiveItemPacket::encode, CPGiveItemPacket::new, CPGiveItemPacket::handle);
        NetworkHandler.registerPacket(SyncCampfireDataPacket.class, SyncCampfireDataPacket::encode, SyncCampfireDataPacket::new, SyncCampfireDataPacket::handle);
        NetworkHandler.registerPacket(CallNPCPacket.class, CallNPCPacket::encode, CallNPCPacket::new, CallNPCPacket::handle);
        NetworkHandler.registerPacket(TDESPacketUIOpen.class, TDESPacketUIOpen::encode, TDESPacketUIOpen::new, (packet, ctx) -> packet.execute(new NetworkContext((NetworkEvent.Context)ctx.get())));
    }

    private static <T> void registerPacket(Class<T> packetClass, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> handler) {
        INSTANCE.registerMessage(nextPacketId++, packetClass, encoder, decoder, (msg, ctx) -> {
            handler.accept((Object)msg, (Supplier<NetworkEvent.Context>)ctx);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    public static void sendToServer(Object packet) {
        INSTANCE.sendToServer(packet);
    }

    public static void sendToClient(Object packet, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }
}

