/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.mixin;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yesman.epicfight.api.client.model.SkinnedMesh;

@Mixin(targets={"yesman.epicfight.client.renderer.patched.layer.WearableItemLayer"}, remap=false)
public abstract class WearableItemLayerMixin {
    @Shadow
    @Final
    private static Map<ResourceLocation, SkinnedMesh> ARMOR_MODELS;
    @Unique
    private static final Map<ResourceLocation, ResourceLocation> CUSTOM_TEXTURE_CACHE;

    @Inject(method={"getArmorTexture"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onGetArmorTexture(ItemStack itemstack, LivingEntity entity, SkinnedMesh armorMesh, EquipmentSlot slot, String type, HumanoidModel<?> originalModel, CallbackInfoReturnable<ResourceLocation> cir) {
        if (!(itemstack.m_41720_() instanceof ArmorItem)) {
            return;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)itemstack.m_41720_());
        if (itemId == null) {
            return;
        }
        String path = "textures/armor/" + itemId.m_135815_() + (String)(type != null ? "_" + type : "") + ".png";
        ResourceLocation textureId = new ResourceLocation(itemId.m_135827_(), path);
        ResourceLocation cached = CUSTOM_TEXTURE_CACHE.get(textureId);
        if (cached == null) {
            cached = textureId;
            CUSTOM_TEXTURE_CACHE.put(textureId, cached);
        }
        cir.setReturnValue((Object)cached);
    }

    static {
        CUSTOM_TEXTURE_CACHE = Maps.newHashMap();
    }
}

