/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.mixin;

import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.provider.EntityPatchProvider;

@Mixin(value={EntityPatchProvider.class}, remap=false)
public abstract class EntityPatchProviderMixin {
    @Shadow
    private static Map<EntityType<?>, Function<Entity, Supplier<EntityPatch<?>>>> CAPABILITIES;
    @Shadow
    private static Map<EntityType<?>, Function<Entity, Supplier<EntityPatch<?>>>> CUSTOM_CAPABILITIES;
    @Shadow
    private EntityPatch<?> capability;

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void onStaticInit(CallbackInfo ci) {
        EntityPatchProviderMixin.overridePlayerPatch();
    }

    @Inject(method={"registerEntityPatches"}, at={@At(value="TAIL")})
    private static void onRegisterEntityPatches(CallbackInfo ci) {
        EntityPatchProviderMixin.overridePlayerPatch();
    }

    @Inject(method={"registerEntityPatchesClient"}, at={@At(value="TAIL")})
    private static void onRegisterEntityPatchesClient(CallbackInfo ci) {
        EntityPatchProviderMixin.overridePlayerPatch();
    }

    @Inject(method={"clear"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onClear(CallbackInfo ci) {
        Function<Entity, Supplier<EntityPatch<?>>> playerPatch = CUSTOM_CAPABILITIES.get(EntityType.f_20532_);
        CUSTOM_CAPABILITIES.clear();
        if (playerPatch != null) {
            CUSTOM_CAPABILITIES.put(EntityType.f_20532_, playerPatch);
        }
        ci.cancel();
    }

    private static void overridePlayerPatch() {
        CAPABILITIES.put(EntityType.f_20532_, entity -> {
            if (entity == null) {
                return () -> null;
            }
            if (entity instanceof LocalPlayer) {
                return TDELocalPlayerPatch::new;
            }
            if (entity instanceof Player) {
                return TDEServerPlayerPatch::new;
            }
            return () -> null;
        });
        CUSTOM_CAPABILITIES.put(EntityType.f_20532_, entity -> {
            if (entity == null) {
                return () -> null;
            }
            if (entity instanceof LocalPlayer) {
                return TDELocalPlayerPatch::new;
            }
            if (entity instanceof Player) {
                return TDEServerPlayerPatch::new;
            }
            return () -> null;
        });
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstruct(Entity entity, CallbackInfo ci) {
        if (this.capability == null && entity.m_6095_() == EntityType.f_20532_) {
            if (entity instanceof LocalPlayer) {
                this.capability = new TDELocalPlayerPatch();
            } else if (entity instanceof Player) {
                this.capability = new TDEServerPlayerPatch();
            }
        }
    }
}

