/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.events;

import com.merlin204.tde.capabilitiy.player.TDEPlayerCapabilities;
import com.merlin204.tde.capabilitiy.player.ability.AbilityProvider;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAbilities;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAttribute;
import com.merlin204.tde.capabilitiy.player.campfiredata.CampfireDataProvider;
import com.merlin204.tde.capabilitiy.player.campfiredata.PlayerCampfireData;
import com.merlin204.tde.client.gui.TDEBossBar;
import com.merlin204.tde.client.gui.TDEHealthBar;
import com.merlin204.tde.effect.TDEMobEffect;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.item.armor.TDEArmor;
import com.merlin204.tde.network.NetworkHandler;
import com.merlin204.tde.network.server.SyncCampfireDataPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@Mod.EventBusSubscriber(modid="tde", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeModEvents {
    private static final TDEHealthBar HEALTH_BAR = new TDEHealthBar();

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        event.getEntity().getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES).ifPresent(abilities -> abilities.syncToClient(event.getEntity()));
        GameRules rules = event.getEntity().m_9236_().m_46469_();
        event.getEntity().getCapability(TDEPlayerCapabilities.PLAYER_CAMPFIRE_DATA).ifPresent(data -> ForgeModEvents.syncCampfireData((ServerPlayer)event.getEntity(), data));
        ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46139_)).m_46246_(false, event.getEntity().m_9236_().m_7654_());
    }

    @SubscribeEvent
    public static void onPlayerFall(LivingFallEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (event.getDistance() >= 6.0f) {
                event.setCanceled(true);
                DamageSources damageSources = player.m_9236_().m_269111_();
                player.m_6469_(damageSources.m_268989_(), Float.MAX_VALUE);
                if (player.m_21223_() > 0.0f) {
                    player.m_6074_();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("tde", "abilities"), (ICapabilityProvider)new AbilityProvider());
            event.addCapability(new ResourceLocation("tde", "campfire_data"), (ICapabilityProvider)new CampfireDataProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES).ifPresent(oldAbilities -> event.getEntity().getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES).ifPresent(newAbilities -> {
            ForgeModEvents.copyAbilities(oldAbilities, newAbilities);
            newAbilities.syncToClient((Player)((ServerPlayer)event.getEntity()));
        }));
        event.getOriginal().getCapability(TDEPlayerCapabilities.PLAYER_CAMPFIRE_DATA).ifPresent(oldData -> event.getEntity().getCapability(TDEPlayerCapabilities.PLAYER_CAMPFIRE_DATA).ifPresent(newData -> {
            newData.deserializeNBT(oldData.serializeNBT());
            ForgeModEvents.syncCampfireData((ServerPlayer)event.getEntity(), newData);
        }));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        float totalReduction = 0.0f;
        int armorCount = 0;
        for (ItemStack stack : player.m_6168_()) {
            Item item = stack.m_41720_();
            if (!(item instanceof TDEArmor)) continue;
            TDEArmor armor = (TDEArmor)item;
            totalReduction += armor.getDamageReduction();
            ++armorCount;
        }
        if (totalReduction > 0.0f) {
            totalReduction = Math.min(totalReduction, 0.95f);
            float newAmount = event.getAmount() * (1.0f - totalReduction);
            event.setAmount(newAmount);
        }
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            Minecraft mc = Minecraft.m_91087_();
            HEALTH_BAR.tick();
            HEALTH_BAR.remove();
            TDELocalPlayerPatch localPlayerPatch = (TDELocalPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)mc.f_91074_, TDELocalPlayerPatch.class);
            mc.f_91073_.m_104735_().forEach(entity -> {
                EnemyEntity enemyEntity;
                if (entity instanceof EnemyEntity && HEALTH_BAR.shouldDraw((LivingEntity)(enemyEntity = (EnemyEntity)entity), (LivingEntityPatch<?>)enemyEntity.getEnemyPatch(), localPlayerPatch, mc.m_91296_())) {
                    PoseStack poseStack = event.getPoseStack();
                    MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
                    buffer.m_109911_();
                }
            });
        }
    }

    @SubscribeEvent
    public void onBossRender(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (TDEBossBar.renderBossBar(event.getGuiGraphics(), event.getBossEvent(), event.getX(), event.getY())) {
            event.setCanceled(true);
        }
    }

    private static void copyAbilities(PlayerAbilities oldAbilities, PlayerAbilities newAbilities) {
        for (AbilityType type : AbilityType.values()) {
            PlayerAttribute oldAttr = oldAbilities.get(type);
            PlayerAttribute newAttr = newAbilities.get(type);
            newAttr.set(oldAttr.get());
        }
    }

    public static void syncCampfireData(ServerPlayer player, PlayerCampfireData data) {
        NetworkHandler.sendToClient(new SyncCampfireDataPacket(data.serializeNBT()), player);
    }

    @SubscribeEvent
    public static void onEffectApplied(MobEffectEvent.Added event) {
        MobEffect mobEffect = event.getEffectInstance().m_19544_();
        if (mobEffect instanceof TDEMobEffect) {
            TDEMobEffect tdeMobEffect = (TDEMobEffect)mobEffect;
            tdeMobEffect.onApplied(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffect mobEffect = event.getEffectInstance().m_19544_();
        if (mobEffect instanceof TDEMobEffect) {
            TDEMobEffect tdeMobEffect = (TDEMobEffect)mobEffect;
            tdeMobEffect.onRemoved(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectTick(LivingEvent.LivingTickEvent event) {
        for (MobEffectInstance mobEffectInstance : event.getEntity().m_21220_()) {
            MobEffect mobEffect = mobEffectInstance.m_19544_();
            if (!(mobEffect instanceof TDEMobEffect)) continue;
            TDEMobEffect tdeMobEffect = (TDEMobEffect)mobEffect;
            tdeMobEffect.tick(event.getEntity());
        }
    }
}

