/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.events;

import com.merlin204.tde.block.respawncampfireblock.FireBlockRegister;
import com.merlin204.tde.client.particle.TDEAnimationTrailParticle;
import com.merlin204.tde.client.particle.TDEEntityAfterImageParticle;
import com.merlin204.tde.client.particle.TDEScaleEntityAfterImageParticle;
import com.merlin204.tde.entity.client.renderer.RenderMeshItem;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.item.uesItem.skillbook.SkillBookItems;
import com.merlin204.tde.item.uesItem.skillbook.TDESkillBook;
import com.merlin204.tde.particle.TDEParticles;
import java.util.Map;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import yesman.epicfight.api.client.forgeevent.PatchedRenderersEvent;
import yesman.epicfight.world.capabilities.provider.EntityPatchProvider;

@Mod.EventBusSubscriber(modid="tde", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModEvents {
    private static final ModelResourceLocation COMMON_MODEL = new ModelResourceLocation(new ResourceLocation("tde", "skill_book"), "inventory");

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        EntityPatchProvider.putCustomEntityPatch((EntityType)EntityType.f_20532_, entity -> {
            if (entity instanceof LocalPlayer) {
                return TDELocalPlayerPatch::new;
            }
            return entity instanceof ServerPlayer ? TDEServerPlayerPatch::new : () -> null;
        });
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FireBlockRegister.TEST_CAMPFIRE.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)FireBlockRegister.S1_1.get()), (RenderType)RenderType.m_110463_());
        });
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        event.register((ResourceLocation)COMMON_MODEL);
    }

    @SubscribeEvent
    public static void onModelBaking(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        BakedModel commonBakedModel = (BakedModel)modelRegistry.get(COMMON_MODEL);
        if (commonBakedModel != null) {
            for (RegistryObject<TDESkillBook> bookReg : SkillBookItems.ALL_SKILL_BOOKS) {
                ResourceLocation itemId = bookReg.getId();
                ModelResourceLocation itemModelLoc = new ModelResourceLocation(itemId, "inventory");
                modelRegistry.put(itemModelLoc, commonBakedModel);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onParticleRegistry(RegisterParticleProvidersEvent event) {
        event.registerSpecial((ParticleType)TDEParticles.TDE_TRAIL.get(), (ParticleProvider)new TDEAnimationTrailParticle.Provider());
        event.registerSpecial((ParticleType)TDEParticles.TDE_ENTITY_AFTER_IMAGE.get(), (ParticleProvider)new TDEEntityAfterImageParticle.Provider());
        event.registerSpecial((ParticleType)TDEParticles.TDE_SCALE_ENTITY_AFTER_IMAGE.get(), (ParticleProvider)new TDEScaleEntityAfterImageParticle.Provider());
    }

    @SubscribeEvent
    public static void registerRenderers(PatchedRenderersEvent.RegisterItemRenderer event) {
        event.addItemRenderer(ResourceLocation.fromNamespaceAndPath((String)"tde", (String)"mesh_item"), RenderMeshItem::new);
    }
}

