/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.epicfight.gameassets.skill.soulfire;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.epicfight.gameassets.skill.soulfire.SoulfireSkillAnimations;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillCategories;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.util.TDEAbilityUtils;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class SoulfireSkill
extends Skill {
    public SoulfireSkill(Builder builder) {
        super((SkillBuilder)builder);
    }

    public static Builder createSoulfireBuilder() {
        return new Builder().setCategory(TDESkillCategories.SOULFIRE).setResource(Skill.Resource.NONE);
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getSoulFireAnimation() {
        return SoulfireSkillAnimations.SOULFIRE_1;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getExecuteAnimation() {
        return SoulfireSkillAnimations.SOULFIRE_1_EXCUTE;
    }

    public int getSoulMax() {
        return 4;
    }

    public int getCoolDown(PlayerPatch playerPatch) {
        return (Integer)playerPatch.getSkill((SkillSlot)TDESkillSlots.SOULFIRE).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.SOULFIRE_COOLDOWN.get());
    }

    public void setCoolDown(PlayerPatch playerPatch, int tick) {
        Entity entity = playerPatch.getOriginal();
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            playerPatch.getSkill((SkillSlot)TDESkillSlots.SOULFIRE).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.SOULFIRE_COOLDOWN.get(), (Object)tick, localPlayer);
        } else {
            entity = playerPatch.getOriginal();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                playerPatch.getSkill((SkillSlot)TDESkillSlots.SOULFIRE).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.SOULFIRE_COOLDOWN.get(), (Object)tick, serverPlayer);
            }
        }
    }

    public boolean canExecute(SkillContainer container) {
        PlayerPatch executor = container.getExecutor();
        return ((Player)executor.getOriginal()).m_20096_() || ((Player)executor.getOriginal()).m_7500_() || !container.getExecutor().getEntityState().inaction();
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnServer(container, args);
        if (this.getCoolDown(container.getExecutor()) > 0 || TDEAbilityUtils.getAbility(AbilityType.SOULFIRE, (Player)container.getExecutor().getOriginal()) <= 0.0f) {
            return;
        }
        ServerPlayerPatch executor = container.getServerExecutor();
        executor.playAnimationSynchronized(this.getSoulFireAnimation(), 0.05f);
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (this.getCoolDown(container.getExecutor()) > 0) {
            this.setCoolDown(container.getExecutor(), this.getCoolDown(container.getExecutor()) - 1);
        }
    }

    public static class Builder
    extends SkillBuilder<SoulfireSkill> {
        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }
    }
}

