/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.epicfight.gameassets.skill.sect.basic;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.api.animation.TDELivingMotions;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.gameassets.skill.sect.basic.BasicSectAnimations;
import com.merlin204.tde.epicfight.skill.TDESkillCategories;
import com.merlin204.tde.item.weapon.TDEWeaponType;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.BasicAttack;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.BasicAttackEvent;
import yesman.epicfight.world.entity.eventlistener.ComboCounterHandleEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;

public class BasicSect
extends BasicAttack
implements SkillInfo {
    protected final UUID EVENT_UUID = UUID.randomUUID();

    @Override
    public String getGroup() {
        return "basic";
    }

    public String getId() {
        return "";
    }

    @Override
    public String getMoreText() {
        return Component.m_237115_((String)(String.format("%s.%s.%s", "skill", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_()) + ".more")).getString();
    }

    @Override
    public void setMoreInfo(WidgetGroup widgetGroup) {
        SkillInfo.super.setMoreInfo(widgetGroup);
        ImageWidget defendLevelInfo = new ImageWidget();
        TextTexture defendLevelInfoText = new TextTexture().setType(TextTexture.TextType.LEFT);
        defendLevelInfoText.setWidth(130);
        defendLevelInfoText.updateText(Component.m_237115_((String)"gui.tde.campfire.skill.defend_level").getString() + ":" + String.valueOf(this.getDefendLevel()));
        defendLevelInfo.setBackground(new IGuiTexture[]{defendLevelInfoText});
        defendLevelInfo.setSize(130, 20);
        defendLevelInfo.setSelfPosition(5, 5);
        widgetGroup.addWidget((Widget)defendLevelInfo);
        ImageWidget moreInfo = new ImageWidget();
        TextTexture moreInfoText = new TextTexture().setType(TextTexture.TextType.LEFT);
        moreInfoText.setWidth(130);
        moreInfoText.updateText(this.getMoreText());
        moreInfo.setBackground(new IGuiTexture[]{moreInfoText});
        moreInfo.setSize(130, 100);
        moreInfo.setSelfPosition(5, 25);
        widgetGroup.addWidget((Widget)moreInfo);
    }

    @Override
    public Component getIntroduce() {
        return Component.m_237115_((String)("tde.skill.sect." + this.getGroup()));
    }

    @Override
    public String getIcon() {
        return "tde:textures/skill/sect/b.png";
    }

    public BasicSect(SkillBuilder<? extends BasicSect> builder) {
        super(builder);
    }

    protected List<AnimationManager.AnimationAccessor<? extends StaticAnimation>> getBuiltInAttacks() {
        return List.of(BasicSectAnimations.FIST_1, BasicSectAnimations.FIST_2, BasicSectAnimations.FIST_3);
    }

    protected Map<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> createLivingAnimations() {
        HashMap<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> map = new HashMap<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>();
        map.put((LivingMotion)LivingMotions.IDLE, (AnimationManager.AnimationAccessor<? extends StaticAnimation>)BasicSectAnimations.FIST_IDLE);
        map.put((LivingMotion)LivingMotions.JUMP, this.getHoldAnimation());
        map.put(TDELivingMotions.TDE_WALK, BasicSectAnimations.FIST_WALK);
        map.put(TDELivingMotions.TDE_SNEAK, this.getHoldAnimation());
        map.put(TDELivingMotions.TDE_KNEEL, this.getHoldAnimation());
        return map;
    }

    public int getDefendLevel() {
        return 1;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardBrokenAnimations() {
        return null;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardHitAnimations(int levelDifference) {
        return null;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getPerfectGuardAnimations() {
        return null;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getDashAtkAnimations() {
        return null;
    }

    public SoundEvent getPerfectBlockSound() {
        return (SoundEvent)EpicFightSounds.BLUNT_HIT_HARD.get();
    }

    public SoundEvent getBlockSound() {
        return (SoundEvent)EpicFightSounds.BLUNT_HIT.get();
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardAnimation() {
        return BasicSectAnimations.FIST_BLOCK;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getChargingAnimation() {
        return BasicSectAnimations.FIST_CHARGE;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getChargingAttackAnimation() {
        return BasicSectAnimations.FIST_CHARGE_ATK;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getFullChargingAttackAnimation() {
        return BasicSectAnimations.FIST_CHARGE_ATK_FULL;
    }

    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> getHoldAnimation() {
        return BasicSectAnimations.FIST_HOLD;
    }

    @Override
    public float getMaxWeight() {
        return 10.0f;
    }

    @Override
    public Set<TDEWeaponType> getMainAllowed() {
        return Set.of(TDEWeaponType.EMPTY);
    }

    @Override
    public Set<TDEWeaponType> getOffAllowed() {
        return Set.of(TDEWeaponType.EMPTY);
    }

    public GuardType getGuardType() {
        return GuardType.ALL;
    }

    public Map<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> getLivingAnimations() {
        return this.createLivingAnimations();
    }

    public boolean checkAllowed(Player player) {
        return this.validatePlayer(player);
    }

    public void onInitiate(SkillContainer container) {
        this.updatePlayerState(container);
        this.registerEventListeners(container);
    }

    public void executeOnClient(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnClient(container, args);
    }

    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        ServerPlayerPatch executor = skillContainer.getServerExecutor();
        if (executor instanceof TDEServerPlayerPatch) {
            TDEServerPlayerPatch serverPlayerPatch = (TDEServerPlayerPatch)executor;
            if (TDEAbilityUtils.getAbility(AbilityType.ENERGY, (Player)serverPlayerPatch.getOriginal()) <= 5.0f) {
                return;
            }
            if (!this.checkAllowed((Player)executor.getOriginal())) {
                if (!this.validatePlayerWeapons((Player)executor.getOriginal())) {
                    Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"gui.tde.sect.warn_1"), false);
                } else if (!this.validatePlayerAbilities((Player)executor.getOriginal())) {
                    Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"gui.tde.sect.warn_2"), false);
                }
                return;
            }
        }
        this.handleSkillConsume(executor);
        if (this.shouldCancelExecution(executor)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)executor.getOriginal();
        SkillDataManager dataManager = skillContainer.getDataManager();
        int comboCounter = (Integer)dataManager.getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get());
        AnimationManager.AnimationAccessor<? extends StaticAnimation> selectedAnimation = null;
        List<AnimationManager.AnimationAccessor<? extends StaticAnimation>> attacks = this.getBuiltInAttacks();
        int comboSize = attacks.size();
        boolean isFirstAttack = comboCounter == 0;
        boolean dashAttack = player.m_20142_();
        if (isFirstAttack && dashAttack && this.getDashAtkAnimations() != null) {
            selectedAnimation = this.getDashAtkAnimations();
            comboCounter = 1;
        } else if (comboSize >= 2) {
            if (comboCounter >= comboSize) {
                int loopSize = comboSize - 1;
                int loopIndex = (comboCounter - comboSize) % loopSize;
                selectedAnimation = attacks.get(loopIndex + 1);
            } else {
                selectedAnimation = attacks.get(comboCounter);
            }
            ++comboCounter;
        } else if (comboSize > 0) {
            selectedAnimation = attacks.get(comboCounter % comboSize);
            ++comboCounter;
        }
        this.updateComboCounter(executor, skillContainer, selectedAnimation, comboCounter);
        this.playAnimation(executor, dataManager, selectedAnimation);
    }

    public void onRemoved(SkillContainer container) {
        this.updatePlayerState(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, this.EVENT_UUID);
    }

    public boolean isExecutableState(PlayerPatch<?> executor) {
        EntityState playerState = executor.getEntityState();
        Player player = (Player)executor.getOriginal();
        return !player.m_5833_() && !executor.isInAir() && playerState.canBasicAttack();
    }

    public void updateContainer(SkillContainer container) {
        TDEServerPlayerPatch serverPlayerPatch;
        PlayerPatch playerPatch = container.getExecutor();
        if (playerPatch instanceof TDEServerPlayerPatch && ((serverPlayerPatch = (TDEServerPlayerPatch)playerPatch).isCharging() || serverPlayerPatch.isGuard())) {
            BasicSect.setComboCounterWithEvent(ComboCounterHandleEvent.Causal.TIME_EXPIRED, container.getServerExecutor(), container, null, 0);
        }
        if (!container.getExecutor().isLogicalClient() && container.getExecutor().getTickSinceLastAction() > 16 && (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get()) > 0) {
            BasicSect.setComboCounterWithEvent(ComboCounterHandleEvent.Causal.TIME_EXPIRED, container.getServerExecutor(), container, null, 0);
        }
    }

    private void updatePlayerState(SkillContainer container) {
        PlayerPatch playerPatch = container.getExecutor();
        if (playerPatch instanceof TDEServerPlayerPatch) {
            TDEServerPlayerPatch serverPlayerPatch = (TDEServerPlayerPatch)playerPatch;
            TDEServerPlayerPatch executor = (TDEServerPlayerPatch)container.getExecutor();
            executor.modifyLivingMotionByCurrentItem(false);
        }
    }

    private void registerEventListeners(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, this.EVENT_UUID, event -> {
            if (((StaticAnimation)event.getAnimation().get()).getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.RESET_PLAYER_COMBO_COUNTER).orElse(true).booleanValue()) {
                HashSet<AnimationManager.AnimationAccessor<? extends StaticAnimation>> attackSet = new HashSet<AnimationManager.AnimationAccessor<? extends StaticAnimation>>(this.getBuiltInAttacks());
                AnimationManager.AnimationAccessor<? extends StaticAnimation> dashAtk = this.getDashAtkAnimations();
                if (dashAtk != null) {
                    attackSet.add(dashAtk);
                }
                CapabilityItem capability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
                if (!attackSet.contains(event.getAnimation()) && capability.shouldCancelCombo((LivingEntityPatch)event.getPlayerPatch())) {
                    BasicSect.setComboCounterWithEvent(ComboCounterHandleEvent.Causal.ANOTHER_ACTION_ANIMATION, (ServerPlayerPatch)event.getPlayerPatch(), container, (AnimationManager.AnimationAccessor<? extends StaticAnimation>)event.getAnimation(), 0);
                }
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.ANIMATION_END_EVENT, this.EVENT_UUID, event -> container.getDataManager().setData((SkillDataKey)SkillDataKeys.BASIC_ATTACK_ACTIVATE.get(), (Object)false));
    }

    private void handleSkillConsume(ServerPlayerPatch executor) {
        SkillConsumeEvent event = new SkillConsumeEvent((PlayerPatch)executor, (Skill)this, this.resource);
        executor.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, (PlayerEvent)event);
        if (!event.isCanceled()) {
            event.getResourceType().consumer.consume(executor.getSkill((Skill)this), executor, event.getAmount());
        }
    }

    private boolean shouldCancelExecution(ServerPlayerPatch executor) {
        return executor.getEventListener().triggerEvents(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, (PlayerEvent)new BasicAttackEvent(executor));
    }

    private void updateComboCounter(ServerPlayerPatch executor, SkillContainer container, AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, int newValue) {
        BasicSect.setComboCounterWithEvent(ComboCounterHandleEvent.Causal.ANOTHER_ACTION_ANIMATION, executor, container, animation, newValue);
    }

    private void playAnimation(ServerPlayerPatch executor, SkillDataManager dataManager, AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
        if (animation != null) {
            executor.playAnimationSynchronized(animation, 0.0f);
            dataManager.setData((SkillDataKey)SkillDataKeys.BASIC_ATTACK_ACTIVATE.get(), (Object)true);
        }
        executor.updateEntityState();
    }

    public static void setComboCounterWithEvent(ComboCounterHandleEvent.Causal reason, ServerPlayerPatch playerpatch, SkillContainer container, AnimationManager.AnimationAccessor<? extends StaticAnimation> causalAnimation, int value) {
        int prevValue = (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get());
        ComboCounterHandleEvent comboResetEvent = new ComboCounterHandleEvent(reason, playerpatch, causalAnimation, prevValue, value);
        container.getExecutor().getEventListener().triggerEvents(PlayerEventListener.EventType.COMBO_COUNTER_HANDLE_EVENT, (PlayerEvent)comboResetEvent);
        container.getDataManager().setData((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get(), (Object)comboResetEvent.getNextValue());
    }

    public static SkillBuilder<BasicSect> createBuiltInBasicAttackBuilder() {
        return new SkillBuilder().setCategory((SkillCategory)TDESkillCategories.SECT).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.NONE);
    }

    public static enum GuardType {
        MAIN,
        OFF,
        ALL;

    }
}

