/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.epicfight.gameassets.skill.guard;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.CameraShake;
import com.merlin204.tde.client.keymapping.TDEKeyMappings;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.gameassets.skill.sect.basic.BasicSect;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillCategories;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.photon.PosEffect;
import com.merlin204.tde.util.TDEAbilityUtils;
import com.merlin204.tde.world.TDEDamageSource;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BasicGuard
extends Skill
implements SkillInfo {
    protected static final UUID EVENT_UUID = UUID.fromString("b422f7a0-f378-11eb-9a03-0242ac130103");

    private int getPerfectTick() {
        return 5;
    }

    @Override
    public String getMoreText() {
        return Component.m_237115_((String)(String.format("%s.%s.%s", "skill", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_()) + ".more")).getString();
    }

    @Override
    public void setMoreInfo(WidgetGroup widgetGroup) {
        SkillInfo.super.setMoreInfo(widgetGroup);
        ImageWidget moreInfo = new ImageWidget();
        TextTexture moreInfoText = new TextTexture().setType(TextTexture.TextType.LEFT);
        moreInfoText.setWidth(130);
        moreInfoText.updateText(this.getMoreText());
        moreInfo.setBackground(new IGuiTexture[]{moreInfoText});
        moreInfo.setSize(130, 100);
        moreInfo.setSelfPosition(5, 5);
        widgetGroup.addWidget((Widget)moreInfo);
    }

    @Override
    public String getIcon() {
        return "tde:textures/skill/guard/basic.png";
    }

    public BasicGuard(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    public static Builder createBasicGuardBuilder() {
        return new Builder().setCategory(TDESkillCategories.TDEGUARD).setResource(Skill.Resource.NONE);
    }

    public void updateContainer(SkillContainer container) {
        LocalPlayer player;
        super.updateContainer(container);
        PlayerPatch playerPatch = container.getExecutor();
        if (playerPatch instanceof TDEServerPlayerPatch) {
            TDEServerPlayerPatch serverPlayerPatch = (TDEServerPlayerPatch)playerPatch;
            ServerPlayer player2 = (ServerPlayer)serverPlayerPatch.getOriginal();
            int perfectGuardTime = (Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.PERFECT_GUARD_TIME.get());
            if (perfectGuardTime > 0) {
                container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.PERFECT_GUARD_TIME.get(), (Object)(perfectGuardTime - 1), player2);
            }
        }
        if (container.getExecutor().isLogicalClient() && TDEAbilityUtils.getAbility(AbilityType.ENERGY, (Player)(player = (LocalPlayer)container.getExecutor().getOriginal())) <= 0.0f) {
            container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_GUARD.get(), (Object)false, player);
            return;
        }
        if (!container.getExecutor().getEntityState().canUseSkill()) {
            return;
        }
        SkillContainer basicAttack = container.getExecutor().getSkill((SkillSlot)TDESkillSlots.SECT);
        Skill perfectGuardTime = basicAttack.getSkill();
        if (perfectGuardTime instanceof BasicSect) {
            BasicSect basicSect = (BasicSect)perfectGuardTime;
            if (!basicSect.checkAllowed((Player)container.getExecutor().getOriginal())) {
                return;
            }
            boolean isKeyDown = TDEKeyMappings.GUARD.m_90857_();
            boolean wasGuard = (Boolean)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_GUARD.get());
            if (!wasGuard) {
                if (container.getExecutor().isLogicalClient()) {
                    container.getExecutor().getAnimator().stopPlaying(basicSect.getGuardAnimation());
                } else {
                    container.getExecutor().stopPlaying(basicSect.getGuardAnimation());
                }
            }
            if (container.getExecutor().isLogicalClient()) {
                LocalPlayer player3 = (LocalPlayer)container.getExecutor().getOriginal();
                if (TDEAbilityUtils.getAbility(AbilityType.ENERGY, (Player)player3) <= 0.0f) {
                    container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_GUARD.get(), (Object)false, player3);
                    return;
                }
                int guardTime = (Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.GUARD_TIME.get());
                if (isKeyDown) {
                    Minecraft mc = Minecraft.m_91087_();
                    ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92091_, (boolean)false);
                    ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92085_, (boolean)false);
                    ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92087_, (boolean)false);
                    ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92086_, (boolean)false);
                    ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92088_, (boolean)false);
                    ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92089_, (boolean)false);
                    if (!wasGuard) {
                        player3.m_20334_(0.0, 0.0, 0.0);
                        container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_GUARD.get(), (Object)true, player3);
                        container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.GUARD_TIME.get(), (Object)0, player3);
                    } else {
                        player3.m_20334_(0.0, 0.0, 0.0);
                        container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.GUARD_TIME.get(), (Object)(guardTime + 1), player3);
                        container.getExecutor().playAnimationSynchronized(basicSect.getGuardAnimation(), 0.0f);
                    }
                } else if (wasGuard) {
                    container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_GUARD.get(), (Object)false, player3);
                    container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.GUARD_TIME.get(), (Object)0, player3);
                }
            }
        }
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_GUARD.get())).booleanValue()) {
                LocalPlayer clientPlayer = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                clientPlayer.m_6858_(false);
                clientPlayer.m_20334_(0.0, 0.0, 0.0);
                Minecraft mc = Minecraft.m_91087_();
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92091_, (boolean)false);
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92085_, (boolean)false);
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92087_, (boolean)false);
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92086_, (boolean)false);
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92088_, (boolean)false);
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92089_, (boolean)false);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_GUARD.get())).booleanValue()) {
                DamageSource damageSource = (DamageSource)event.getDamageSource();
                SkillContainer basicAttack = container.getExecutor().getSkill((SkillSlot)TDESkillSlots.SECT);
                Skill patt9291$temp = basicAttack.getSkill();
                if (patt9291$temp instanceof BasicSect) {
                    BasicSect basicSect = (BasicSect)patt9291$temp;
                    Object patt9374$temp = event.getDamageSource();
                    if (patt9374$temp instanceof EpicFightDamageSource) {
                        EpicFightDamageSource epicfightDamageSource = (EpicFightDamageSource)patt9374$temp;
                        if (epicfightDamageSource instanceof TDEDamageSource) {
                            TDEDamageSource tdeDamageSource = (TDEDamageSource)epicfightDamageSource;
                            boolean perfect = (Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.GUARD_TIME.get()) <= this.getPerfectTick();
                            PlayerPatch patt9724$temp = container.getExecutor();
                            if (!(patt9724$temp instanceof TDEServerPlayerPatch)) {
                                return;
                            }
                            TDEServerPlayerPatch tdeServerPlayerPatch = (TDEServerPlayerPatch)patt9724$temp;
                            int defendLevel = tdeServerPlayerPatch.getDefendLevel();
                            if (tdeDamageSource.getImpactLevel() > defendLevel && !perfect) {
                                CameraShake.shake(40, tdeDamageSource.getImpactLevel() * 5, 0.6f, ((Player)container.getExecutor().getOriginal()).m_20182_(), 3.0f);
                                tdeServerPlayerPatch.hurtEnergyDamage(event.getAmount() * 1.5f);
                            } else {
                                CameraShake.shake(30, tdeDamageSource.getImpactLevel() * 3, 0.6f, ((Player)container.getExecutor().getOriginal()).m_20182_(), 3.0f);
                                AnimationManager.AnimationAccessor<? extends StaticAnimation> hitAnimation = basicSect.getGuardHitAnimations(defendLevel - tdeDamageSource.getImpactLevel());
                                if (perfect) {
                                    hitAnimation = basicSect.getPerfectGuardAnimations();
                                }
                                if (hitAnimation != null) {
                                    container.getExecutor().playAnimationSynchronized(hitAnimation, 0.0f);
                                }
                            }
                        } else {
                            CameraShake.shake(30, 10.0f, 0.6f, ((Player)container.getExecutor().getOriginal()).m_20182_(), 3.0f);
                        }
                        if (epicfightDamageSource.m_269533_(EpicFightDamageType.GUARD_PUNCTURE)) {
                            return;
                        }
                    }
                    this.guard(container, (HurtEvent.Pre)event, false, basicSect.getPerfectBlockSound(), basicSect.getBlockSound());
                }
            }
        }, 0);
    }

    public void guard(SkillContainer container, HurtEvent.Pre event, boolean advanced, SoundEvent perfact, SoundEvent normal) {
        boolean perfect;
        DamageSource damageSource = (DamageSource)event.getDamageSource();
        SkillContainer basicAttack = container.getExecutor().getSkill((SkillSlot)TDESkillSlots.SECT);
        Player player = (Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
        boolean bl = perfect = (Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.GUARD_TIME.get()) <= this.getPerfectTick();
        if (perfect) {
            PlayerPatch playerPatch = event.getPlayerPatch();
            if (playerPatch instanceof TDEServerPlayerPatch) {
                TDEServerPlayerPatch serverPlayerPatch = (TDEServerPlayerPatch)playerPatch;
                serverPlayerPatch.stopEnergyRecoveryTime = 0;
            }
            if (this.isBlockableSource(damageSource, advanced)) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound(perfact, 2.0f, 2.1f);
                ServerPlayer serveerPlayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.PERFECT_GUARD_TIME.get(), (Object)10, serveerPlayer);
                this.spark((LivingEntityPatch<?>)event.getPlayerPatch(), "photon:spark_perfect", 5);
                this.dealEvent(event.getPlayerPatch(), event);
            }
        } else if (this.isBlockableSource(damageSource, advanced)) {
            this.dealEvent(event.getPlayerPatch(), event);
            this.spark((LivingEntityPatch<?>)event.getPlayerPatch(), "photon:spark", 5);
            PlayerPatch playerPatch = event.getPlayerPatch();
            if (playerPatch instanceof TDEServerPlayerPatch) {
                TDEServerPlayerPatch serverPlayerPatch = (TDEServerPlayerPatch)playerPatch;
                serverPlayerPatch.stopEnergyRecoveryTime = 90;
                serverPlayerPatch.hurtEnergyDamage(event.getAmount() * 2.0f);
                if (TDEAbilityUtils.getAbility(AbilityType.ENERGY, (Player)serverPlayerPatch.getOriginal()) <= 0.0f) {
                    BasicSect basicSect;
                    container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_GUARD.get(), (Object)false, (ServerPlayer)serverPlayerPatch.getOriginal());
                    container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.GUARD_TIME.get(), (Object)0, (ServerPlayer)serverPlayerPatch.getOriginal());
                    Skill skill = basicAttack.getSkill();
                    if (skill instanceof BasicSect && (basicSect = (BasicSect)skill).getGuardBrokenAnimations() != null) {
                        container.getExecutor().playAnimationSynchronized(basicSect.getGuardBrokenAnimations(), 0.0f);
                    }
                } else {
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound(normal, -0.05f, 0.1f);
                }
            } else {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound(normal, -0.05f, 0.1f);
            }
        }
    }

    public void dealEvent(PlayerPatch<?> playerpatch, HurtEvent.Pre event) {
        event.setCanceled(true);
        event.setResult(AttackResult.ResultType.BLOCKED);
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)((DamageSource)event.getDamageSource()).m_7639_(), LivingEntityPatch.class).ifPresent(attackerpatch -> attackerpatch.setLastAttackEntity(playerpatch.getOriginal()));
        EpicFightCapabilities.getParameterizedEntityPatch((Entity)((DamageSource)event.getDamageSource()).m_7640_(), LivingEntity.class, LivingEntityPatch.class).ifPresent(entitypatch -> entitypatch.onAttackBlocked((DamageSource)event.getDamageSource(), (LivingEntityPatch)playerpatch));
    }

    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return true;
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, 0);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
    }

    private void spark(LivingEntityPatch<?> entityPatch, String Fx, int maxAge) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Vec3 pos = entity.m_146892_();
        float yaw = entityPatch.getYRot();
        double radians = Math.toRadians(yaw);
        double cosYaw = Math.cos(radians);
        double sinYaw = Math.sin(radians);
        Vec3 viewDir = new Vec3(-sinYaw, 0.0, cosYaw).m_82490_(1.0);
        Vec3 target = pos.m_82520_(viewDir.f_82479_, viewDir.f_82480_ - (double)0.7f, viewDir.f_82481_);
        FX fx = FXHelper.getFX((ResourceLocation)new ResourceLocation(Fx));
        fx.createRuntime(true);
        new PosEffect(fx, entity.m_9236_(), (Entity)entity, target, maxAge, false).start();
    }

    public static class Builder
    extends SkillBuilder<BasicGuard> {
        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }
    }
}

