/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.epicfight.gameassets.skill.dodge;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.gameassets.skill.dodge.DodgeAnimations;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BasicDodge
extends Skill
implements SkillInfo {
    protected final AnimationManager.AnimationAccessor<? extends StaticAnimation>[] animations;
    private static final UUID EVENT_UUID = UUID.fromString("23bd8c76-fe77-11ed-be56-0242ac164514");

    @Override
    public void setMoreInfo(WidgetGroup widgetGroup) {
        SkillInfo.super.setMoreInfo(widgetGroup);
        ImageWidget moreInfo = new ImageWidget();
        TextTexture moreInfoText = new TextTexture().setType(TextTexture.TextType.LEFT);
        moreInfoText.setWidth(130);
        moreInfoText.updateText(this.getMoreText());
        moreInfo.setBackground(new IGuiTexture[]{moreInfoText});
        moreInfo.setSize(130, 100);
        moreInfo.setSelfPosition(5, 5);
        widgetGroup.addWidget((Widget)moreInfo);
    }

    @Override
    public String getMoreText() {
        return Component.m_237115_((String)(String.format("%s.%s.%s", "skill", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_()) + ".more")).getString();
    }

    @Override
    public String getIcon() {
        return "tde:textures/skill/dodge/basic.png";
    }

    private int getPerfectTick() {
        return 4;
    }

    private float getCost() {
        return 20.0f;
    }

    public BasicDodge(Builder builder) {
        super((SkillBuilder)builder);
        this.animations = builder.animations;
    }

    public static Builder createDodgeBuilder() {
        return (Builder)new Builder().setAnimations(DodgeAnimations.BASICDODGE_F, DodgeAnimations.BASICDODGE_B, DodgeAnimations.BASICDODGE_L, DodgeAnimations.BASICDODGE_R).setCategory((SkillCategory)SkillCategories.DODGE).setActivateType(Skill.ActivateType.ONE_SHOT);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID, event -> {
            ServerPlayer serverPlayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            if ((Integer)((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.DODGE).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.DODGE_TIME.get()) <= this.getPerfectTick()) {
                ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.DODGE).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.PERFECT_DODGE_TIME.get(), (Object)20, serverPlayer);
            }
        });
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        PlayerPatch playerPatch = container.getExecutor();
        if (playerPatch instanceof TDEServerPlayerPatch) {
            TDEServerPlayerPatch serverPlayerPatch = (TDEServerPlayerPatch)playerPatch;
            ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
            int dodgeTime = (Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.DODGE_TIME.get());
            int perfectDodgeTime = (Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.PERFECT_DODGE_TIME.get());
            if (dodgeTime > 0) {
                container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.DODGE_TIME.get(), (Object)(dodgeTime - 1), player);
                if (dodgeTime - 1 <= 0 && perfectDodgeTime <= 0) {
                    serverPlayerPatch.costEnergy(this.getCost());
                    serverPlayerPatch.stopEnergyRecoveryTime = 15;
                } else if (dodgeTime - 1 <= 0 && perfectDodgeTime > 0) {
                    serverPlayerPatch.stopEnergyRecoveryTime = 0;
                }
            }
            if (perfectDodgeTime > 0) {
                ServerPlayer serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
                serverPlayer.m_284548_().m_8767_((ParticleOptions)((SimpleParticleType)EpicFightParticles.ENTITY_AFTER_IMAGE.get()), serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), 1, (double)serverPlayer.m_19879_(), 1.0, 1.0, (double)serverPlayer.m_19879_());
                container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.PERFECT_DODGE_TIME.get(), (Object)(perfectDodgeTime - 1), player);
            }
        }
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(SkillContainer container, FriendlyByteBuf args) {
        LocalPlayerPatch executor = container.getClientExecutor();
        Input input = ((LocalPlayer)executor.getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)executor.getOriginal()))), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        float yRot = Minecraft.m_91087_().f_91063_.m_109153_().m_90590_();
        float degree = (float)(-(90 * horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon)) + yRot;
        int animation = vertic == 0 ? (horizon == 0 ? 0 : (horizon >= 0 ? 2 : 3)) : (vertic >= 0 ? 0 : 1);
        CPExecuteSkill packet = new CPExecuteSkill(container.getSlotId());
        packet.getBuffer().writeInt(animation);
        packet.getBuffer().writeFloat(vertic == 0 && horizon != 0 ? yRot : degree);
        return packet;
    }

    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        super.executeOnServer(skillContainer, args);
        ServerPlayerPatch executor = skillContainer.getServerExecutor();
        int i = args.readInt();
        float yRot = args.readFloat();
        ServerPlayer player = (ServerPlayer)skillContainer.getServerExecutor().getOriginal();
        if (TDEAbilityUtils.getAbility(AbilityType.ENERGY, (Player)player) < this.getCost()) {
            return;
        }
        executor.playAnimationSynchronized(this.animations[i], 0.0f);
        skillContainer.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.DODGE_TIME.get(), (Object)this.getPerfectTick(), player);
        executor.setModelYRot(yRot, true);
        skillContainer.getExecutor().playSound((SoundEvent)EpicFightSounds.ENTITY_MOVE.get(), 1.0f, 1.0f);
    }

    public static class Builder
    extends SkillBuilder<BasicDodge> {
        protected AnimationManager.AnimationAccessor<? extends StaticAnimation>[] animations;

        @SafeVarargs
        public final Builder setAnimations(AnimationManager.AnimationAccessor<? extends StaticAnimation> ... animations) {
            this.animations = animations;
            return this;
        }
    }
}

