/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.epicfight.gameassets.skill.cycle;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillCategories;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public abstract class CycleSkill
extends Skill
implements SkillInfo {
    public CycleSkill(Builder builder) {
        super((SkillBuilder)builder);
    }

    @Override
    public String getMoreText() {
        return Component.m_237115_((String)(String.format("%s.%s.%s", "skill", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_()) + ".more")).getString();
    }

    @Override
    public void setMoreInfo(WidgetGroup widgetGroup) {
        SkillInfo.super.setMoreInfo(widgetGroup);
        ImageWidget moreInfo = new ImageWidget();
        TextTexture moreInfoText = new TextTexture().setType(TextTexture.TextType.LEFT);
        moreInfoText.setWidth(130);
        moreInfoText.updateText(this.getMoreText());
        moreInfo.setBackground(new IGuiTexture[]{moreInfoText});
        moreInfo.setSize(130, 100);
        moreInfo.setSelfPosition(5, 5);
        widgetGroup.addWidget((Widget)moreInfo);
    }

    public static Builder createCycleBuilder() {
        return new Builder().setCategory(TDESkillCategories.CYCLE).setResource(Skill.Resource.NONE);
    }

    public void uesServerEvent(ServerPlayerPatch playerPatch) {
    }

    public void cycleInEvent(PlayerPatch<?> playerPatch) {
        if (!this.validatePlayer((Player)playerPatch.getOriginal())) {
            this.setCoolDown(playerPatch, 100);
        }
    }

    public void cycleOutEvent(PlayerPatch<?> playerPatch) {
    }

    public void tickEvent(PlayerPatch<?> playerPatch) {
    }

    public void uesStartEvent(PlayerPatch<?> playerPatch) {
    }

    public void uesEndEvent(PlayerPatch<?> playerPatch) {
    }

    public void uesTickEvent(PlayerPatch<?> playerPatch) {
    }

    @Override
    public boolean validatePlayer(Player player) {
        if (!this.validatePlayerWeapons(player)) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"gui.tde.cycle.warn_1"), false);
            return false;
        }
        if (!this.validatePlayerAbilities(player)) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"gui.tde.cycle.warn_2"), false);
            return false;
        }
        return SkillInfo.super.validatePlayer(player);
    }

    public int getMaxCoolDown() {
        return 100;
    }

    public boolean canExecute(SkillContainer container) {
        PlayerPatch executor = container.getExecutor();
        return ((Player)executor.getOriginal()).m_20096_() || ((Player)executor.getOriginal()).m_7500_() || !container.getExecutor().getEntityState().inaction() || container.getExecutor().getEntityState().canUseSkill();
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnServer(container, args);
        ServerPlayerPatch executor = container.getServerExecutor();
        if (this.getCoolDown(container.getExecutor()) > 0 || this.getSlotNumber((PlayerPatch<?>)executor) != (int)TDEAbilityUtils.getAbility(AbilityType.CYCLE, (Player)executor.getOriginal())) {
            return;
        }
        this.uesServerEvent(executor);
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        PlayerPatch playerPatch = container.getExecutor();
        if (this.getCoolDown(container.getExecutor()) > 0) {
            this.setCoolDown(container.getExecutor(), this.getCoolDown(container.getExecutor()) - 1);
        }
        if ((float)this.getSlotNumber(playerPatch) == TDEAbilityUtils.getAbility(AbilityType.CYCLE, (Player)playerPatch.getOriginal()) && !this.cycleNow(playerPatch)) {
            this.setCycleNow(playerPatch, true);
            this.cycleInEvent(playerPatch);
        } else if ((float)this.getSlotNumber(playerPatch) != TDEAbilityUtils.getAbility(AbilityType.CYCLE, (Player)playerPatch.getOriginal()) && this.cycleNow(playerPatch)) {
            this.setCycleNow(playerPatch, false);
            this.cycleOutEvent(playerPatch);
        }
        if (this.getCoolDown(playerPatch) == 0 && this.cycleNow(playerPatch) && !SkillInfo.super.validatePlayer((Player)playerPatch.getOriginal())) {
            this.toNext(playerPatch);
        }
        if (this.cycleNow(playerPatch) && this.getCoolDown(playerPatch) == 0) {
            this.tickEvent(playerPatch);
            if (this.getUesTick(playerPatch) > 0) {
                if (!this.uesNow(playerPatch)) {
                    this.uesStartEvent(playerPatch);
                    this.setUesNow(playerPatch, true);
                }
                this.uesTickEvent(playerPatch);
                this.setUesTick(playerPatch, this.getUesTick(playerPatch) - 1);
            } else if (this.getUesTick(playerPatch) == 0 && this.uesNow(playerPatch)) {
                this.uesEndEvent(playerPatch);
                this.setUesNow(playerPatch, false);
            }
        }
    }

    public void toNext(PlayerPatch<?> playerPatch) {
        TDEAbilityUtils.setAbility(AbilityType.CYCLE, (Player)playerPatch.getOriginal(), this.getNextSlot(playerPatch).getCycle());
    }

    public void toPrevious(PlayerPatch<?> playerPatch) {
        TDEAbilityUtils.setAbility(AbilityType.CYCLE, (Player)playerPatch.getOriginal(), this.getPreviousSlot(playerPatch).getCycle());
    }

    public TDESkillSlots getNextSlot(PlayerPatch<?> playerPatch) {
        return switch (this.getSlot(playerPatch).getCycle()) {
            case 1 -> TDESkillSlots.CYCLE_2;
            case 2 -> TDESkillSlots.CYCLE_3;
            case 3 -> TDESkillSlots.CYCLE_4;
            case 4 -> TDESkillSlots.CYCLE_5;
            case 5 -> TDESkillSlots.CYCLE_1;
            default -> null;
        };
    }

    public TDESkillSlots getPreviousSlot(PlayerPatch<?> playerPatch) {
        return switch (this.getSlot(playerPatch).getCycle()) {
            case 1 -> TDESkillSlots.CYCLE_5;
            case 2 -> TDESkillSlots.CYCLE_1;
            case 3 -> TDESkillSlots.CYCLE_2;
            case 4 -> TDESkillSlots.CYCLE_3;
            case 5 -> TDESkillSlots.CYCLE_4;
            default -> null;
        };
    }

    public boolean uesNow(PlayerPatch<?> playerPatch) {
        return (Boolean)playerPatch.getSkill((SkillSlot)this.getSlot(playerPatch)).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.UES_NOW.get());
    }

    public void setUesNow(PlayerPatch<?> playerPatch, boolean b) {
        Entity entity = playerPatch.getOriginal();
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            playerPatch.getSkill((SkillSlot)this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.UES_NOW.get(), (Object)b, localPlayer);
        } else {
            entity = playerPatch.getOriginal();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                playerPatch.getSkill((SkillSlot)this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.UES_NOW.get(), (Object)b, serverPlayer);
            }
        }
    }

    public boolean cycleNow(PlayerPatch<?> playerPatch) {
        return (Boolean)playerPatch.getSkill((SkillSlot)this.getSlot(playerPatch)).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.CYCLE_NOW.get());
    }

    public void setCycleNow(PlayerPatch<?> playerPatch, boolean b) {
        Entity entity = playerPatch.getOriginal();
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            playerPatch.getSkill((SkillSlot)this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CYCLE_NOW.get(), (Object)b, localPlayer);
        } else {
            entity = playerPatch.getOriginal();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                playerPatch.getSkill((SkillSlot)this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CYCLE_NOW.get(), (Object)b, serverPlayer);
            }
        }
    }

    public int getUesTick(PlayerPatch<?> playerPatch) {
        return (Integer)playerPatch.getSkill((SkillSlot)this.getSlot(playerPatch)).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.UES_TICK.get());
    }

    public void setUesTick(PlayerPatch<?> playerPatch, int tick) {
        Entity entity = playerPatch.getOriginal();
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            playerPatch.getSkill((SkillSlot)this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.UES_TICK.get(), (Object)tick, localPlayer);
        } else {
            entity = playerPatch.getOriginal();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                playerPatch.getSkill((SkillSlot)this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.UES_TICK.get(), (Object)tick, serverPlayer);
            }
        }
    }

    public int getCoolDown(PlayerPatch<?> playerPatch) {
        return (Integer)playerPatch.getSkill((SkillSlot)this.getSlot(playerPatch)).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.CYCLE_COOLDOWN.get());
    }

    public void setCoolDown(PlayerPatch<?> playerPatch, int tick) {
        Entity entity = playerPatch.getOriginal();
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            playerPatch.getSkill((SkillSlot)this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CYCLE_COOLDOWN.get(), (Object)tick, localPlayer);
        } else {
            entity = playerPatch.getOriginal();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                playerPatch.getSkill((SkillSlot)this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CYCLE_COOLDOWN.get(), (Object)tick, serverPlayer);
            }
        }
    }

    public int getSlotNumber(PlayerPatch<?> playerPatch) {
        return this.getSlot(playerPatch).getCycle();
    }

    public TDESkillSlots getSlot(PlayerPatch<?> playerPatch) {
        for (TDESkillSlots slot : List.of(TDESkillSlots.CYCLE_1, TDESkillSlots.CYCLE_2, TDESkillSlots.CYCLE_3, TDESkillSlots.CYCLE_4, TDESkillSlots.CYCLE_5)) {
            Skill skill = playerPatch.getSkill((SkillSlot)slot).getSkill();
            if (skill != this) continue;
            return slot;
        }
        return null;
    }

    public static class Builder
    extends SkillBuilder<CycleSkill> {
        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }
    }
}

