/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.epicfight.gameassets.skill.charge;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.keymapping.TDEKeyMappings;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.gameassets.skill.sect.basic.BasicSect;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillCategories;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BasicChargedAttack
extends Skill
implements SkillInfo {
    protected static final UUID EVENT_UUID = UUID.fromString("b421f7a0-f568-11eb-9a03-0242ac130103");
    public int MAX_CHARGING_TICKS = 60;
    public int MIN_CHARGING_TICKS = 10;
    private float COST = 0.5f;

    @Override
    public String getIcon() {
        return "tde:textures/skill/charge/basic.png";
    }

    @Override
    public String getMoreText() {
        return Component.m_237115_((String)(String.format("%s.%s.%s", "skill", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_()) + ".more")).getString();
    }

    public boolean canExecute(SkillContainer container) {
        PlayerPatch executor = container.getExecutor();
        return ((Player)executor.getOriginal()).m_20096_() || ((Player)executor.getOriginal()).m_7500_();
    }

    @Override
    public void setMoreInfo(WidgetGroup widgetGroup) {
        SkillInfo.super.setMoreInfo(widgetGroup);
        ImageWidget moreInfo = new ImageWidget();
        TextTexture moreInfoText = new TextTexture().setType(TextTexture.TextType.LEFT);
        moreInfoText.setWidth(130);
        moreInfoText.updateText(this.getMoreText());
        moreInfo.setBackground(new IGuiTexture[]{moreInfoText});
        moreInfo.setSize(130, 100);
        moreInfo.setSelfPosition(5, 5);
        widgetGroup.addWidget((Widget)moreInfo);
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (container.getExecutor().getEntityState().inaction()) {
            return;
        }
        SkillContainer basicAttack = container.getExecutor().getSkill((SkillSlot)TDESkillSlots.SECT);
        Skill skill = basicAttack.getSkill();
        if (skill instanceof BasicSect) {
            PlayerPatch playerPatch;
            BasicSect basicSect = (BasicSect)skill;
            if (container.getExecutor().isLogicalClient() && (playerPatch = container.getExecutor()) instanceof TDELocalPlayerPatch) {
                TDELocalPlayerPatch tdeLocalPlayerPatch = (TDELocalPlayerPatch)playerPatch;
                if (!basicSect.checkAllowed((Player)tdeLocalPlayerPatch.getOriginal())) {
                    return;
                }
                LocalPlayer player = (LocalPlayer)container.getExecutor().getOriginal();
                boolean isKeyDown = TDEKeyMappings.CHARGED_ATTACK.m_90857_();
                boolean wasCharging = (Boolean)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_CHARGING.get());
                int chargingTime = (Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.CHARGING_TIME.get());
                if (isKeyDown) {
                    if (chargingTime == this.MAX_CHARGING_TICKS) {
                        tdeLocalPlayerPatch.costEnergy(this.COST * 0.4f);
                    } else {
                        tdeLocalPlayerPatch.costEnergy(this.COST);
                    }
                    if (TDEAbilityUtils.getAbility(AbilityType.ENERGY, (Player)player) == 0.0f) {
                        if (chargingTime >= this.MIN_CHARGING_TICKS) {
                            if (chargingTime == this.MAX_CHARGING_TICKS) {
                                container.getExecutor().playAnimationSynchronized(basicSect.getFullChargingAttackAnimation(), 0.0f);
                            } else {
                                container.getExecutor().playAnimationSynchronized(basicSect.getChargingAttackAnimation(), 0.0f);
                            }
                        }
                        container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CHARGING_POWER.get(), (Object)Float.valueOf((float)chargingTime / (float)this.MAX_CHARGING_TICKS), player);
                        container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CHARGING_TIME.get(), (Object)0, player);
                        container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_CHARGING.get(), (Object)false, player);
                        return;
                    }
                    if (!wasCharging) {
                        container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_CHARGING.get(), (Object)true, player);
                        container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CHARGING_TIME.get(), (Object)0, player);
                    } else {
                        int newTime = Math.min(chargingTime + 1, this.MAX_CHARGING_TICKS);
                        if (newTime != chargingTime) {
                            container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CHARGING_TIME.get(), (Object)newTime, player);
                        }
                        if (chargingTime == this.MIN_CHARGING_TICKS) {
                            container.getExecutor().playAnimationSynchronized(basicSect.getChargingAnimation(), 0.15f);
                        }
                    }
                } else if (wasCharging) {
                    if (chargingTime >= this.MIN_CHARGING_TICKS) {
                        if (chargingTime == this.MAX_CHARGING_TICKS) {
                            container.getExecutor().playAnimationSynchronized(basicSect.getFullChargingAttackAnimation(), 0.0f);
                        } else {
                            container.getExecutor().playAnimationSynchronized(basicSect.getChargingAttackAnimation(), 0.0f);
                        }
                    }
                    container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CHARGING_POWER.get(), (Object)Float.valueOf((float)chargingTime / (float)this.MAX_CHARGING_TICKS), player);
                    container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_CHARGING.get(), (Object)false, player);
                    container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CHARGING_TIME.get(), (Object)0, player);
                }
            }
        }
    }

    public BasicChargedAttack(Builder builder) {
        super((SkillBuilder)builder);
    }

    public static Builder createChargedBasicAttackBuilder() {
        return new Builder().setCategory(TDESkillCategories.CHARGED_ATTACK).setResource(Skill.Resource.NONE);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_CHARGING.get())).booleanValue()) {
                LocalPlayer clientPlayer = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                clientPlayer.m_6858_(false);
                clientPlayer.m_20334_(0.0, 0.0, 0.0);
                Minecraft mc = Minecraft.m_91087_();
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92091_, (boolean)false);
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92085_, (boolean)false);
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92087_, (boolean)false);
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92086_, (boolean)false);
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92088_, (boolean)false);
                ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92089_, (boolean)false);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
    }

    public int getMAX_CHARGING_TICKS() {
        return this.MAX_CHARGING_TICKS;
    }

    public KeyMapping getKeyMapping() {
        return TDEKeyMappings.CHARGED_ATTACK;
    }

    public static class Builder
    extends SkillBuilder<BasicChargedAttack> {
        public Builder setCategory(SkillCategory category) {
            super.setCategory(category);
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            super.setActivateType(activateType);
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            super.setResource(resource);
            return this;
        }
    }
}

