/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.epicfight.gameassets.skill;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.gui.UiResource;
import com.merlin204.tde.item.weapon.TDEWeaponItem;
import com.merlin204.tde.item.weapon.TDEWeaponType;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface SkillInfo {
    default public String getIcon() {
        return "tde:textures/skill/empty.png";
    }

    default public String getGroup() {
        return "basic";
    }

    default public void setMoreInfo(WidgetGroup widgetGroup) {
        widgetGroup.setSize(140, 120);
        widgetGroup.setSelfPosition(5, 45);
        widgetGroup.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_1});
    }

    default public WidgetGroup getMoreInfo() {
        return new WidgetGroup();
    }

    default public String getMoreText() {
        return "";
    }

    default public Component getIntroduce() {
        return Component.m_237115_((String)("tde.skill.sect." + this.getGroup()));
    }

    default public Set<TDEWeaponType> getMainAllowed() {
        return null;
    }

    default public Set<TDEWeaponType> getOffAllowed() {
        return null;
    }

    default public float getMaxWeight() {
        return 100.0f;
    }

    default public Map<AbilityType, Float> getAbilityRequirements() {
        return Map.of();
    }

    default public String getMainAllowedWeaponTypes() {
        return this.weaponTypesToString(this.getMainAllowed());
    }

    default public String getOffAllowedWeaponTypes() {
        return this.weaponTypesToString(this.getOffAllowed());
    }

    private String weaponTypesToString(Set<TDEWeaponType> weaponTypes) {
        if (weaponTypes == null) {
            return Component.m_237115_((String)"weapon_type.tde.all").getString();
        }
        if (weaponTypes.isEmpty()) {
            return Component.m_237115_((String)"weapon_type.tde.empty").getString();
        }
        return weaponTypes.stream().map(type -> Component.m_237115_((String)type.getTranslationKey()).getString()).collect(Collectors.joining(" "));
    }

    default public float getAbilityRequirement(AbilityType abilityType) {
        return this.getAbilityRequirements().getOrDefault((Object)abilityType, Float.valueOf(0.0f)).floatValue();
    }

    default public boolean validatePlayer(Player player) {
        return this.validatePlayerWeapons(player) && this.validatePlayerAbilities(player);
    }

    default public boolean validatePlayerWeapons(Player player) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        float totalWeight = SkillInfo.getItemWeight(mainHand) + SkillInfo.getItemWeight(offHand);
        if (totalWeight > this.getMaxWeight()) {
            return false;
        }
        if (!SkillInfo.isValidItem(mainHand, this.getMainAllowed())) {
            return false;
        }
        return SkillInfo.isValidItem(offHand, this.getOffAllowed());
    }

    default public boolean validatePlayerAbilities(Player player) {
        Map<AbilityType, Float> requirements = this.getAbilityRequirements();
        for (Map.Entry<AbilityType, Float> entry : requirements.entrySet()) {
            AbilityType type = entry.getKey();
            float requiredValue = entry.getValue().floatValue();
            float playerValue = TDEAbilityUtils.getAbility(type, player);
            if (!(playerValue < requiredValue)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidItem(ItemStack stack, Set<TDEWeaponType> allowed) {
        if (allowed == null) {
            return true;
        }
        if (stack.m_41619_()) {
            return allowed.contains((Object)TDEWeaponType.EMPTY);
        }
        Item item = stack.m_41720_();
        if (item instanceof TDEWeaponItem) {
            TDEWeaponItem weapon = (TDEWeaponItem)item;
            return allowed.contains((Object)weapon.getProperties().getWeaponType());
        }
        return allowed.contains((Object)TDEWeaponType.EMPTY);
    }

    private static float getItemWeight(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0.0f;
        }
        Item item = stack.m_41720_();
        if (item instanceof TDEWeaponItem) {
            TDEWeaponItem weapon = (TDEWeaponItem)item;
            return weapon.getProperties().getWeight();
        }
        return 0.5f;
    }
}

