/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.epicfight.gameassets.skill;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.epicfight.gameassets.skill.soulfire.SoulfireSkill;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillCategories;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.util.TDEAbilityUtils;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class ExecuteSkill
extends Skill {
    public ExecuteSkill(Builder builder) {
        super((SkillBuilder)builder);
    }

    public static Builder createExecuteBuilder() {
        return new Builder().setCategory(TDESkillCategories.EXECUTE).setResource(Skill.Resource.NONE);
    }

    public int getCoolDown(PlayerPatch playerPatch) {
        return (Integer)playerPatch.getSkill((SkillSlot)TDESkillSlots.EXECUTE).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.EXCUTE_COOLDOWN.get());
    }

    public void setCoolDown(PlayerPatch playerPatch, int tick) {
        Entity entity = playerPatch.getOriginal();
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            playerPatch.getSkill((SkillSlot)TDESkillSlots.EXECUTE).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.EXCUTE_COOLDOWN.get(), (Object)tick, localPlayer);
        } else {
            entity = playerPatch.getOriginal();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                playerPatch.getSkill((SkillSlot)TDESkillSlots.EXECUTE).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.EXCUTE_COOLDOWN.get(), (Object)tick, serverPlayer);
            }
        }
    }

    public boolean canExecute(SkillContainer container) {
        PlayerPatch executor = container.getExecutor();
        return ((Player)executor.getOriginal()).m_20096_() || ((Player)executor.getOriginal()).m_7500_() || !container.getExecutor().getEntityState().inaction();
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        Skill skill;
        EnemyEntity enemyEntity;
        LivingEntity livingEntity;
        super.executeOnServer(container, args);
        if (this.getCoolDown(container.getExecutor()) > 0) {
            return;
        }
        ServerPlayerPatch executor = container.getServerExecutor();
        if (executor.getTarget() != null && (livingEntity = executor.getTarget()) instanceof EnemyEntity && (enemyEntity = (EnemyEntity)livingEntity).isKnockdown() && (skill = executor.getSkill((SkillSlot)TDESkillSlots.SOULFIRE).getSkill()) instanceof SoulfireSkill) {
            SoulfireSkill soulfireSkill = (SoulfireSkill)skill;
            executor.playAnimationSynchronized(soulfireSkill.getExecuteAnimation(), 0.0f);
            TDEAbilityUtils.addAbility(AbilityType.ENERGY, (Player)executor.getOriginal(), 9999.0f);
        }
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (this.getCoolDown(container.getExecutor()) > 0) {
            this.setCoolDown(container.getExecutor(), this.getCoolDown(container.getExecutor()) - 1);
        }
    }

    public static class Builder
    extends SkillBuilder<ExecuteSkill> {
        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCreativeTab(CreativeModeTab tab) {
            this.tab = tab;
            return this;
        }
    }
}

