/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.epicfight.animations.player;

import java.util.function.Function;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.entity.DodgeLocationIndicator;

public class TDEPlayerDodgeAnimation
extends ActionAnimation {
    public static final Function<DamageSource, AttackResult.ResultType> DODGEABLE_SUCCESS = damagesource -> damagesource.m_7639_() != null && !damagesource.m_276093_(DamageTypes.f_268515_) && !damagesource.m_269533_(DamageTypeTags.f_268490_) && !damagesource.m_269533_(DamageTypeTags.f_268738_) && !damagesource.m_269533_(EpicFightDamageType.BYPASS_DODGE) ? AttackResult.ResultType.MISSED : AttackResult.ResultType.SUCCESS;

    public TDEPlayerDodgeAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends TDEPlayerDodgeAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(transitionTime, 10.0f, accessor, armature);
    }

    public TDEPlayerDodgeAnimation(float transitionTime, float endFrame, AnimationManager.AnimationAccessor<? extends TDEPlayerDodgeAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, endFrame / 60.0f, accessor, armature);
        float endTime = endFrame / 60.0f;
        this.stateSpectrumBlueprint.clear().newTimePair(0.0f, endTime).addState(EntityState.TURNING_LOCKED, (Object)true).addState(EntityState.MOVEMENT_LOCKED, (Object)true).addState(EntityState.UPDATE_LIVING_MOTION, (Object)false).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).addState(EntityState.CAN_SKILL_EXECUTION, (Object)false).addState(EntityState.INACTION, (Object)true).addState(EntityState.ATTACK_RESULT, DODGEABLE_SUCCESS).newTimePair(endTime, Float.MAX_VALUE).addState(EntityState.TURNING_LOCKED, (Object)false).addState(EntityState.MOVEMENT_LOCKED, (Object)false).addState(EntityState.UPDATE_LIVING_MOTION, (Object)true).addState(EntityState.CAN_BASIC_ATTACK, (Object)true).addState(EntityState.CAN_SKILL_EXECUTION, (Object)true).addState(EntityState.INACTION, (Object)true);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.AFFECT_SPEED, true);
        this.addProperty(AnimationProperty.StaticAnimationProperty.FIXED_HEAD_ROTATION, false);
    }

    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        if (!entitypatch.isLogicalClient() && entitypatch != null) {
            ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7967_((Entity)new DodgeLocationIndicator(entitypatch));
        }
    }
}

