/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.epicfight.animations.player;

import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.sect.basic.BasicSect;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class TDEPlayerBlockHitAnimation
extends ActionAnimation {
    private final boolean shouldReserve;

    public TDEPlayerBlockHitAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends ActionAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, accessor, armature);
        this.addProperty(AnimationProperty.ActionAnimationProperty.FIXED_HEAD_ROTATION, false);
        this.newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.INACTION, (Object)false).addState(EntityState.CAN_BASIC_ATTACK, (Object)true).addState(EntityState.CAN_SKILL_EXECUTION, (Object)true).addState(EntityState.CAN_SWITCH_HAND_ITEM, (Object)false).addState(EntityState.CAN_USE_ITEM, (Object)true);
        this.shouldReserve = true;
    }

    public TDEPlayerBlockHitAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends ActionAnimation> accessor, AssetAccessor<? extends Armature> armature, boolean shouldReserve) {
        super(transitionTime, accessor, armature);
        this.addProperty(AnimationProperty.ActionAnimationProperty.FIXED_HEAD_ROTATION, false);
        this.newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.INACTION, (Object)false).addState(EntityState.CAN_BASIC_ATTACK, (Object)true).addState(EntityState.CAN_SKILL_EXECUTION, (Object)true).addState(EntityState.CAN_SWITCH_HAND_ITEM, (Object)false).addState(EntityState.CAN_USE_ITEM, (Object)true);
        this.shouldReserve = shouldReserve;
    }

    public void end(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        if (entitypatch instanceof TDEServerPlayerPatch) {
            Skill skill;
            TDEServerPlayerPatch serverPlayerPatch = (TDEServerPlayerPatch)entitypatch;
            SkillContainer basicAttack = serverPlayerPatch.getSkill(TDESkillSlots.SECT);
            if (serverPlayerPatch.isGuard() && (skill = basicAttack.getSkill()) instanceof BasicSect) {
                BasicSect basicSect = (BasicSect)skill;
                if (this.shouldReserve) {
                    serverPlayerPatch.reserveAnimation((AssetAccessor)basicSect.getGuardAnimation());
                }
            }
        }
    }
}

