/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.epicfight.animations.player;

import com.merlin204.tde.entity.boss.BossEntity;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.animations.TDEAttackAnimation;
import com.merlin204.tde.epicfight.animations.player.TDEPlayerAttackAnimation;
import com.merlin204.tde.epicfight.gameassets.skill.ExecuteSkill;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.util.TDEAnimationUtils;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.BasicAttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

public class ExecuteAnimation
extends TDEPlayerAttackAnimation {
    private final float healthDamageRatio;
    private final float energyDamageRatio;

    public ExecuteAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, float healthDamageRatio, float energyDamageRatio, TDEAttackAnimation.TDEPhase ... phases) {
        super(transitionTime, accessor, armature, phases);
        this.healthDamageRatio = healthDamageRatio;
        this.energyDamageRatio = energyDamageRatio;
    }

    public void tick(LivingEntityPatch<?> entitypatch) {
        TDEServerPlayerPatch tdeServerPlayerPatch;
        Skill skill;
        super.tick(entitypatch);
        if (entitypatch instanceof TDEServerPlayerPatch && (skill = (tdeServerPlayerPatch = (TDEServerPlayerPatch)entitypatch).getSkill(TDESkillSlots.EXECUTE).getSkill()) instanceof ExecuteSkill) {
            ExecuteSkill executeSkill = (ExecuteSkill)skill;
            executeSkill.setCoolDown((PlayerPatch)tdeServerPlayerPatch, 5);
        }
    }

    @Override
    protected void hurtCollidingEntities(LivingEntityPatch<?> entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
        float phasePrevTime = Math.max(prevElapsedTime, phase.start);
        float phaseCurrentTime = Math.min(elapsedTime, phase.end);
        float phasePreDelay = phase.start + phase.preDelay;
        float phaseContact = phase.start + phase.contact;
        if (phaseCurrentTime < phasePreDelay || phasePrevTime >= phaseContact) {
            return;
        }
        List list = phase.getCollidingEntities(entitypatch, (AttackAnimation)this, phasePrevTime, phaseCurrentTime, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
        if (!list.isEmpty()) {
            HitEntityList hitEntities = new HitEntityList(entitypatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            int maxStrikes = 10;
            while (hitEntities.next()) {
                boolean canAttack;
                Entity target = hitEntities.getEntity();
                LivingEntity trueEntity = this.getTrueEntity(target);
                boolean bl = canAttack = trueEntity != null && trueEntity.m_6084_() && !entitypatch.getCurrenltyAttackedEntities().contains(trueEntity) && !entitypatch.isTargetInvulnerable(target);
                if (phase instanceof TDEAttackAnimation.TDEPhase) {
                    TDEAttackAnimation.TDEPhase tdePhase = (TDEAttackAnimation.TDEPhase)phase;
                    boolean bl2 = canAttack = canAttack && tdePhase.tryAttack((Entity)trueEntity);
                }
                if (!canAttack || !entity.m_142582_(target)) continue;
                EpicFightDamageSource damagesource = this.getEpicFightDamageSource((LivingEntityPatch)entitypatch, target, phase);
                int prevInvulTime = target.f_19802_;
                target.f_19802_ = 0;
                AttackResult attackResult = entitypatch.attack(damagesource, target, phase.hand);
                target.f_19802_ = prevInvulTime;
                if (attackResult.resultType.dealtDamage()) {
                    TDEAnimationUtils.shakeCameraForNearbyPlayers(entity.m_9236_(), target.m_20182_(), 3.0, 20, damagesource.getImpactLevel() * 2, 0.5f);
                    if (target instanceof EnemyEntity) {
                        EnemyEntity enemyEntity = (EnemyEntity)target;
                        if (enemyEntity instanceof BossEntity) {
                            enemyEntity.m_6469_((DamageSource)damagesource, enemyEntity.m_21233_() * this.healthDamageRatio);
                        } else {
                            enemyEntity.m_6469_((DamageSource)damagesource, enemyEntity.m_21233_() * this.healthDamageRatio * 3.0f);
                        }
                        if (entitypatch instanceof TDEServerPlayerPatch) {
                            TDEServerPlayerPatch tdeServerPlayerPatch = (TDEServerPlayerPatch)entitypatch;
                            tdeServerPlayerPatch.energyDamageAtk(enemyEntity.getEnemyPatch(), enemyEntity.getMaxEnergy() * this.energyDamageRatio);
                        }
                        enemyEntity.getEnemyPatch().playAnimationSynchronized((AssetAccessor)enemyEntity.getEnemyPatch().getKnockFlyAnimation(), 0.0f);
                    }
                    target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), this.getHitSound(entitypatch, phase), target.m_5720_(), 1.0f, 1.0f);
                    this.spawnHitParticle((ServerLevel)target.m_9236_(), entitypatch, target, phase);
                }
                entitypatch.getCurrenltyAttackedEntities().add(trueEntity);
                if (!attackResult.resultType.shouldCount()) continue;
                entitypatch.getCurrenltyHurtEntities().add(trueEntity);
            }
        }
    }
}

