/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.epicfight.animations;

import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class TDEKnockDownAnimation
extends ActionAnimation {
    public TDEKnockDownAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends ActionAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, accessor, armature);
        this.newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).addState(EntityState.CAN_SKILL_EXECUTION, (Object)false).addState(EntityState.CAN_SWITCH_HAND_ITEM, (Object)false).addState(EntityState.CAN_USE_ITEM, (Object)false);
    }

    public TDEKnockDownAnimation(float transitionTime, float postDelay, AnimationManager.AnimationAccessor<? extends ActionAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, postDelay, accessor, armature);
        this.newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).addState(EntityState.CAN_SKILL_EXECUTION, (Object)false).addState(EntityState.CAN_SWITCH_HAND_ITEM, (Object)false).addState(EntityState.CAN_USE_ITEM, (Object)false);
    }

    public TDEKnockDownAnimation(float transitionTime, float postDelay, String path, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, postDelay, path, armature);
        this.newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).addState(EntityState.CAN_SKILL_EXECUTION, (Object)false).addState(EntityState.CAN_SWITCH_HAND_ITEM, (Object)false).addState(EntityState.CAN_USE_ITEM, (Object)false);
    }

    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (entitypatch instanceof EnemyPatch) {
            EnemyPatch enemyPatch = (EnemyPatch)entitypatch;
            ((EnemyEntity)enemyPatch.getOriginal()).setStopEnergyRecoverTick(30);
            ((EnemyEntity)enemyPatch.getOriginal()).setKnockdownTick(5);
        }
        if (entitypatch instanceof TDEServerPlayerPatch) {
            TDEServerPlayerPatch serverPlayerPatch = (TDEServerPlayerPatch)entitypatch;
            serverPlayerPatch.stopEnergyRecoveryTime = 30;
        }
    }
}

