/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.epicfight.animations;

import com.merlin204.tde.entity.boss.B1.B1Animations;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class RotatingAnimation
extends ActionAnimation {
    private float startRot = 0.0f;

    public RotatingAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends ActionAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, accessor, armature);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.REMOVE_DELTA_MOVEMENT, false);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, false);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.MOVE_VERTICAL, false);
    }

    public RotatingAnimation(float transitionTime, float postDelay, AnimationManager.AnimationAccessor<? extends ActionAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, accessor, armature);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.REMOVE_DELTA_MOVEMENT, false);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, false);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.MOVE_VERTICAL, false);
    }

    public void begin(LivingEntityPatch<?> entityPatch) {
        super.begin(entityPatch);
        if (entityPatch instanceof EnemyPatch) {
            EnemyPatch enemyPatch = (EnemyPatch)entityPatch;
            this.startRot = enemyPatch.getRootYRot();
            ((EnemyEntity)enemyPatch.getOriginal()).setRotating(true);
            ((EnemyEntity)enemyPatch.getOriginal()).updateYRotBeforeRotation();
        }
    }

    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (entitypatch instanceof EnemyPatch) {
            EnemyPatch enemyPatch = (EnemyPatch)entitypatch;
            enemyPatch.setYRot(((EnemyEntity)enemyPatch.getOriginal()).getCorrectYRot(1.0f) + enemyPatch.getRootYRot() - this.startRot);
            ((EnemyEntity)enemyPatch.getOriginal()).f_20883_ = enemyPatch.getYRot();
        }
    }

    public void end(LivingEntityPatch<?> entityPatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        super.end(entityPatch, nextAnimation, isEnd);
        if (entityPatch instanceof EnemyPatch) {
            EnemyPatch enemyPatch = (EnemyPatch)entityPatch;
            ((EnemyEntity)enemyPatch.getOriginal()).setRotating(false);
            enemyPatch.reserveAnimation((AssetAccessor)B1Animations.B1_IDLE);
        }
    }
}

