/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.vfx.soulfire;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.photon.PosEffect;
import com.merlin204.tde.util.TDEAbilityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SoulFireEntity
extends Mob {
    protected static final EntityDataAccessor<String> FX = SynchedEntityData.m_135353_(SoulFireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<Float> SOUL_AMOUNT = SynchedEntityData.m_135353_(SoulFireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final double SPEED = (double)0.2f;
    private static final double TARGET_RANGE = 16.0;
    private static final double DESTROY_DISTANCE = (double)0.1f;
    private Vec3 startPos;

    public SoulFireEntity(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setupNoPhysics();
    }

    public SoulFireEntity(EntityType<? extends Mob> pEntityType, Level pLevel, String fxPath, Float soulFireAmount) {
        super(pEntityType, pLevel);
        this.setupNoPhysics();
        this.f_19804_.m_135381_(FX, (Object)fxPath);
        this.f_19804_.m_135381_(SOUL_AMOUNT, (Object)soulFireAmount);
    }

    public SoulFireEntity(EntityType<? extends Mob> pEntityType, Level pLevel, String fxPath, Float soulFireAmount, Vec3 startPos) {
        super(pEntityType, pLevel);
        this.setupNoPhysics();
        this.f_19804_.m_135381_(FX, (Object)fxPath);
        this.f_19804_.m_135381_(SOUL_AMOUNT, (Object)soulFireAmount);
        this.startPos = startPos;
    }

    private void setupNoPhysics() {
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(FX, (Object)"photon:soulfire/soulfire_2");
        this.m_20088_().m_135372_(SOUL_AMOUNT, (Object)Float.valueOf(0.0f));
    }

    public static AttributeSupplier getDefaultAttribute() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22278_, 500.0).m_22268_(Attributes.f_22281_, 0.0).m_22265_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Fx", (String)this.f_19804_.m_135370_(FX));
        tag.m_128350_("Amount", ((Float)this.f_19804_.m_135370_(SOUL_AMOUNT)).floatValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Fx")) {
            this.f_19804_.m_135381_(FX, (Object)tag.m_128461_("Fx"));
        }
        if (tag.m_128441_("Amount")) {
            this.f_19804_.m_135381_(SOUL_AMOUNT, (Object)Float.valueOf(tag.m_128457_("Amount")));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.m_6084_()) {
            FX fx = FXHelper.getFX((ResourceLocation)new ResourceLocation((String)this.f_19804_.m_135370_(FX)));
            Vec3 lastTickPos = new Vec3(this.f_19790_, this.f_19791_, this.f_19792_);
            Vec3 step = this.m_20182_().m_82546_(lastTickPos).m_82490_((double)0.3f);
            for (int i = 1; i < 4; ++i) {
                new PosEffect(fx, this.m_9236_(), (Entity)this, lastTickPos.m_82549_(step), 8, false, true).start();
            }
        }
        if (this.startPos != null) {
            if (!this.m_9236_().f_46443_) {
                Vec3 currentPos = this.m_20182_();
                Vec3 direction = this.startPos.m_82546_(currentPos);
                double distance = direction.m_82553_();
                if (distance <= 0.1) {
                    this.startPos = null;
                    return;
                }
                Vec3 motion = direction.m_82541_().m_82490_((double)0.2f);
                this.m_20256_(motion);
            }
        } else {
            Player targetPlayer = this.findNearestPlayer();
            if (targetPlayer != null) {
                this.flyToPlayer(targetPlayer);
            }
        }
    }

    private Player findNearestPlayer() {
        AABB searchArea = new AABB(this.m_20185_() - 16.0, this.m_20186_() - 16.0, this.m_20189_() - 16.0, this.m_20185_() + 16.0, this.m_20186_() + 16.0, this.m_20189_() + 16.0);
        Player nearestPlayer = null;
        double closestDistance = Double.MAX_VALUE;
        for (Player player : this.m_9236_().m_45976_(Player.class, searchArea)) {
            double distance = this.m_20280_((Entity)player);
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }

    public void flyToPlayer(Player player) {
        Vec3 currentPos;
        Vec3 targetPos = player.m_20182_().m_82520_(0.0, (double)player.m_20206_() * 0.8, 0.0);
        Vec3 direction = targetPos.m_82546_(currentPos = this.m_20182_());
        double distance = direction.m_82553_();
        if (distance <= (double)0.1f) {
            this.transferSoulFire(player);
            this.m_146870_();
            return;
        }
        Vec3 motion = direction.m_82541_().m_82490_((double)0.2f);
        if (!player.m_9236_().f_46443_) {
            this.m_20256_(motion);
        }
    }

    public void transferSoulFire(Player player) {
        float amount = ((Float)this.f_19804_.m_135370_(SOUL_AMOUNT)).floatValue();
        if (amount <= 0.0f) {
            return;
        }
        if (!player.m_9236_().f_46443_) {
            TDEAbilityUtils.addAbility(AbilityType.SOUL, player, amount);
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float p_21017_) {
        return false;
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public boolean m_5843_() {
        return false;
    }
}

