/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.skill.se_1;

import com.lowdragmc.photon.client.fx.BlockEffect;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.effect.TDEMobEffects;
import com.merlin204.tde.entity.TDEEntities;
import com.merlin204.tde.entity.skill.SkillEntity;
import com.merlin204.tde.entity.skill.se_1.SoulGroundFlameEntity;
import com.merlin204.tde.photon.PosEffect;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SoulFireBallEntity
extends SkillEntity {
    private static final double BASE_SPEED = (double)0.6f;
    private static final double TRACKING_STRENGTH = 0.03;
    private static final double GRAVITY = 0.005;
    private static final int MAX_LIFETIME = 300;
    private static final float DAMAGE_RADIUS = 2.0f;
    private static final float BASE_DAMAGE = 10.0f;
    private Vec3 firstTargetPos = null;
    private float damageAmount = 10.0f;
    private int ignoreOwnerTicks = 5;
    private LivingEntity target;

    public SoulFireBallEntity(EntityType<? extends SkillEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SoulFireBallEntity(EntityType<? extends SkillEntity> entityType, LivingEntity owner, Level level) {
        super(entityType, owner);
        this.m_6034_(owner.m_20185_(), owner.m_20188_() - 0.1, owner.m_20189_());
        Vec3 look = owner.m_20154_();
        this.m_20256_(look.m_82490_((double)0.6f));
    }

    public SoulFireBallEntity(EntityType<? extends SkillEntity> entityType, LivingEntity owner, Vec3 TargetPos, Level level) {
        super(entityType, owner);
        this.firstTargetPos = TargetPos;
    }

    public void setDamageAmount(float damage) {
        this.damageAmount = damage;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 300) {
            this.explode();
            this.m_146870_();
            return;
        }
        if (this.ignoreOwnerTicks > 0) {
            --this.ignoreOwnerTicks;
        }
        Vec3 oldPos = this.m_20182_();
        Vec3 movement = this.m_20184_();
        Vec3 newPos = oldPos.m_82549_(movement);
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        this.checkCollisions(oldPos);
        Vec3 newMovement = movement.m_82520_(0.0, -0.005, 0.0);
        if (this.firstTargetPos != null) {
            if (this.m_20182_().m_82554_(this.firstTargetPos) < 0.5) {
                this.firstTargetPos = null;
            } else {
                Vec3 toTarget = this.firstTargetPos.m_82546_(this.m_20182_()).m_82541_();
                newMovement = newMovement.m_82490_(0.97).m_82549_(toTarget.m_82490_(0.018000000715255735));
            }
        } else if (this.getOwnerPatch() != null) {
            this.target = this.getOwnerPatch().getTarget();
            if (this.target != null && this.target.m_6084_()) {
                Vec3 targetPos = this.target.m_20182_().m_82520_(0.0, (double)(this.target.m_20206_() / 2.0f), 0.0);
                Vec3 toTarget = targetPos.m_82546_(this.m_20182_()).m_82541_();
                newMovement = newMovement.m_82490_(0.97).m_82549_(toTarget.m_82490_(0.018000000715255735));
            }
        }
        this.m_20256_(newMovement);
        if (this.m_9236_().f_46443_ && this.m_6084_()) {
            FX fx = FXHelper.getFX((ResourceLocation)new ResourceLocation("photon:skill/se_1/soulfireball"));
            Vec3 lastTickPos = new Vec3(this.f_19790_, this.f_19791_, this.f_19792_);
            Vec3 step = this.m_20182_().m_82546_(lastTickPos).m_82490_((double)0.3f);
            for (int i = 1; i < 4; ++i) {
                new PosEffect(fx, this.m_9236_(), (Entity)this, lastTickPos.m_82549_(step), 8, false, true).start();
            }
        }
    }

    private void checkCollisions(Vec3 startPos) {
        Vec3 endPos = this.m_20182_();
        Vec3 movement = endPos.m_82546_(startPos);
        EntityHitResult entityHit = this.findEntityCollision(startPos, endPos);
        if (entityHit != null) {
            this.onEntityCollision(entityHit);
            return;
        }
        BlockHitResult blockHit = this.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            this.onBlockCollision(blockHit);
        }
    }

    private EntityHitResult findEntityCollision(Vec3 startPos, Vec3 endPos) {
        AABB collisionBox = this.m_20191_().m_82369_(this.m_20184_());
        for (Entity entity : this.m_9236_().m_45933_((Entity)this, collisionBox)) {
            AABB entityBox;
            Optional collisionPoint;
            if (entity == this.getOwner() || entity == this || !(collisionPoint = (entityBox = entity.m_20191_().m_82400_(1.0)).m_82371_(startPos, endPos)).isPresent()) continue;
            return new EntityHitResult(entity, (Vec3)collisionPoint.get());
        }
        return null;
    }

    private void onEntityCollision(EntityHitResult hitResult) {
        if (hitResult.m_82443_() == this.getOwner()) {
            return;
        }
        this.createGroundFlame(hitResult.m_82450_());
        this.explode();
        this.m_146870_();
    }

    private void onBlockCollision(BlockHitResult hitResult) {
        this.createGroundFlame(hitResult.m_82450_());
        this.explode();
        this.m_146870_();
    }

    private void createGroundFlame(Vec3 position) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        double x = position.f_82479_;
        double y = position.f_82480_;
        double z = position.f_82481_;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(x, y, z);
        Level level = this.m_9236_();
        while (mutablePos.m_123342_() < level.m_151558_() && level.m_8055_((BlockPos)mutablePos).m_280296_()) {
            mutablePos.m_122184_(0, 1, 0);
        }
        y = mutablePos.m_123342_() < level.m_151558_() ? (double)mutablePos.m_123342_() : (y += 0.1);
        SoulGroundFlameEntity groundFlame = new SoulGroundFlameEntity((EntityType<? extends SkillEntity>)((EntityType)TDEEntities.SOUL_GROUND_FLAME.get()), this.getOwner(), level, x, y, z);
        level.m_7967_((Entity)groundFlame);
        level.m_6263_(null, x, y, z, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f, 0.8f);
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
    }

    private void explode() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        FX fx = FXHelper.getFX((ResourceLocation)new ResourceLocation("photon:skill/se_1/soulfireball_boom"));
        if (fx != null) {
            BlockPos blockPos = this.m_20097_();
            BlockEffect blockEffect = new BlockEffect(fx, this.m_9236_(), blockPos);
            blockEffect.setOffset(0.0, 0.0, 0.0);
            blockEffect.setAllowMulti(true);
            blockEffect.setForcedDeath(true);
            blockEffect.start();
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 4.0f, (1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f) * 0.7f);
        AABB damageArea = this.m_20191_().m_82400_(2.0);
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, damageArea)) {
            double dist;
            if (entity == this.getOwner() || !((dist = (double)this.m_20270_((Entity)entity)) < 2.0)) continue;
            float damage = this.damageAmount * (1.0f - (float)(dist / 2.0));
            MobEffectInstance effect = entity.m_21124_((MobEffect)TDEMobEffects.SOUL_FIRE_INFLICTION.get());
            if (effect != null) {
                newEffect = new MobEffectInstance((MobEffect)TDEMobEffects.SOUL_FIRE_INFLICTION.get(), 100, effect.m_19564_() + 1, false, false, true);
                if (effect.m_19564_() >= 9) {
                    newEffect = new MobEffectInstance((MobEffect)TDEMobEffects.SOUL_FIRE_INFLICTION.get(), 100, 9, false, false, true);
                }
                entity.m_7292_(newEffect);
            } else {
                newEffect = new MobEffectInstance((MobEffect)TDEMobEffects.SOUL_FIRE_INFLICTION.get(), 100, 0, false, false, true);
                entity.m_7292_(newEffect);
            }
            entity.m_6469_(entity.m_269291_().m_269036_((Entity)this, (Entity)this.getOwner()), damage);
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6051_() {
        return false;
    }
}

