/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.skill.other;

import com.merlin204.tde.entity.skill.SkillEntity;
import com.merlin204.tde.entity.skill.other.ArrowAnimations;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;

public class ArrowEntity
extends SkillEntity {
    private static final double ATTACK_RADIUS = 1.0;
    private boolean initialVelocityApplied = false;
    private float flightSpeed = 1.5f;
    private boolean hasCollided = false;

    public ArrowEntity(EntityType<? extends SkillEntity> entityType, LivingEntity owner) {
        super(entityType, owner);
        this.m_20242_(true);
        this.f_19794_ = true;
    }

    public ArrowEntity(EntityType<? extends SkillEntity> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
        this.f_19794_ = true;
    }

    @Override
    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getDefaultAnimation() {
        return ArrowAnimations.IDLE;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.updateClientSide();
            return;
        }
        if (!this.initialVelocityApplied) {
            this.applyInitialVelocity();
            this.initialVelocityApplied = true;
        }
        this.moveEntity();
        if (!this.hasCollided) {
            this.checkCollisions();
        } else if (this.f_19797_ > 5) {
            this.m_146870_();
        }
        if (this.f_19797_ >= 200) {
            this.m_146870_();
        }
    }

    private void updateClientSide() {
        Vec3 motion = this.m_20184_();
        Vec3 newPos = this.m_20182_().m_82549_(motion);
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
    }

    private void moveEntity() {
        Vec3 motion = this.m_20184_();
        Vec3 newPos = this.m_20182_().m_82549_(motion);
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
    }

    private void checkCollisions() {
        BlockHitResult blockHit = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82549_(this.m_20184_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            this.handleCollision();
            return;
        }
        AABB collisionBox = this.m_20191_().m_82369_(this.m_20184_());
        List entities = this.m_9236_().m_45933_((Entity)this, collisionBox);
        for (Entity entity : entities) {
            LivingEntity target;
            if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity) == this || target == this.getOwner()) continue;
            this.handleCollision();
            this.attackEntity(target);
            break;
        }
    }

    private void handleCollision() {
        this.hasCollided = true;
        this.m_20256_(Vec3.f_82478_);
        this.playCollisionEffects();
    }

    private void applyInitialVelocity() {
        float yRotRad = this.m_146908_() * ((float)Math.PI / 180);
        float xRotRad = this.m_146909_() * ((float)Math.PI / 180);
        double motionX = -Math.sin(yRotRad) * Math.cos(xRotRad);
        double motionY = -Math.sin(xRotRad);
        double motionZ = Math.cos(yRotRad) * Math.cos(xRotRad);
        Vec3 motion = new Vec3(motionX, motionY, motionZ).m_82490_((double)this.flightSpeed);
        this.m_20256_(motion);
    }

    public void setFlightSpeed(float speed) {
        this.flightSpeed = speed;
    }

    @Override
    public Armature getArmature() {
        return Armatures.ArmatureAccessor.create((String)"tde", (String)"entity/only_root", Armature::new).get();
    }

    @Override
    public AssetAccessor<? extends SkinnedMesh> getMesh() {
        return Meshes.MeshAccessor.create((String)"tde", (String)"entity/arrow/arrow_1", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"tde", (String)"textures/entity/arrow/arrow_1.png");
    }

    private void attackEntity(LivingEntity target) {
        if (this.getOwner() != null) {
            this.getOwnerPatch().attack(this.getPatch().getDamageSource((AnimationManager.AnimationAccessor)Animations.EMPTY_ANIMATION, InteractionHand.MAIN_HAND), (Entity)target, InteractionHand.MAIN_HAND);
        } else {
            this.getPatch().attack(this.getPatch().getDamageSource((AnimationManager.AnimationAccessor)Animations.EMPTY_ANIMATION, InteractionHand.MAIN_HAND), (Entity)target, InteractionHand.MAIN_HAND);
        }
    }

    private void playCollisionEffects() {
        this.m_5496_((SoundEvent)EpicFightSounds.BLADE_HIT.get(), 1.0f, 1.0f);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 20, 0.2, 0.2, 0.2, 0.1);
        }
    }

    public void aimAtEntity(Entity target) {
        if (target == null) {
            return;
        }
        Vec3 eyePos = this.m_146892_();
        Vec3 targetPos = target.m_146892_();
        Vec3 direction = targetPos.m_82546_(eyePos).m_82541_();
        double horizontalDistance = direction.m_165924_();
        float yRot = (float)(Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_) * -57.29577951308232);
        float xRot = (float)(Mth.m_14136_((double)direction.f_82480_, (double)horizontalDistance) * -57.29577951308232);
        this.m_146922_(yRot);
        this.m_146926_(xRot);
        this.f_19859_ = yRot;
        this.f_19860_ = xRot;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22281_, 0.0);
    }
}

