/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.skill;

import com.merlin204.tde.entity.skill.SkillEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;

public class SkillEntityPatch<T extends SkillEntity>
extends MobPatch<T> {
    @Nullable
    private LivingEntityPatch<?> ownerPatch;

    public SkillEntityPatch() {
    }

    public void onConstructed(T entityIn) {
        Animator animator;
        this.original = entityIn;
        this.armature = ((SkillEntity)entityIn).getArmature();
        this.animator = animator = EpicFightSharedConstants.getAnimator((LivingEntityPatch)this);
        this.initAnimator(animator);
        animator.postInit();
    }

    public void onJoinWorld(T entity, EntityJoinLevelEvent event) {
        super.onJoinWorld(entity, event);
        if (this.isLogicalClient()) {
            this.getClientAnimator().playAnimation(((SkillEntity)this.original).getDefaultAnimation(), 0.0f);
        } else {
            this.playAnimationSynchronized((AssetAccessor)((SkillEntity)this.original).getDefaultAnimation(), 0.0f);
        }
    }

    public SkillEntityPatch(Faction faction) {
        super(faction);
    }

    public void updateMotion(boolean considerInaction) {
        if (considerInaction) {
            this.currentLivingMotion = LivingMotions.IDLE;
        }
    }

    public Armature getArmature() {
        return ((SkillEntity)this.original).getArmature();
    }

    public AssetAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return null;
    }

    @Nullable
    public LivingEntityPatch<?> getOwnerPatch() {
        if (this.ownerPatch != null) {
            return this.ownerPatch;
        }
        if (((SkillEntity)this.getOriginal()).getOwner() != null) {
            this.ownerPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)((SkillEntity)this.getOriginal()).getOwner(), LivingEntityPatch.class);
            return this.ownerPatch;
        }
        return null;
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        if (this.getOwnerPatch() != null && this.shouldUseOwnerAttack()) {
            return this.getOwnerPatch().attack(damageSource, target, hand);
        }
        return super.attack(damageSource, target, hand);
    }

    public boolean shouldUseOwnerAttack() {
        return true;
    }

    protected void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, ((SkillEntity)this.original).getIdleAnimation());
    }

    @Nullable
    public EpicFightDamageSource getEpicFightDamageSource() {
        if (this.getOwnerPatch() != null) {
            return this.getOwnerPatch().getEpicFightDamageSource();
        }
        return super.getEpicFightDamageSource();
    }

    public EpicFightDamageSource getDamageSource(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, InteractionHand hand) {
        if (this.getOwnerPatch() != null) {
            return this.getOwnerPatch().getDamageSource(animation, hand);
        }
        return super.getDamageSource(animation, hand);
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        if (this.getOwnerPatch() == null) {
            return super.getSwingSound(hand);
        }
        return this.getOwnerPatch().getSwingSound(hand);
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        if (this.getOwnerPatch() == null) {
            return super.getWeaponHitSound(hand);
        }
        return this.getOwnerPatch().getWeaponHitSound(hand);
    }

    public boolean isTargetInvulnerable(Entity entity) {
        if (entity.equals((Object)((SkillEntity)this.getOriginal()).getOwner())) {
            return true;
        }
        if (entity instanceof SkillEntity) {
            SkillEntity artifactSpiritEntity = (SkillEntity)entity;
            if (this.getOwnerPatch() != null) {
                return ((LivingEntity)this.getOwnerPatch().getOriginal()).equals((Object)artifactSpiritEntity.getOwner());
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean flashTargetIndicator(LocalPlayerPatch playerPatch) {
        return false;
    }
}

