/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.player.client;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonStatus;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class TDECamera {
    private static final double MAX_PITCH = 70.0;
    private static final double BASE_TURN_SPEED = 0.15;
    private static final double MIN_TURN_SPEED = 0.03;
    private static final double MAX_TURN_SPEED = 0.25;
    private static final double EDGE_THRESHOLD = 0.5;
    private static final double CENTER_RELAX = 0.3;
    private static Vector2d previousRotation = new Vector2d(0.0, 0.0);
    private static Vec3 lastTargetPos = Vec3.f_82478_;
    private static Vec3 lastValidTargetPos = Vec3.f_82478_;
    private static boolean lastFrameValid = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void thirdCamera(TDELocalPlayerPatch localPlayerPatch, float partialTicks) {
        LivingEntity targetEntity = localPlayerPatch.getTarget();
        if (targetEntity == null || !localPlayerPatch.isLockon()) {
            return;
        }
        if (!ThirdPersonStatus.isRenderingInThirdPerson()) {
            return;
        }
        Camera camera = ThirdPerson.CAMERA_AGENT.getRawCamera();
        if (camera == null) {
            return;
        }
        Vector2d currentRot = ThirdPerson.CAMERA_AGENT.getRotation();
        if (!TDECamera.isFinite(currentRot.x) || !TDECamera.isFinite(currentRot.y)) {
            ThirdPerson.CAMERA_AGENT.setRotation(new Vector2d(0.0, 0.0));
            currentRot = new Vector2d(0.0, 0.0);
        }
        Vec3 targetPos = TDECamera.getTargetPosition((Entity)targetEntity, partialTicks);
        if (!(TDECamera.isFinite(targetPos.f_82479_) && TDECamera.isFinite(targetPos.f_82480_) && TDECamera.isFinite(targetPos.f_82481_))) {
            if (!lastFrameValid) return;
            targetPos = lastValidTargetPos;
        } else {
            lastValidTargetPos = targetPos;
            lastFrameValid = true;
        }
        Vector2d screenPos = TDECamera.worldToScreenPosition(camera, targetPos, partialTicks);
        if (!TDECamera.isFinite(screenPos.x) || !TDECamera.isFinite(screenPos.y)) {
            return;
        }
        if (TDECamera.isInRelaxedZone(screenPos)) {
            return;
        }
        Vec3 cameraPos = camera.m_90583_();
        if (!(TDECamera.isFinite(cameraPos.f_82479_) && TDECamera.isFinite(cameraPos.f_82480_) && TDECamera.isFinite(cameraPos.f_82481_))) {
            return;
        }
        Vec3 toTarget = targetPos.m_82546_(cameraPos);
        double distance = toTarget.m_82553_();
        toTarget = distance < 1.0E-5 ? (lastTargetPos != Vec3.f_82478_ && lastTargetPos != targetPos ? ((distance = (toTarget = lastTargetPos.m_82546_(cameraPos)).m_82553_()) > 1.0E-5 ? toTarget.m_82490_(1.0 / distance) : new Vec3(0.0, 0.0, 1.0)) : new Vec3(0.0, 0.0, 1.0)) : toTarget.m_82490_(1.0 / distance);
        lastTargetPos = targetPos;
        double horizontalDist = Math.sqrt(toTarget.f_82479_ * toTarget.f_82479_ + toTarget.f_82481_ * toTarget.f_82481_);
        double denominator = Math.max(horizontalDist, 1.0E-5);
        double targetYaw = Math.toDegrees(Math.atan2(toTarget.f_82481_, toTarget.f_82479_)) - 90.0;
        double targetPitch = -Math.toDegrees(Math.atan2(toTarget.f_82480_, denominator));
        if (!TDECamera.isFinite(targetYaw) || !TDECamera.isFinite(targetPitch)) {
            targetYaw = currentRot.y;
            targetPitch = currentRot.x;
        }
        double maxPitchChange = 15.0;
        double currentPitch = currentRot.x;
        targetPitch = Mth.m_14008_((double)targetPitch, (double)(currentPitch - maxPitchChange), (double)(currentPitch + maxPitchChange));
        targetPitch = Mth.m_14008_((double)targetPitch, (double)-70.0, (double)70.0);
        double yawDiff = Mth.m_14175_((double)(targetYaw - currentRot.y));
        double pitchDiff = targetPitch - currentPitch;
        yawDiff = Mth.m_14008_((double)yawDiff, (double)-180.0, (double)180.0);
        pitchDiff = Mth.m_14008_((double)pitchDiff, (double)-90.0, (double)90.0);
        double edgeFactor = TDECamera.calculateEdgeFactor(screenPos);
        double turnSpeed = Mth.m_14008_((double)(0.15 * (1.0 - distance * 0.005) * edgeFactor), (double)0.03, (double)0.25);
        if (!TDECamera.isFinite(yawDiff) || !TDECamera.isFinite(pitchDiff) || !TDECamera.isFinite(turnSpeed)) return;
        ThirdPerson.CAMERA_AGENT.turnCamera(yawDiff * turnSpeed, pitchDiff * turnSpeed);
    }

    private static boolean isFinite(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }

    private static boolean isFinite(Vec3 vec) {
        return TDECamera.isFinite(vec.f_82479_) && TDECamera.isFinite(vec.f_82480_) && TDECamera.isFinite(vec.f_82481_);
    }

    private static boolean isFinite(Vector2d vec) {
        return TDECamera.isFinite(vec.x) && TDECamera.isFinite(vec.y);
    }

    private static boolean isInRelaxedZone(Vector2d screenPos) {
        double centerX = 0.5;
        double centerY = 0.5;
        double relaxedRadius = 0.15;
        double distToCenter = Math.sqrt(Math.pow(screenPos.x - centerX, 2.0) + Math.pow(screenPos.y - centerY, 2.0));
        return distToCenter < relaxedRadius;
    }

    private static double calculateEdgeFactor(Vector2d screenPos) {
        if (screenPos.x < 0.0 || screenPos.x > 1.0 || screenPos.y < 0.0 || screenPos.y > 1.0) {
            return 1.0;
        }
        double horizontalEdge = Math.max(Math.abs(screenPos.x - 0.5) - 0.15, 0.0) / 0.2;
        double verticalEdge = Math.max(Math.abs(screenPos.y - 0.5) - 0.15, 0.0) / 0.2;
        return Mth.m_14008_((double)Math.max(horizontalEdge, verticalEdge), (double)0.0, (double)1.0);
    }

    private static Vector2d worldToScreenPosition(Camera camera, Vec3 targetPos, float partialTicks) {
        Window window = Minecraft.m_91087_().m_91268_();
        int width = window.m_85441_();
        int height = window.m_85442_();
        Vector4f clipSpace = new Vector4f((float)(targetPos.f_82479_ - camera.m_90583_().f_82479_), (float)(targetPos.f_82480_ - camera.m_90583_().f_82480_), (float)(targetPos.f_82481_ - camera.m_90583_().f_82481_), 1.0f);
        Matrix4f viewMatrix = new Matrix4f();
        viewMatrix.rotate((float)Math.toRadians(-camera.m_90590_()), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        viewMatrix.rotate((float)Math.toRadians(-camera.m_90589_()), (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f));
        viewMatrix.transform(clipSpace);
        float fov = (float)Math.toRadians(((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue());
        float aspectRatio = (float)width / (float)height;
        if (aspectRatio < 0.01f) {
            aspectRatio = 1.777f;
        }
        Matrix4f projMatrix = new Matrix4f().perspective(fov, aspectRatio, 0.05f, 1000.0f);
        projMatrix.transform(clipSpace);
        if (Math.abs(clipSpace.w()) < 1.0E-5f) {
            return new Vector2d(-1.0, -1.0);
        }
        float ndcX = clipSpace.x() / clipSpace.w();
        float ndcY = clipSpace.y() / clipSpace.w();
        if (Float.isNaN(ndcX) || Float.isNaN(ndcY)) {
            return new Vector2d(-1.0, -1.0);
        }
        double screenX = ((double)ndcX + 1.0) / 2.0;
        double screenY = 1.0 - ((double)ndcY + 1.0) / 2.0;
        return new Vector2d(screenX, screenY);
    }

    private static Vec3 getTargetPosition(Entity entity, float partialTicks) {
        Vec3 lockPos;
        EnemyEntity enemyEntity;
        double heightOffset = (double)entity.m_20206_() * 0.6;
        Vec3 pos = entity.m_20318_(partialTicks);
        if (!(TDECamera.isFinite(pos.f_82479_) && TDECamera.isFinite(pos.f_82480_) && TDECamera.isFinite(pos.f_82481_))) {
            return lastValidTargetPos != Vec3.f_82478_ ? lastValidTargetPos : entity.m_20182_();
        }
        if (entity instanceof EnemyEntity && (enemyEntity = (EnemyEntity)entity).getLockPos() != null && TDECamera.isFinite(lockPos = enemyEntity.getLockPos())) {
            return new Vec3(lockPos.f_82479_, lockPos.f_82480_, lockPos.f_82481_);
        }
        return new Vec3(pos.f_82479_, pos.f_82480_ + heightOffset, pos.f_82481_);
    }
}

