/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.player;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.merlin204.tde.capabilitiy.player.TDEPlayerCapabilities;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import com.merlin204.tde.epicfight.api.animation.TDELivingMotions;
import com.merlin204.tde.epicfight.gameassets.animations.bipe.TDELivingAnimations;
import com.merlin204.tde.epicfight.gameassets.skill.sect.basic.BasicSect;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.epicfight.skill.registry.ChargedBasicAttacks;
import com.merlin204.tde.epicfight.skill.registry.CycleSkills;
import com.merlin204.tde.epicfight.skill.registry.DodgeSkills;
import com.merlin204.tde.epicfight.skill.registry.GuardSkills;
import com.merlin204.tde.epicfight.skill.registry.SoulfireSkills;
import com.merlin204.tde.item.weapon.TDEWeaponItem;
import com.merlin204.tde.item.weapon.TDEWeaponItemProperties;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class TDEServerPlayerPatch
extends ServerPlayerPatch {
    private boolean updatedMotionCurrentTick;
    private boolean updatedLiving = false;
    private boolean energyRecovery = true;
    public int stopEnergyRecoveryTime = 0;
    private ItemStack mainHandOld = null;
    private ItemStack offHandOld = null;

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        ((ServerPlayer)this.original).f_20916_ = 0;
        this.stopEnergyRecoveryTime = 30;
        ((ServerPlayer)this.original).getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES).ifPresent(abilities -> {
            abilities.get(AbilityType.ENERGY).sub(amount * 0.25f * (1.0f - abilities.get(AbilityType.ENERGY_DAMAGE_RESISTANCE).get()));
            abilities.syncToClient((Player)this.original);
        });
        return super.tryHurt(damageSource, amount);
    }

    public void onJoinWorld(ServerPlayer entity, EntityJoinLevelEvent event) {
        super.onJoinWorld(entity, event);
        CapabilitySkill skillCapability = this.getSkillCapability();
        skillCapability.skillContainers[SkillSlots.AIR_ATTACK.universalOrdinal()].setSkill(null);
        skillCapability.skillContainers[SkillSlots.GUARD.universalOrdinal()].setSkill(null);
        skillCapability.skillContainers[TDESkillSlots.EXECUTE.universalOrdinal()].setSkill(SoulfireSkills.EXECUTE);
        this.addSkill(TDESkillSlots.CYCLE_1, CycleSkills.EMPTY1);
        this.addSkill(TDESkillSlots.CYCLE_2, CycleSkills.EMPTY2);
        this.addSkill(TDESkillSlots.CYCLE_3, CycleSkills.EMPTY3);
        this.addSkill(TDESkillSlots.CYCLE_4, CycleSkills.EMPTY4);
        this.addSkill(TDESkillSlots.CYCLE_5, CycleSkills.EMPTY5);
        this.addSkill(TDESkillSlots.TDEGUARD, GuardSkills.BASICGUARD);
        this.addSkill(TDESkillSlots.CHARGED_ATTACK, ChargedBasicAttacks.CHARGED_ATTACK);
        this.addSkill((SkillSlot)SkillSlots.DODGE, DodgeSkills.BASICDODGE);
        this.addSkill(TDESkillSlots.SOULFIRE, SoulfireSkills.SOULFIRE);
        this.modifyLivingMotionByCurrentItem(false);
        this.tickSinceLastAction = 0;
        this.eventListeners.addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, PLAYER_EVENT_UUID, playerEvent -> this.resetActionTick());
        this.updatedLiving = false;
    }

    public void addSkill(SkillSlot skillSlot, Skill skill) {
        if (this.getSkill(skillSlot).getSkill() == null) {
            CapabilitySkill skillCapability = this.getSkillCapability();
            skillCapability.skillContainers[skillSlot.universalOrdinal()].setSkill(skill);
        }
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        SkillDataManager manager;
        super.tick(event);
        this.checkItem();
        if (this.stopEnergyRecoveryTime > 0) {
            --this.stopEnergyRecoveryTime;
            this.energyRecovery = false;
        }
        this.energyRecovery = true;
        if (this.getSkill(TDESkillSlots.CHARGED_ATTACK) != null && (manager = this.getSkill(TDESkillSlots.CHARGED_ATTACK).getDataManager()).hasData((SkillDataKey)TDEDatakeys.IS_CHARGING.get())) {
            boolean bl = this.energyRecovery = (Boolean)manager.getDataValue((SkillDataKey)TDEDatakeys.IS_CHARGING.get()) == false;
            if (manager.hasData((SkillDataKey)TDEDatakeys.CHARGING_POWER.get()) && !this.getEntityState().inaction()) {
                manager.setDataSync((SkillDataKey)TDEDatakeys.CHARGING_POWER.get(), (Object)Float.valueOf(0.0f), (ServerPlayer)this.original);
            }
        }
        manager = this.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager();
        if (!this.updatedLiving) {
            this.modifyLivingMotionByCurrentItem(false);
        }
        AttributeModifier stepHeight = new AttributeModifier(UUID.fromString("0aa15453-26e2-4e85-8042-1fe4c65a8c3c"), "Step Height", (double)0.6f, AttributeModifier.Operation.ADDITION);
        AttributeInstance stepInstance = ((ServerPlayer)this.getOriginal()).m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (stepInstance != null) {
            stepInstance.m_22130_(stepHeight);
            stepInstance.m_22125_(stepHeight);
        }
        UUID SPEED_MODIFIER_ID = UUID.fromString("b1a7e3d4-0a2f-4a3d-8d1e-7c8a5f3d9b1c");
        UUID HEALTH_MODIFIER_ID = UUID.fromString("b1a7e3d4-0a2f-4a3d-8e1e-7c8a5f5d9b1c");
        double SPRINT_SPEED_BOOST = 0.2;
        AttributeInstance movementSpeed = ((ServerPlayer)this.original).m_21051_(Attributes.f_22279_);
        AttributeInstance maxHealth = ((ServerPlayer)this.original).m_21051_(Attributes.f_22276_);
        if (movementSpeed != null) {
            AttributeModifier existingModifier = movementSpeed.m_22111_(SPEED_MODIFIER_ID);
            if (this.isEpicFightMode() && ((ServerPlayer)this.original).m_20142_()) {
                if (existingModifier == null || existingModifier.m_22218_() != 0.2) {
                    movementSpeed.m_22120_(SPEED_MODIFIER_ID);
                    movementSpeed.m_22118_(new AttributeModifier(SPEED_MODIFIER_ID, "Battle Sprint Boost", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL));
                }
            } else if (existingModifier != null) {
                movementSpeed.m_22120_(SPEED_MODIFIER_ID);
            }
        }
        double healthAdd = TDEAbilityUtils.getAbility(AbilityType.VITALITY, (Player)this.original) + TDEAbilityUtils.getAbility(AbilityType.STAMINA, (Player)this.original) * 0.5f + TDEAbilityUtils.getAbility(AbilityType.STRENGTH, (Player)this.original) * 0.2f;
        if (maxHealth != null) {
            AttributeModifier healthModifier = maxHealth.m_22111_(HEALTH_MODIFIER_ID);
            if (this.isEpicFightMode()) {
                if (healthModifier == null || healthModifier.m_22218_() != healthAdd) {
                    maxHealth.m_22120_(HEALTH_MODIFIER_ID);
                    maxHealth.m_22118_(new AttributeModifier(HEALTH_MODIFIER_ID, "tde healthAdd", healthAdd, AttributeModifier.Operation.ADDITION));
                    ((ServerPlayer)this.getOriginal()).m_5634_(999999.0f);
                }
            } else if (healthModifier != null) {
                maxHealth.m_22120_(HEALTH_MODIFIER_ID);
            }
        }
        ((ServerPlayer)this.original).getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES).ifPresent(abilities -> {
            abilities.get(AbilityType.MANA).add(abilities.get(AbilityType.MANA_RECOVERY_SPEED).getCurrentMax());
            if (this.isEpicFightMode()) {
                if (((ServerPlayer)this.original).m_20142_()) {
                    float cost = 1.0f - abilities.get(AbilityType.ENERGY_COST_EFFICIENCY).getCurrentMax();
                    float currentEnergy = abilities.get(AbilityType.ENERGY).get();
                    if (currentEnergy >= cost) {
                        abilities.get(AbilityType.ENERGY).sub(cost);
                    } else {
                        ((ServerPlayer)this.original).m_6858_(false);
                    }
                } else if (!this.getEntityState().inaction() && this.energyRecovery && this.stopEnergyRecoveryTime == 0) {
                    abilities.get(AbilityType.ENERGY).add(abilities.get(AbilityType.ENERGY_RECOVERY_SPEED).getCurrentMax());
                }
            } else if (!this.getEntityState().inaction() && this.energyRecovery && this.stopEnergyRecoveryTime == 0) {
                abilities.get(AbilityType.ENERGY).add(abilities.get(AbilityType.ENERGY_RECOVERY_SPEED).getCurrentMax());
            }
            abilities.syncToClient((Player)this.original);
        });
        this.updatedMotionCurrentTick = false;
    }

    public void energyDamageAtk(EnemyPatch enemyPatch, float amount) {
        float cost = amount * TDEAbilityUtils.getAbility(AbilityType.ENERGY_DAMAGE_BOOST, (Player)this.original);
        ((EnemyEntity)enemyPatch.getOriginal()).costEnergy(cost);
        System.out.println("player energyAtk:" + cost);
    }

    public void costEnergy(float cost) {
        TDEAbilityUtils.subAbility(AbilityType.ENERGY, (Player)this.original, cost * TDEAbilityUtils.getAbility(AbilityType.ENERGY_COST_EFFICIENCY, (Player)this.original));
        System.out.println("player cost energy:" + cost * TDEAbilityUtils.getAbility(AbilityType.ENERGY_COST_EFFICIENCY, (Player)this.original));
    }

    public void hurtEnergyDamage(float amount) {
        TDEAbilityUtils.subAbility(AbilityType.ENERGY, (Player)this.original, 5.0f * amount * TDEAbilityUtils.getAbility(AbilityType.ENERGY_DAMAGE_RESISTANCE, (Player)this.original));
        System.out.println("player get energydamage:" + amount * TDEAbilityUtils.getAbility(AbilityType.ENERGY_DAMAGE_RESISTANCE, (Player)this.original));
    }

    public TDEWeaponItemProperties getTDETDEWeaponItemProperties(InteractionHand hand) {
        Item item = ((ServerPlayer)this.original).m_21120_(hand).m_41720_();
        if (item instanceof TDEWeaponItem) {
            TDEWeaponItem tdeWeaponItem = (TDEWeaponItem)item;
            return tdeWeaponItem.getProperties();
        }
        return null;
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        if (this.getTDETDEWeaponItemProperties(hand) == null) {
            return (SoundEvent)EpicFightSounds.BLUNT_HIT.get();
        }
        return this.getTDETDEWeaponItemProperties(hand).getHitSound();
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        if (this.getTDETDEWeaponItemProperties(hand) == null) {
            return (SoundEvent)EpicFightSounds.WHOOSH_SMALL.get();
        }
        return this.getTDETDEWeaponItemProperties(hand).getSwingSound();
    }

    public Collider getColliderMatching(InteractionHand hand) {
        if (this.getTDETDEWeaponItemProperties(hand) == null) {
            return ColliderPreset.FIST;
        }
        return this.getTDETDEWeaponItemProperties(hand).getTdeCollider().getCollider();
    }

    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getHitParticle();
    }

    public boolean isGuard() {
        if (this.getSkill(TDESkillSlots.TDEGUARD).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_GUARD.get()) != null) {
            return (Boolean)this.getSkill(TDESkillSlots.TDEGUARD).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_GUARD.get());
        }
        return false;
    }

    public boolean isCharging() {
        if (this.getSkill(TDESkillSlots.CHARGED_ATTACK).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_CHARGING.get()) != null) {
            return (Boolean)this.getSkill(TDESkillSlots.CHARGED_ATTACK).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_CHARGING.get());
        }
        return false;
    }

    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, TDELivingAnimations.TDE_IDLE);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_IDLE, TDELivingAnimations.TDE_IDLE);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_KNEEL, TDELivingAnimations.TDE_KNEEL);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_WALK, TDELivingAnimations.TDE_WALK);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_WALK_BACKWARD, TDELivingAnimations.TDE_WALK_BACKWARD);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_WALK_LEFT, TDELivingAnimations.TDE_WALK_LEFT);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_WALK_RIGHT, TDELivingAnimations.TDE_WALK_RIGHT);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_RUN, TDELivingAnimations.TDE_RUN);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_SNEAK, TDELivingAnimations.TDE_SNEAK);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_FALL, TDELivingAnimations.TDE_FALL);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_CLIMB, TDELivingAnimations.TDE_CLIMB);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_DIG, TDELivingAnimations.TDE_DIG);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_DEATH, TDELivingAnimations.TDE_DEATH);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_FLOAT, TDELivingAnimations.TDE_FLOAT);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_CREATIVE_IDLE, TDELivingAnimations.TDE_CREATIVE_IDLE);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_CREATIVE_FLY, TDELivingAnimations.TDE_CREATIVE_FLY);
        animator.addLivingAnimation((LivingMotion)LivingMotions.JUMP, TDELivingAnimations.TDE_JUMP_RUN);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_JUMP_RUN, TDELivingAnimations.TDE_JUMP_RUN);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_JUMP_WALK, TDELivingAnimations.TDE_JUMP_WALK);
    }

    public float getDamage(InteractionHand hand) {
        Item item = ((ServerPlayer)this.original).m_21120_(hand).m_41720_();
        if (item instanceof TDEWeaponItem) {
            TDEWeaponItem tdeWeaponItem = (TDEWeaponItem)item;
            return tdeWeaponItem.getDamage();
        }
        return 0.0f;
    }

    private Map<LivingMotion, AssetAccessor<? extends StaticAnimation>> getDefaultLivingAnimations() {
        HashMap defaultAnimations = Maps.newHashMap();
        defaultAnimations.put(LivingMotions.IDLE, TDELivingAnimations.TDE_IDLE);
        defaultAnimations.put(TDELivingMotions.TDE_IDLE, TDELivingAnimations.TDE_IDLE);
        defaultAnimations.put(TDELivingMotions.TDE_KNEEL, TDELivingAnimations.TDE_KNEEL);
        defaultAnimations.put(TDELivingMotions.TDE_WALK, TDELivingAnimations.TDE_WALK);
        defaultAnimations.put(TDELivingMotions.TDE_RUN, TDELivingAnimations.TDE_RUN);
        defaultAnimations.put(TDELivingMotions.TDE_SNEAK, TDELivingAnimations.TDE_SNEAK);
        defaultAnimations.put(TDELivingMotions.TDE_FALL, TDELivingAnimations.TDE_FALL);
        defaultAnimations.put(TDELivingMotions.TDE_CLIMB, TDELivingAnimations.TDE_CLIMB);
        defaultAnimations.put(TDELivingMotions.TDE_DIG, TDELivingAnimations.TDE_DIG);
        defaultAnimations.put(LivingMotions.JUMP, TDELivingAnimations.TDE_JUMP_RUN);
        defaultAnimations.put(TDELivingMotions.TDE_FLOAT, TDELivingAnimations.TDE_FLOAT);
        return defaultAnimations;
    }

    public int getDefendLevel() {
        TDEWeaponItem tdeWeaponItem;
        int a = 0;
        int b = 0;
        int c = 0;
        Item item = ((ServerPlayer)this.original).m_21205_().m_41720_();
        if (item instanceof TDEWeaponItem) {
            tdeWeaponItem = (TDEWeaponItem)item;
            a = tdeWeaponItem.getProperties().getDefendBonus();
        }
        if ((item = ((ServerPlayer)this.original).m_21206_().m_41720_()) instanceof TDEWeaponItem) {
            tdeWeaponItem = (TDEWeaponItem)item;
            b = tdeWeaponItem.getProperties().getDefendBonus();
        }
        if ((item = this.getSkill(TDESkillSlots.SECT).getSkill()) instanceof BasicSect) {
            BasicSect basicSect = (BasicSect)item;
            c = basicSect.getDefendLevel();
            switch (basicSect.getGuardType()) {
                case OFF: {
                    a = 0;
                    break;
                }
                case MAIN: {
                    b = 0;
                }
            }
        }
        return a + b + c;
    }

    public int getPerfectDodgeTime() {
        return (Integer)this.getSkill((SkillSlot)SkillSlots.DODGE).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.PERFECT_DODGE_TIME.get());
    }

    public int getPerfectGuardTime() {
        return (Integer)this.getSkill(TDESkillSlots.TDEGUARD).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.PERFECT_GUARD_TIME.get());
    }

    private void checkItem() {
        ItemStack offHandNew;
        boolean shouldModify = false;
        ItemStack mainHandNew = ((ServerPlayer)this.original).m_21205_();
        if (mainHandNew != this.mainHandOld) {
            boolean mainHandChange = this.checkItemChange(this.mainHandOld, mainHandNew);
            shouldModify |= mainHandChange;
        }
        if ((offHandNew = ((ServerPlayer)this.original).m_21206_()) != this.offHandOld) {
            boolean offHandChange = this.checkItemChange(this.offHandOld, offHandNew);
            shouldModify |= offHandChange;
        }
        if (shouldModify) {
            this.modifyLivingMotionByCurrentItem(false);
        }
        this.mainHandOld = mainHandNew;
        this.offHandOld = offHandNew;
    }

    private boolean checkItemChange(ItemStack oldStack, ItemStack newStack) {
        if (oldStack == null || newStack == null) {
            return true;
        }
        if (!(oldStack.m_41720_() instanceof TDEWeaponItem) && !(newStack.m_41720_() instanceof TDEWeaponItem)) {
            return false;
        }
        if (oldStack.m_41720_() instanceof TDEWeaponItem != newStack.m_41720_() instanceof TDEWeaponItem) {
            return true;
        }
        TDEWeaponItem oldWeapon = (TDEWeaponItem)oldStack.m_41720_();
        TDEWeaponItem newWeapon = (TDEWeaponItem)newStack.m_41720_();
        return oldWeapon.getProperties().getWeaponType() != newWeapon.getProperties().getWeaponType();
    }

    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            Multimap modifiers;
            if (!from.m_41619_()) {
                modifiers = from.m_41638_(EquipmentSlot.MAINHAND);
                modifiers.get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22130_(arg_0));
            }
            if (!fromCap.isEmpty()) {
                modifiers = fromCap.getAllAttributeModifiers(EquipmentSlot.MAINHAND);
                modifiers.get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).m_22130_(arg_0));
                modifiers.get((Object)((Attribute)EpicFightAttributes.IMPACT.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).m_22130_(arg_0));
                modifiers.get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).m_22130_(arg_0));
                modifiers.get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22130_(arg_0));
            }
            if (!to.m_41619_()) {
                modifiers = to.m_41638_(EquipmentSlot.MAINHAND);
                modifiers.get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22118_(arg_0));
            }
            if (!toCap.isEmpty()) {
                modifiers = toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, (LivingEntityPatch)this);
                modifiers.get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).m_22118_(arg_0));
                modifiers.get((Object)((Attribute)EpicFightAttributes.IMPACT.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).m_22118_(arg_0));
                modifiers.get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).m_22118_(arg_0));
                modifiers.get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22118_(arg_0));
            }
        }
    }

    public void modifyLivingMotionByCurrentItem(boolean checkOldAnimations) {
        boolean isBasicSectActive;
        if (this.updatedMotionCurrentTick && checkOldAnimations) {
            return;
        }
        Map oldLivingAnimations = this.getAnimator().getLivingAnimations();
        HashMap newLivingAnimations = Maps.newHashMap();
        SkillContainer basicAttackContainer = this.getSkill(TDESkillSlots.SECT);
        boolean bl = isBasicSectActive = basicAttackContainer != null && basicAttackContainer.getSkill() instanceof BasicSect;
        if (isBasicSectActive) {
            BasicSect sectSkill = (BasicSect)basicAttackContainer.getSkill();
            if (sectSkill.checkAllowed((Player)this.original)) {
                Map<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> map = sectSkill.getLivingAnimations();
                map.forEach((motion, accessor) -> {
                    newLivingAnimations.put(motion, accessor);
                    this.updatedLiving = true;
                });
            } else {
                newLivingAnimations.putAll(this.getDefaultLivingAnimations());
                this.updatedLiving = true;
            }
        } else {
            newLivingAnimations.putAll(this.getDefaultLivingAnimations());
            this.updatedLiving = true;
        }
        for (Map.Entry entry : newLivingAnimations.entrySet()) {
            AssetAccessor newAnim = (AssetAccessor)entry.getValue();
            AssetAccessor oldAnim = (AssetAccessor)oldLivingAnimations.get(entry.getKey());
            if (oldAnim != null && oldAnim.equals(newAnim)) continue;
            this.updatedMotionCurrentTick = true;
            break;
        }
        if (this.updatedMotionCurrentTick || !checkOldAnimations) {
            this.getAnimator().resetLivingAnimations();
            newLivingAnimations.forEach((arg_0, arg_1) -> ((Animator)this.getAnimator()).addLivingAnimation(arg_0, arg_1));
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((ServerPlayer)this.original).m_19879_());
            msg.putEntries(newLivingAnimations.entrySet());
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf((Object)msg, (ServerPlayer)((ServerPlayer)this.original));
        }
    }

    public boolean applyStun(StunType stunType, float stunTime) {
        return false;
    }
}

