/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.player;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.player.client.TDECamera;
import com.merlin204.tde.epicfight.api.animation.TDELivingMotions;
import com.merlin204.tde.epicfight.gameassets.animations.bipe.TDELivingAnimations;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.epicfight.skill.registry.ChargedBasicAttacks;
import com.merlin204.tde.epicfight.skill.registry.CycleSkills;
import com.merlin204.tde.epicfight.skill.registry.DodgeSkills;
import com.merlin204.tde.epicfight.skill.registry.GuardSkills;
import com.merlin204.tde.epicfight.skill.registry.SoulfireSkills;
import com.merlin204.tde.item.weapon.TDEWeaponItem;
import com.merlin204.tde.item.weapon.TDEWeaponItemProperties;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.forgeevent.UpdatePlayerMotionEvent;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPSetPlayerTarget;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

@OnlyIn(value=Dist.CLIENT)
public class TDELocalPlayerPatch
extends LocalPlayerPatch {
    private LivingEntity target;
    private int searchTargetCooldown;
    private LivingEntity lastTarget;
    public int mainBackTick;
    public int offBackTick;
    private int lineOfSightCacheTime = 0;
    private Map<LivingEntity, Boolean> lineOfSightCache = new HashMap<LivingEntity, Boolean>();

    public void onJoinWorld(LocalPlayer entity, EntityJoinLevelEvent event) {
        super.onJoinWorld(entity, event);
        CapabilitySkill skillCapability = this.getSkillCapability();
        skillCapability.skillContainers[TDESkillSlots.EXECUTE.universalOrdinal()].setSkill(SoulfireSkills.EXECUTE);
        this.addSkill(TDESkillSlots.CYCLE_1, CycleSkills.EMPTY1);
        this.addSkill(TDESkillSlots.CYCLE_2, CycleSkills.EMPTY2);
        this.addSkill(TDESkillSlots.CYCLE_3, CycleSkills.EMPTY3);
        this.addSkill(TDESkillSlots.CYCLE_4, CycleSkills.EMPTY4);
        this.addSkill(TDESkillSlots.CYCLE_5, CycleSkills.EMPTY5);
        this.addSkill(TDESkillSlots.TDEGUARD, GuardSkills.BASICGUARD);
        this.addSkill(TDESkillSlots.CHARGED_ATTACK, ChargedBasicAttacks.CHARGED_ATTACK);
        this.addSkill((SkillSlot)SkillSlots.DODGE, DodgeSkills.BASICDODGE);
        this.addSkill(TDESkillSlots.SOULFIRE, SoulfireSkills.SOULFIRE);
        this.tickSinceLastAction = 0;
        this.eventListeners.addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, PLAYER_EVENT_UUID, playerEvent -> this.resetActionTick());
    }

    public void addSkill(SkillSlot skillSlot, Skill skill) {
        if (this.getSkill(skillSlot).getSkill() == null) {
            CapabilitySkill skillCapability = this.getSkillCapability();
            skillCapability.skillContainers[skillSlot.universalOrdinal()].setSkill(skill);
        }
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        if (this.mainBackTick > 0) {
            --this.mainBackTick;
        }
        if (this.offBackTick > 0) {
            --this.offBackTick;
        }
        if (this.searchTargetCooldown > 0) {
            --this.searchTargetCooldown;
        }
        Minecraft mc = Minecraft.m_91087_();
        ControllEngine.setKeyBind((KeyMapping)mc.f_91066_.f_92096_, (boolean)false);
    }

    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
        super.poseTick(animation, pose, elapsedTime, partialTicks);
        TDECamera.thirdCamera(this, partialTicks);
        if (this.target != null) {
            EpicFightNetworkManager.sendToServer((Object)new CPSetPlayerTarget(this.getTarget().m_19879_()));
            if (!this.target.m_6084_()) {
                this.searchTargetCooldown = 0;
                this.searchTarget(true);
            }
            this.setLockOn(true);
        } else {
            this.setLockOn(false);
        }
    }

    public boolean isTargetLockedOn() {
        return false;
    }

    public boolean isLockon() {
        return this.target != null;
    }

    public void setLockOn(boolean targetLockedOn) {
        super.setLockOn(targetLockedOn);
        if (!targetLockedOn) {
            this.target = null;
        }
    }

    public void searchTarget(boolean forceNew) {
        if (this.searchTargetCooldown > 0) {
            return;
        }
        Vec3 pos = ((LocalPlayer)this.original).m_20182_();
        AABB area = new AABB(pos.f_82479_ - 12.0, pos.f_82480_ - 8.0, pos.f_82481_ - 12.0, pos.f_82479_ + 12.0, pos.f_82480_ + 8.0, pos.f_82481_ + 12.0);
        List entities = ((LocalPlayer)this.original).m_9236_().m_6443_(LivingEntity.class, area, e -> e != this.original && e.m_6084_() && e instanceof EnemyEntity && (((LocalPlayer)this.original).m_142582_((Entity)e) || this.isTargetingPlayer((LivingEntity)e)));
        if (entities.isEmpty()) {
            this.target = null;
            this.setLockOn(false);
            return;
        }
        Vec3 lookVec = ((LocalPlayer)this.original).m_20154_();
        List candidateEntities = entities.stream().map(e -> {
            Vec3 toTarget = e.m_20182_().m_82546_(pos);
            double distance = toTarget.m_82553_();
            double frontDot = lookVec.m_82526_(toTarget.m_82541_());
            boolean isPriorityTarget = this.isTargetingPlayer((LivingEntity)e);
            return new EntityData((LivingEntity)e, distance, frontDot, isPriorityTarget);
        }).sorted(Comparator.comparingInt(data -> data.isPriorityTarget ? 0 : 1).thenComparingDouble(data -> data.frontDot > 0.86 ? 0.0 : 1.0).thenComparingDouble(data -> data.frontDot > 0.0 ? 2.0 : 3.0).thenComparingDouble(data -> -data.frontDot).thenComparingDouble(data -> data.distance)).collect(Collectors.toList());
        if (forceNew && this.target != null) {
            int currentIndex = -1;
            for (int i = 0; i < candidateEntities.size(); ++i) {
                if (!((EntityData)candidateEntities.get((int)i)).entity.equals((Object)this.target)) continue;
                currentIndex = i;
                break;
            }
            if (currentIndex == -1) {
                this.target = ((EntityData)candidateEntities.get((int)0)).entity;
            } else {
                int nextIndex = (currentIndex + 1) % candidateEntities.size();
                this.target = ((EntityData)candidateEntities.get((int)nextIndex)).entity;
            }
            this.lastTarget = this.target;
            this.setLockOn(true);
        } else {
            this.lastTarget = this.target = ((EntityData)candidateEntities.get((int)0)).entity;
            this.setLockOn(true);
        }
        this.searchTargetCooldown = 10;
    }

    private boolean hasLineOfSightCached(LivingEntity target) {
        return this.lineOfSightCache.computeIfAbsent(target, k -> ((LocalPlayer)this.original).m_142582_((Entity)target));
    }

    public void setTarget(LivingEntity entity) {
        this.target = this.target;
    }

    public LivingEntity getTarget() {
        if (this.target != null) {
            return this.target;
        }
        return super.getTarget();
    }

    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, TDELivingAnimations.TDE_IDLE);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_IDLE, TDELivingAnimations.TDE_IDLE);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_KNEEL, TDELivingAnimations.TDE_KNEEL);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_WALK, TDELivingAnimations.TDE_WALK);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_WALK_BACKWARD, TDELivingAnimations.TDE_WALK_BACKWARD);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_WALK_LEFT, TDELivingAnimations.TDE_WALK_LEFT);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_WALK_RIGHT, TDELivingAnimations.TDE_WALK_RIGHT);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_RUN, TDELivingAnimations.TDE_RUN);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_SNEAK, TDELivingAnimations.TDE_SNEAK);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_FALL, TDELivingAnimations.TDE_FALL);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_CLIMB, TDELivingAnimations.TDE_CLIMB);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_DIG, TDELivingAnimations.TDE_DIG);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_DEATH, TDELivingAnimations.TDE_DEATH);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_FLOAT, TDELivingAnimations.TDE_FLOAT);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_CREATIVE_IDLE, TDELivingAnimations.TDE_CREATIVE_IDLE);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_CREATIVE_FLY, TDELivingAnimations.TDE_CREATIVE_FLY);
        animator.addLivingAnimation((LivingMotion)LivingMotions.JUMP, TDELivingAnimations.TDE_JUMP_RUN);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_JUMP_RUN, TDELivingAnimations.TDE_JUMP_RUN);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.TDE_JUMP_WALK, TDELivingAnimations.TDE_JUMP_WALK);
    }

    public void rotateTo(Vec3 pos, float limit, boolean syncPrevRot) {
        Vec3 playerPosition = ((LivingEntity)this.original).m_20182_();
        float yaw = (float)MathUtils.getYRotOfVector((Vec3)pos.m_82546_(playerPosition));
        this.rotateTo(yaw, limit, syncPrevRot);
    }

    public void updateMotion(boolean considerInaction) {
        if (((AbstractClientPlayer)this.original).m_21223_() <= 0.0f) {
            this.currentLivingMotion = TDELivingMotions.TDE_DEATH;
        } else if (!this.state.updateLivingMotion() && considerInaction) {
            this.currentLivingMotion = LivingMotions.INACTION;
        } else {
            ClientAnimator animator = this.getClientAnimator();
            if (!((AbstractClientPlayer)this.original).m_21255_() && !((AbstractClientPlayer)this.original).m_21209_()) {
                if (((AbstractClientPlayer)this.original).m_20202_() != null) {
                    this.currentLivingMotion = ((AbstractClientPlayer)this.original).m_20202_() instanceof PlayerRideableJumping ? LivingMotions.MOUNT : LivingMotions.SIT;
                } else if (((AbstractClientPlayer)this.original).m_6067_()) {
                    this.currentLivingMotion = LivingMotions.SWIM;
                } else if (((AbstractClientPlayer)this.original).m_5803_()) {
                    this.currentLivingMotion = LivingMotions.SLEEP;
                } else if (!((AbstractClientPlayer)this.original).m_20096_() && ((AbstractClientPlayer)this.original).m_6147_()) {
                    this.currentLivingMotion = TDELivingMotions.TDE_CLIMB;
                } else if (!((AbstractClientPlayer)this.original).m_150110_().f_35935_) {
                    if (((AbstractClientPlayer)this.original).m_5842_() && ((AbstractClientPlayer)this.original).f_36106_ - ((AbstractClientPlayer)this.original).f_36103_ < -0.005) {
                        this.currentLivingMotion = TDELivingMotions.TDE_FLOAT;
                    } else if (!(((AbstractClientPlayer)this.original).f_36106_ - ((AbstractClientPlayer)this.original).f_36103_ < (double)-0.4f) && !this.isAirborneState()) {
                        if (this.isMoving()) {
                            this.currentLivingMotion = ((AbstractClientPlayer)this.original).m_6047_() ? TDELivingMotions.TDE_SNEAK : (((AbstractClientPlayer)this.original).m_20142_() ? TDELivingMotions.TDE_RUN : TDELivingMotions.TDE_WALK);
                            animator.baseLayer.animationPlayer.setReversed(this.dz < 0.0);
                        } else {
                            animator.baseLayer.animationPlayer.setReversed(false);
                            this.currentLivingMotion = ((AbstractClientPlayer)this.original).m_6047_() ? TDELivingMotions.TDE_KNEEL : LivingMotions.IDLE;
                        }
                    } else {
                        this.currentLivingMotion = TDELivingMotions.TDE_FALL;
                    }
                } else {
                    this.currentLivingMotion = this.isMoving() ? TDELivingMotions.TDE_CREATIVE_FLY : TDELivingMotions.TDE_CREATIVE_IDLE;
                }
            } else {
                this.currentLivingMotion = LivingMotions.FLY;
            }
        }
        UpdatePlayerMotionEvent.BaseLayer baseLayerEvent = new UpdatePlayerMotionEvent.BaseLayer((AbstractClientPlayerPatch)this, this.currentLivingMotion, !this.state.updateLivingMotion() && considerInaction);
        MinecraftForge.EVENT_BUS.post((Event)baseLayerEvent);
        this.currentLivingMotion = baseLayerEvent.getMotion();
        CapabilityItem activeItemCap = this.getHoldingItemCapability(((AbstractClientPlayer)this.original).m_7655_());
        if (((AbstractClientPlayer)this.original).m_6117_()) {
            UseAnim useAnim = ((AbstractClientPlayer)this.original).m_21211_().m_41780_();
            UseAnim capUseAnim = activeItemCap.getUseAnimation((LivingEntityPatch)this);
            this.currentCompositeMotion = useAnim != UseAnim.BLOCK && capUseAnim != UseAnim.BLOCK ? (useAnim != UseAnim.BOW && useAnim != UseAnim.SPEAR ? (useAnim == UseAnim.CROSSBOW ? LivingMotions.RELOAD : (useAnim == UseAnim.DRINK ? LivingMotions.DRINK : (useAnim == UseAnim.EAT ? LivingMotions.EAT : (useAnim == UseAnim.SPYGLASS ? LivingMotions.SPECTATE : this.currentLivingMotion)))) : LivingMotions.AIM) : (activeItemCap.getWeaponCategory() == CapabilityItem.WeaponCategories.SHIELD ? LivingMotions.BLOCK_SHIELD : LivingMotions.BLOCK);
        } else {
            this.currentCompositeMotion = ((AbstractClientPlayer)this.original).m_21205_().m_41720_() instanceof ProjectileWeaponItem && CrossbowItem.m_40932_((ItemStack)((AbstractClientPlayer)this.original).m_21205_()) ? LivingMotions.AIM : (((DynamicAnimation)this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getAnimation().get()).isReboundAnimation() ? LivingMotions.NONE : this.currentLivingMotion);
        }
        UpdatePlayerMotionEvent.CompositeLayer compositeLayerEvent = new UpdatePlayerMotionEvent.CompositeLayer((AbstractClientPlayerPatch)this, this.currentCompositeMotion);
        MinecraftForge.EVENT_BUS.post((Event)compositeLayerEvent);
        this.currentCompositeMotion = compositeLayerEvent.getMotion();
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        if (this.getTDETDEWeaponItemProperties(hand) == null) {
            return (SoundEvent)EpicFightSounds.BLUNT_HIT.get();
        }
        return this.getTDETDEWeaponItemProperties(hand).getHitSound();
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        if (this.getTDETDEWeaponItemProperties(hand) == null) {
            return (SoundEvent)EpicFightSounds.WHOOSH_SMALL.get();
        }
        return this.getTDETDEWeaponItemProperties(hand).getSwingSound();
    }

    public void costEnergy(float cost) {
        TDEAbilityUtils.subAbility(AbilityType.ENERGY, (Player)this.original, cost * TDEAbilityUtils.getAbility(AbilityType.ENERGY_COST_EFFICIENCY, (Player)this.original));
        System.out.println("player cost energy:" + cost * TDEAbilityUtils.getAbility(AbilityType.ENERGY_COST_EFFICIENCY, (Player)this.original));
    }

    public int getPerfectDodgeTime() {
        return (Integer)this.getSkill((SkillSlot)SkillSlots.DODGE).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.PERFECT_DODGE_TIME.get());
    }

    public int getPerfectGuardTime() {
        return (Integer)this.getSkill(TDESkillSlots.TDEGUARD).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.PERFECT_GUARD_TIME.get());
    }

    public Collider getColliderMatching(InteractionHand hand) {
        if (this.getTDETDEWeaponItemProperties(hand) == null) {
            return ColliderPreset.FIST;
        }
        return this.getTDETDEWeaponItemProperties(hand).getTdeCollider().getCollider();
    }

    public TDEWeaponItemProperties getTDETDEWeaponItemProperties(InteractionHand hand) {
        Item item = ((LocalPlayer)this.original).m_21120_(hand).m_41720_();
        if (item instanceof TDEWeaponItem) {
            TDEWeaponItem tdeWeaponItem = (TDEWeaponItem)item;
            return tdeWeaponItem.getProperties();
        }
        return null;
    }

    private boolean isTargetingPlayer(LivingEntity enemy) {
        if (enemy instanceof EnemyEntity) {
            EnemyEntity mob = (EnemyEntity)enemy;
            return mob.m_5448_() == this.original;
        }
        return false;
    }

    public boolean applyStun(StunType stunType, float stunTime) {
        return false;
    }

    private static class EntityData {
        final LivingEntity entity;
        final double distance;
        final double frontDot;
        final boolean isPriorityTarget;

        EntityData(LivingEntity entity, double distance, double frontDot, boolean isPriorityTarget) {
            this.entity = entity;
            this.distance = distance;
            this.frontDot = frontDot;
            this.isPriorityTarget = isPriorityTarget;
        }
    }
}

