/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.enemy;

import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.epicfight.api.animation.TDELivingMotions;
import com.merlin204.tde.item.weapon.TDEWeaponItem;
import com.merlin204.tde.item.weapon.TDEWeaponItemProperties;
import com.merlin204.tde.world.AtkDirection;
import com.merlin204.tde.world.TDEDamageSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;

public class EnemyPatch
extends MobPatch<EnemyEntity> {
    public float getRootYRot() {
        JointTransform transform = this.getAnimator().getPose(1.0f).get("Root");
        if (transform == null) {
            return 0.0f;
        }
        float x = -transform.rotation().x;
        float y = -transform.rotation().y;
        float z = -transform.rotation().z;
        float w = transform.rotation().w;
        float yaw = (float)Math.atan2(2.0f * (w * y - z * x), w * w - x * x - y * y + z * z);
        yaw = (float)Math.toDegrees(yaw);
        float sinP = 2.0f * (w * y - z * x);
        sinP = Math.max(-1.0f, Math.min(1.0f, sinP));
        float pitchY = (float)Math.asin(sinP);
        float rollX1 = (float)Math.atan2(2.0f * (w * x + y * z), 1.0f - 2.0f * (x * x + y * y));
        float yawZ1 = (float)Math.atan2(2.0f * (w * z + x * y), 1.0f - 2.0f * (y * y + z * z));
        float rollX = (float)Math.toDegrees(rollX1);
        pitchY = (float)Math.toDegrees(pitchY);
        float yawZ = (float)Math.toDegrees(yawZ1);
        return yaw;
    }

    public void onConstructed(EnemyEntity entity) {
        Animator animator;
        this.original = entity;
        this.armature = entity.getArmature();
        this.animator = animator = EpicFightSharedConstants.getAnimator((LivingEntityPatch)this);
        this.initAnimator(animator);
        animator.postInit();
    }

    public void updateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((Mob)this.original).m_21223_() <= 0.0f ? LivingMotions.DEATH : (((EnemyEntity)this.getOriginal()).isGuarding() && !this.getEntityState().inaction() ? TDELivingMotions.TDE_BLOCK : (this.state.inaction() && considerInaction ? LivingMotions.IDLE : (!(((Mob)this.original).m_20184_().f_82480_ < (double)-0.55f) && !this.isAirborneState() ? (((Mob)this.original).f_267362_.m_267731_() > 0.01f ? (((EnemyEntity)this.original).isWonder() ? (((EnemyEntity)this.original).getWonderClockwise() ? TDELivingMotions.WONDER_L : TDELivingMotions.WONDER_R) : LivingMotions.WALK) : LivingMotions.IDLE) : LivingMotions.IDLE)));
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    public boolean applyStun(StunType stunType, float stunTime) {
        return false;
    }

    public AssetAccessor<? extends StaticAnimation> getTDEhitAnimation(TDEDamageSource damageSource) {
        if (((EnemyEntity)this.original).isKnockdown()) {
            return null;
        }
        AtkDirection atkDirection = damageSource.getAtkDirection();
        switch (atkDirection) {
            case LEFT: {
                return null;
            }
            case RIGHT: {
                return null;
            }
            case MIDDLE: {
                return null;
            }
        }
        return null;
    }

    public void playHitAnimation(TDEDamageSource tdeDamageSource) {
        if (tdeDamageSource.getImpactLevel() > ((EnemyEntity)this.original).getDefendLevel() && this.getTDEhitAnimation(tdeDamageSource) != null) {
            this.playAnimationSynchronized(this.getTDEhitAnimation(tdeDamageSource), 0.1f);
        } else if (((EnemyEntity)this.original).getHitTick() <= 10) {
            ((EnemyEntity)this.original).setHitTick(20);
        }
    }

    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
        super.poseTick(animation, pose, elapsedTime, partialTicks);
    }

    public AssetAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return null;
    }

    public TDEWeaponItemProperties getTDETDEWeaponItemProperties(InteractionHand hand) {
        Item item = ((EnemyEntity)this.original).m_21120_(hand).m_41720_();
        if (item instanceof TDEWeaponItem) {
            TDEWeaponItem tdeWeaponItem = (TDEWeaponItem)item;
            return tdeWeaponItem.getProperties();
        }
        return null;
    }

    public OpenMatrix4f getModelMatrix(float partialTicks) {
        return MathUtils.getModelMatrixIntegral((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((EnemyEntity)this.original).f_19860_, (float)((EnemyEntity)this.original).m_146909_(), (float)((EnemyEntity)this.getOriginal()).getCorrectYRot(partialTicks), (float)((EnemyEntity)this.getOriginal()).getCorrectYRot(partialTicks), (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f).scale(1.0f, 1.0f, 1.0f);
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getKnockdownAnimation() {
        return null;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getKnockFlyAnimation() {
        return null;
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        if (((EnemyEntity)this.original).getHitTick() > 0) {
            ((EnemyEntity)this.original).setHitTick(((EnemyEntity)this.original).getHitTick() - 1);
        }
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        return this.getTDETDEWeaponItemProperties(hand).getHitSound();
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        return this.getTDETDEWeaponItemProperties(hand).getSwingSound();
    }
}

